/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupUtil;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToggleToolbarAction
extends ToggleAction
implements DumbAware {
    private final PropertiesComponent myPropertiesComponent;
    private final String myProperty;
    private final Supplier<? extends Iterable<? extends JComponent>> myProducer;

    @NotNull
    public static DefaultActionGroup createToggleToolbarGroup(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        return new DefaultActionGroup(new AnAction[]{new OptionsGroup(toolWindow), ToggleToolbarAction.createToolWindowAction(toolWindow, PropertiesComponent.getInstance((Project)project))});
    }

    @NotNull
    public static ToggleToolbarAction createAction(@NotNull String id2, @NotNull PropertiesComponent properties, @NotNull Supplier<? extends Iterable<? extends JComponent>> components) {
        return new ToggleToolbarAction(properties, ToggleToolbarAction.getShowToolbarProperty(id2), components);
    }

    @NotNull
    public static ToggleToolbarAction createToolWindowAction(final @NotNull ToolWindow toolWindow, final @NotNull PropertiesComponent properties) {
        toolWindow.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(@NotNull ContentManagerEvent event) {
                ContentManager contentManager2;
                JComponent component2 = event.getContent().getComponent();
                ToggleToolbarAction.setToolbarVisible(Collections.singletonList(component2), ToggleToolbarAction.isToolbarVisible(toolWindow, properties));
                ContentManager contentManager3 = contentManager2 = component2 instanceof DataProvider ? (ContentManager)PlatformDataKeys.CONTENT_MANAGER.getData((DataProvider)component2) : null;
                if (contentManager2 != null) {
                    contentManager2.addContentManagerListener((ContentManagerListener)this);
                }
            }
        });
        return new ToggleToolbarAction(properties, ToggleToolbarAction.getShowToolbarProperty(toolWindow), () -> Collections.singletonList(toolWindow.getContentManager().getComponent()));
    }

    public static void setToolbarVisible(@NotNull ToolWindow toolWindow, @NotNull PropertiesComponent properties, @Nullable Boolean visible) {
        boolean state = visible == null ? ToggleToolbarAction.isToolbarVisible(toolWindow, properties) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(toolWindow), properties, Collections.singletonList(toolWindow.getComponent()), state);
    }

    public static void setToolbarVisible(@NotNull String id2, @NotNull PropertiesComponent properties, @NotNull Iterable<? extends JComponent> components, @Nullable Boolean visible) {
        boolean state = visible == null ? ToggleToolbarAction.isToolbarVisible(id2, properties) : visible;
        ToggleToolbarAction.setToolbarVisibleImpl(ToggleToolbarAction.getShowToolbarProperty(id2), properties, components, state);
    }

    public static void setToolbarVisible(@NotNull Iterable<? extends JComponent> roots, boolean state) {
        for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars(roots)) {
            JComponent c = toolbar.getComponent();
            c.setVisible(state);
            Container parent = c.getParent();
            if (!(parent instanceof EditorHeaderComponent)) continue;
            parent.setVisible(state);
        }
    }

    public static boolean isToolbarVisible(@NotNull String property, @NotNull PropertiesComponent properties) {
        return ToggleToolbarAction.isSelectedImpl(properties, ToggleToolbarAction.getShowToolbarProperty(property));
    }

    public static boolean isToolbarVisible(@NotNull ToolWindow toolWindow, @NotNull PropertiesComponent properties) {
        return ToggleToolbarAction.isSelectedImpl(properties, ToggleToolbarAction.getShowToolbarProperty(toolWindow));
    }

    private ToggleToolbarAction(@NotNull PropertiesComponent propertiesComponent, @NotNull String property, @NotNull Supplier<? extends Iterable<? extends JComponent>> producer) {
        super(ActionsBundle.messagePointer((String)"action.ShowToolbar.text", (Object[])new Object[0]));
        this.myPropertiesComponent = propertiesComponent;
        this.myProperty = property;
        this.myProducer = producer;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        boolean hasToolbars = ToggleToolbarAction.iterateToolbars(this.myProducer.get()).iterator().hasNext();
        e.getPresentation().setVisible(hasToolbars);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        return this.isSelected();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        ToggleToolbarAction.setToolbarVisibleImpl(this.myProperty, this.myPropertiesComponent, this.myProducer.get(), state);
    }

    static void setToolbarVisibleImpl(@NotNull String property, @NotNull PropertiesComponent propertiesComponent, @NotNull Iterable<? extends JComponent> components, boolean visible) {
        propertiesComponent.setValue(property, String.valueOf(visible), String.valueOf(true));
        ToggleToolbarAction.setToolbarVisible(components, visible);
    }

    boolean isSelected() {
        return ToggleToolbarAction.isSelectedImpl(this.myPropertiesComponent, this.myProperty);
    }

    static boolean isSelectedImpl(@NotNull PropertiesComponent properties, @NotNull String property) {
        return properties.getBoolean(property, true);
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull ToolWindow window) {
        return ToggleToolbarAction.getShowToolbarProperty("ToolWindow" + window.getStripeTitle());
    }

    @NotNull
    static String getShowToolbarProperty(@NotNull String s) {
        return s + ".ShowToolbar";
    }

    @NotNull
    private static Iterable<ActionToolbar> iterateToolbars(Iterable<? extends JComponent> roots) {
        return ((JBTreeTraverser)UIUtil.uiTraverser(null).withRoots(roots)).preOrderDfsTraversal().filter(ActionToolbar.class);
    }

    private static class OptionsGroup
    extends ActionGroup
    implements DumbAware {
        private final ToolWindow myToolWindow;

        OptionsGroup(ToolWindow toolWindow) {
            super(IdeBundle.message((String)"group.view.options", (Object[])new Object[0]), true);
            this.myToolWindow = toolWindow;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setVisible(!ActionGroupUtil.isGroupEmpty((ActionGroup)this, (AnActionEvent)e, (boolean)LaterInvocator.isInModalContext()));
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            JComponent contentComponent;
            ContentManager contentManager2 = this.myToolWindow.getContentManager();
            Content selectedContent = contentManager2.getSelectedContent();
            JComponent jComponent = contentComponent = selectedContent != null ? selectedContent.getComponent() : null;
            if (contentComponent == null || e == null) {
                return EMPTY_ARRAY;
            }
            SmartList result2 = new SmartList();
            for (ActionToolbar toolbar : ToggleToolbarAction.iterateToolbars(Collections.singletonList(contentComponent))) {
                JComponent c = toolbar.getComponent();
                if (c.isVisible() || !c.isValid()) continue;
                if (!result2.isEmpty() && !(ContainerUtil.getLastItem((List)result2) instanceof Separator)) {
                    result2.add(Separator.getInstance());
                }
                List actions = toolbar.getActions();
                for (AnAction action2 : actions) {
                    if (action2 instanceof ToggleAction && !result2.contains(action2) && ActionGroupUtil.isActionEnabledAndVisible((AnAction)action2, (AnActionEvent)e, (boolean)LaterInvocator.isInModalContext())) {
                        result2.add(action2);
                        continue;
                    }
                    if (!(action2 instanceof Separator) || result2.isEmpty() || ContainerUtil.getLastItem((List)result2) instanceof Separator) continue;
                    result2.add(Separator.getInstance());
                }
            }
            boolean popup2 = ContainerUtil.count((Iterable)result2, it -> !(it instanceof Separator)) > 3;
            this.setPopup(popup2);
            if (!popup2 && !result2.isEmpty()) {
                result2.add(Separator.getInstance());
            }
            return result2.toArray(AnAction.EMPTY_ARRAY);
        }
    }
}

