/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.SettingsDialogFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Composite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowSettingsUtilImpl
extends ShowSettingsUtil {
    private static final Logger LOG = Logger.getInstance(ShowSettingsUtilImpl.class);

    @NotNull
    private static Project getProject(@Nullable Project project) {
        return project != null ? project : ProjectManager.getInstance().getDefaultProject();
    }

    @NotNull
    public static DialogWrapper getDialog(@Nullable Project project, @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable toSelect2) {
        return SettingsDialogFactory.getInstance().create(ShowSettingsUtilImpl.getProject(project), ShowSettingsUtilImpl.filterEmptyGroups(groups), toSelect2, null);
    }

    public static ConfigurableGroup @NotNull [] getConfigurableGroups(@Nullable Project project, boolean withIdeSettings) {
        ConfigurableGroup group = ConfigurableExtensionPointUtil.getConfigurableGroup(project, withIdeSettings);
        return new ConfigurableGroup[]{group};
    }

    @NotNull
    public static List<Configurable> getConfigurables(@Nullable Project project, boolean withIdeSettings) {
        ConfigurableGroup group = ConfigurableExtensionPointUtil.getConfigurableGroup(project, withIdeSettings);
        ArrayList<Configurable> list2 = new ArrayList<Configurable>();
        ShowSettingsUtilImpl.collect(list2, group.getConfigurables());
        return list2;
    }

    private static void collect(List<? super Configurable> list2, Configurable ... configurables) {
        for (Configurable configurable2 : configurables) {
            list2.add((Configurable)configurable2);
            if (!(configurable2 instanceof Configurable.Composite)) continue;
            Configurable.Composite composite = (Configurable.Composite)configurable2;
            ShowSettingsUtilImpl.collect(list2, composite.getConfigurables());
        }
    }

    public void showSettingsDialog(@NotNull Project project, ConfigurableGroup ... groups) {
        try {
            ShowSettingsUtilImpl.getDialog(project, Arrays.asList(groups), null).show();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public <T extends Configurable> void showSettingsDialog(@Nullable Project project, @NotNull Class<T> configurableClass) {
        this.showSettingsDialog(project, configurableClass, null);
    }

    public <T extends Configurable> void showSettingsDialog(@Nullable Project project, @NotNull Class<T> configurableClass, @Nullable Consumer<? super T> additionalConfiguration) {
        assert (Configurable.class.isAssignableFrom(configurableClass)) : "Not a configurable: " + configurableClass.getName();
        this.showSettingsDialog(project, (? super Configurable it) -> ConfigurableWrapper.cast(configurableClass, (UnnamedConfigurable)it) != null, (? super Configurable it) -> {
            if (additionalConfiguration != null) {
                Configurable toConfigure = (Configurable)ConfigurableWrapper.cast(configurableClass, (UnnamedConfigurable)it);
                assert (toConfigure != null) : "Wrong configurable found: " + it.getClass();
                additionalConfiguration.accept(toConfigure);
            }
        });
    }

    public void showSettingsDialog(@Nullable Project project, final @NotNull Predicate<? super Configurable> predicate, @Nullable Consumer<? super Configurable> additionalConfiguration) {
        ConfigurableGroup[] groups = ShowSettingsUtilImpl.getConfigurableGroups(project, true);
        Configurable config2 = new ConfigurableVisitor(){

            @Override
            protected boolean accept(@NotNull Configurable configurable2) {
                return predicate.test(configurable2);
            }
        }.find(groups);
        assert (config2 != null) : "Cannot find configurable for specified predicate";
        if (additionalConfiguration != null) {
            additionalConfiguration.accept((Configurable)config2);
        }
        ShowSettingsUtilImpl.getDialog(project, Arrays.asList(groups), config2).show();
    }

    public void showSettingsDialog(@Nullable Project project, @NotNull String nameToSelect) {
        ConfigurableGroup group = ConfigurableExtensionPointUtil.getConfigurableGroup(project, true);
        List<Object> groups = group.getConfigurables().length == 0 ? Collections.emptyList() : Collections.singletonList(group);
        ShowSettingsUtilImpl.getDialog(project, groups, ShowSettingsUtilImpl.findPreselectedByDisplayName(nameToSelect, groups)).show();
    }

    @Nullable
    private static Configurable findPreselectedByDisplayName(@NotNull String preselectedConfigurableDisplayName, @NotNull List<? extends ConfigurableGroup> groups) {
        for (ConfigurableGroup configurableGroup : groups) {
            for (Configurable configurable2 : SearchUtil.expandGroup(configurableGroup)) {
                if (!preselectedConfigurableDisplayName.equals(configurable2.getDisplayName())) continue;
                return configurable2;
            }
        }
        return null;
    }

    public static void showSettingsDialog(@Nullable Project project, @Nullable String idToSelect, String filter2) {
        ConfigurableGroup group = ConfigurableExtensionPointUtil.getConfigurableGroup(project, true);
        if (group.getConfigurables().length == 0) {
            group = null;
        }
        Configurable configurableToSelect = idToSelect == null ? null : ConfigurableVisitor.findById(idToSelect, Collections.singletonList(group));
        SettingsDialogFactory.getInstance().create(ShowSettingsUtilImpl.getProject(project), Collections.singletonList(group), configurableToSelect, filter2).show();
    }

    public void showSettingsDialog(@NotNull Project project, @Nullable Configurable toSelect2) {
        List<ConfigurableGroup> groups = Collections.singletonList(ConfigurableExtensionPointUtil.getConfigurableGroup(project, true));
        ShowSettingsUtilImpl.getDialog(project, groups, toSelect2).show();
    }

    @NotNull
    private static List<ConfigurableGroup> filterEmptyGroups(@NotNull List<? extends ConfigurableGroup> group) {
        ArrayList<ConfigurableGroup> groups = new ArrayList<ConfigurableGroup>();
        for (ConfigurableGroup configurableGroup : group) {
            if (configurableGroup.getConfigurables().length <= 0) continue;
            groups.add(configurableGroup);
        }
        return groups;
    }

    public boolean editConfigurable(Project project, @NotNull Configurable configurable2) {
        return this.editConfigurable(project, ShowSettingsUtilImpl.createDimensionKey(configurable2), configurable2);
    }

    public boolean editConfigurable(Project project, @NotNull String dimensionServiceKey, @NotNull Configurable configurable2) {
        return this.editConfigurable(project, dimensionServiceKey, configurable2, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable2));
    }

    private static boolean isWorthToShowApplyButton(@NotNull Configurable configurable2) {
        return configurable2 instanceof Place.Navigator || configurable2 instanceof Composite || configurable2 instanceof TabbedConfigurable;
    }

    public boolean editConfigurable(Project project, @NotNull String dimensionServiceKey, @NotNull Configurable configurable2, boolean showApplyButton) {
        return ShowSettingsUtilImpl.editConfigurable(null, project, configurable2, dimensionServiceKey, null, showApplyButton);
    }

    public boolean editConfigurable(Project project, @NotNull Configurable configurable2, Runnable advancedInitialization) {
        return ShowSettingsUtilImpl.editConfigurable(null, project, configurable2, ShowSettingsUtilImpl.createDimensionKey(configurable2), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable2));
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable2) {
        return this.editConfigurable(parent, configurable2, null);
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull String displayName) {
        return this.editConfigurable(parent, displayName, (Runnable)null);
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull String displayName, @Nullable Runnable advancedInitialization) {
        ConfigurableGroup group = ConfigurableExtensionPointUtil.getConfigurableGroup(null, true);
        List<Object> groups = group.getConfigurables().length == 0 ? Collections.emptyList() : Collections.singletonList(group);
        Configurable configurable2 = ShowSettingsUtilImpl.findPreselectedByDisplayName(displayName, groups);
        if (configurable2 == null) {
            LOG.error("Cannot find configurable for name [" + displayName + "]");
            return false;
        }
        return this.editConfigurable(parent, configurable2, advancedInitialization);
    }

    public boolean editConfigurable(@Nullable Component parent, @NotNull Configurable configurable2, @Nullable Runnable advancedInitialization) {
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable2, ShowSettingsUtilImpl.createDimensionKey(configurable2), advancedInitialization, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable2));
    }

    private static boolean editConfigurable(@Nullable Component parent, @Nullable Project project, @NotNull Configurable configurable2, @NotNull String dimensionKey, final @Nullable Runnable advancedInitialization, boolean showApplyButton) {
        DialogWrapper editor = parent == null ? SettingsDialogFactory.getInstance().create(project, dimensionKey, configurable2, showApplyButton, false) : SettingsDialogFactory.getInstance().create(parent, dimensionKey, configurable2, showApplyButton, false);
        if (advancedInitialization != null) {
            new UiNotifyConnector.Once((Component)editor.getContentPane(), new Activatable(){

                public void showNotify() {
                    advancedInitialization.run();
                }
            });
        }
        return editor.showAndGet();
    }

    @NotNull
    public static String createDimensionKey(@NotNull Configurable configurable2) {
        return '#' + configurable2.getDisplayName().replace('\n', '_').replace(' ', '_');
    }

    public boolean editConfigurable(Component parent, @NotNull String dimensionServiceKey, @NotNull Configurable configurable2) {
        return ShowSettingsUtilImpl.editConfigurable(parent, null, configurable2, dimensionServiceKey, null, ShowSettingsUtilImpl.isWorthToShowApplyButton(configurable2));
    }
}

