/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SearchEverywhereBaseAction
extends AnAction {
    public void update(@NotNull AnActionEvent event) {
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        boolean hasContributors = this.hasContributors(dataContext);
        presentation2.setEnabled((!this.requiresProject() || project != null) && hasContributors);
        presentation2.setVisible(hasContributors);
    }

    protected boolean requiresProject() {
        return true;
    }

    protected boolean hasContributors(DataContext context) {
        return true;
    }

    protected void showInSearchEverywherePopup(@NotNull String searchProviderID, @NotNull AnActionEvent event, boolean useEditorSelection, boolean sendStatistics) {
        Project project = event.getProject();
        SearchEverywhereManager seManager = SearchEverywhereManager.getInstance(project);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("SearchEverywhere");
        if (seManager.isShown()) {
            if (searchProviderID.equals(seManager.getSelectedContributorID())) {
                seManager.toggleEverywhereFilter();
            } else {
                seManager.setSelectedContributor(searchProviderID);
                if (sendStatistics) {
                    FeatureUsageData data2 = SearchEverywhereUsageTriggerCollector.createData(searchProviderID).addInputEvent(event);
                    SearchEverywhereUsageTriggerCollector.trigger(project, "tabSwitched", data2);
                }
            }
            return;
        }
        if (sendStatistics) {
            FeatureUsageData data3 = SearchEverywhereUsageTriggerCollector.createData(searchProviderID).addInputEvent(event);
            SearchEverywhereUsageTriggerCollector.trigger(project, "dialogOpen", data3);
        }
        IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
        String searchText = StringUtil.nullize((String)((String)GotoActionBase.getInitialText((boolean)useEditorSelection, (AnActionEvent)event).first));
        seManager.show(searchProviderID, searchText, event);
    }
}

