/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.find.FindManager;
import com.intellij.find.FindUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchBackAction
extends EditorAction
implements DumbAware {
    public SearchBackAction() {
        super((EditorActionHandler)new Handler());
        this.setEnabledInModalContext(true);
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            FindManager findManager = FindManager.getInstance((Project)project);
            if (!findManager.selectNextOccurrenceWasPerformed() && findManager.findPreviousUsageInEditor(editor)) {
                return;
            }
            FindUtil.searchBack(project, editor, dataContext);
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                return false;
            }
            return !editor.isOneLineMode() && (Boolean)IncrementalFindAction.SEARCH_DISABLED.get((UserDataHolder)editor, (Object)false) == false;
        }
    }
}

