/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.SearchEverywhereBaseAction;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.actions.searcheverywhere.ActionSearchEverywhereContributor;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.InputEvent;
import javax.swing.SwingUtilities;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionAction
extends SearchEverywhereBaseAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        this.showInSearchEverywherePopup(ActionSearchEverywhereContributor.class.getSimpleName(), e, false, true);
    }

    public static void openOptionOrPerformAction(@NotNull Object element2, String enteredText, @Nullable Project project, @Nullable Component component2) {
        GotoActionAction.openOptionOrPerformAction(element2, enteredText, project, component2, 0);
    }

    private static void openOptionOrPerformAction(Object element2, String enteredText, @Nullable Project project, @Nullable Component component2, @JdkConstants.InputEventMask int modifiers) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project != null && project.isDisposed()) {
                return;
            }
            if (element2 instanceof OptionDescription) {
                OptionDescription optionDescription = (OptionDescription)element2;
                if (optionDescription.hasExternalEditor()) {
                    optionDescription.invokeInternalEditor();
                } else {
                    ShowSettingsUtilImpl.showSettingsDialog(project, optionDescription.getConfigurableId(), enteredText);
                }
            } else {
                IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> GotoActionAction.performAction(element2, component2, null, modifiers, null));
            }
        });
    }

    public static void performAction(@NotNull Object element2, @Nullable Component component2, @Nullable AnActionEvent e) {
        GotoActionAction.performAction(element2, component2, e, 0, null);
    }

    private static void performAction(Object element2, @Nullable Component component2, @Nullable AnActionEvent e, @JdkConstants.InputEventMask int modifiers, @Nullable Runnable callback2) {
        if (component2 == null) {
            return;
        }
        AnAction action2 = element2 instanceof AnAction ? (AnAction)element2 : ((GotoActionModel.ActionWrapper)element2).getAction();
        ApplicationManager.getApplication().invokeLater(() -> {
            DataManager instance = DataManager.getInstance();
            DataContext context = instance != null ? instance.getDataContext(component2) : DataContext.EMPTY_CONTEXT;
            InputEvent inputEvent = e != null ? e.getInputEvent() : null;
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action2, (InputEvent)inputEvent, (String)"GoToAction", (DataContext)context);
            if (inputEvent == null && modifiers != 0) {
                event = new AnActionEvent(null, event.getDataContext(), event.getPlace(), event.getPresentation(), event.getActionManager(), modifiers);
            }
            if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)event, (boolean)false)) {
                if (action2 instanceof ActionGroup && !((ActionGroup)action2).canBePerformed(context)) {
                    ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(event.getPresentation().getText(), (ActionGroup)action2, context, false, callback2, -1);
                    Window window = SwingUtilities.getWindowAncestor(component2);
                    if (window != null) {
                        popup2.showInCenterOf((Component)window);
                    } else {
                        popup2.showInFocusCenter();
                    }
                } else {
                    ActionManagerEx manager = ActionManagerEx.getInstanceEx();
                    manager.fireBeforeActionPerformed(action2, context, event);
                    ActionUtil.performActionDumbAware((AnAction)action2, (AnActionEvent)event);
                    if (callback2 != null) {
                        callback2.run();
                    }
                    manager.fireAfterActionPerformed(action2, context, event);
                }
            }
        });
    }

    @Override
    protected boolean requiresProject() {
        return false;
    }
}

