/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.annotations.NotNull;

public class FixLineSeparatorsAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project == null || vFiles == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            for (VirtualFile vFile : vFiles) {
                FixLineSeparatorsAction.fixSeparators(vFile);
            }
        }, IdeBundle.message((String)"command.fixing.line.separators", (Object[])new Object[0]), null);
    }

    private static void fixSeparators(@NotNull VirtualFile vFile) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)vFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                Document document;
                if (!file2.isDirectory() && !file2.getFileType().isBinary() && (document = FileDocumentManager.getInstance().getDocument(file2)) != null && FixLineSeparatorsAction.areSeparatorsBroken(document)) {
                    FixLineSeparatorsAction.fixSeparators(document);
                }
                return true;
            }
        });
    }

    private static boolean areSeparatorsBroken(@NotNull Document document) {
        int count = document.getLineCount();
        for (int i2 = 1; i2 < count; i2 += 2) {
            if (document.getLineStartOffset(i2) == document.getLineEndOffset(i2)) continue;
            return false;
        }
        return true;
    }

    private static void fixSeparators(@NotNull Document document) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (int i2 = 1; i2 < document.getLineCount(); ++i2) {
                int start2 = document.getLineEndOffset(i2);
                int end = document.getLineEndOffset(i2) + document.getLineSeparatorLength(i2);
                document.deleteString(start2, end);
            }
        });
    }
}

