/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpThreadsAction
extends AnAction
implements DumbAware {
    private final NotificationGroup GROUP = new NotificationGroup("Dump Threads Group", NotificationDisplayType.BALLOON, false, null, null, null, PluginManagerCore.CORE_ID);

    public void actionPerformed(@NotNull AnActionEvent e) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            File dumpDir = PerformanceWatcher.getInstance().dumpThreads("", false);
            Notification notification = this.createNotification(dumpDir);
            notification.notify(e.getProject());
        });
    }

    @NotNull
    private Notification createNotification(@Nullable File file2) {
        if (file2 != null) {
            String url = FileUtil.getUrl((File)file2);
            String message = IdeBundle.message((String)"thread.dump.is.taken", (Object[])new Object[]{url});
            return this.GROUP.createNotification("", message, NotificationType.INFORMATION, RevealFileAction.FILE_SELECTING_LISTENER);
        }
        return this.GROUP.createNotification(IdeBundle.message((String)"failed.to.take.thread.dump", (Object[])new Object[0]), NotificationType.INFORMATION);
    }
}

