/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.actions.CreateGroupHandler;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.util.IncorrectOperationException;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class CreatePackageHandler
extends CreateGroupHandler {
    private static final String DELIMITER = ".";
    private static final String REGEX_DELIMITER = Pattern.quote(".");
    @NotNull
    private final PsiDirectory myPackageRoot = this.getPackageRoot();
    @NotNull
    private final String myInitialText = this.buildInitialText();

    CreatePackageHandler(@NotNull Project project, @NotNull PsiDirectory directory) {
        super(project, directory);
    }

    public boolean checkInput(String inputString) {
        if (inputString.isEmpty() || inputString.equals(this.myInitialText)) {
            this.errorText = null;
            return true;
        }
        if (inputString.endsWith(DELIMITER)) {
            this.errorText = IdeBundle.message((String)"error.invalid.java.package.name.format", (Object[])new Object[0]);
            return false;
        }
        PsiDirectoryFactory nameValidator = PsiDirectoryFactory.getInstance(this.myProject);
        VirtualFile file2 = this.myPackageRoot.getVirtualFile();
        this.errorText = null;
        for (String token : inputString.split(REGEX_DELIMITER)) {
            if (token.isEmpty()) {
                this.errorText = IdeBundle.message((String)"error.invalid.java.package.name.format", (Object[])new Object[0]);
                return false;
            }
            if (file2 != null && (file2 = file2.findChild(token)) != null && !file2.isDirectory()) {
                this.errorText = IdeBundle.message((String)"error.file.with.name.already.exists", (Object[])new Object[]{token});
                return false;
            }
            if (!nameValidator.isValidPackageName(token)) {
                this.errorText = IdeBundle.message((String)"error.invalid.java.package.name", (Object[])new Object[0]);
            }
            if (!FileTypeManager.getInstance().isFileIgnored(token)) continue;
            this.errorText = IdeBundle.message((String)"warning.create.package.with.ignored.name", (Object[])new Object[]{token});
        }
        if (file2 != null) {
            this.errorText = IdeBundle.message((String)"error.package.with.name.already.exists", (Object[])new Object[]{file2.getName()});
            return false;
        }
        return true;
    }

    public boolean canClose(String packageName) {
        if (packageName.isEmpty() || packageName.equals(this.myInitialText)) {
            Messages.showMessageDialog((Project)this.myProject, (String)IdeBundle.message((String)"error.name.should.be.specified", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return false;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            String dirPath = this.myPackageRoot.getVirtualFile().getPresentableUrl();
            String actionName = IdeBundle.message((String)"progress.creating.package", (Object[])new Object[]{dirPath, packageName});
            LocalHistoryAction action2 = LocalHistory.getInstance().startAction(actionName);
            try {
                this.createdElement = DirectoryUtil.createSubdirectories(packageName, this.myPackageRoot, DELIMITER);
            }
            catch (IncorrectOperationException ex) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)this.myProject, (String)CreateElementActionBase.filterMessage((String)ex.getMessage()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon()));
            }
            finally {
                action2.finish();
            }
        }), IdeBundle.message((String)"command.create.package", (Object[])new Object[0]), null);
        return this.createdElement != null;
    }

    @Override
    @NotNull
    String getInitialText() {
        return this.myInitialText;
    }

    @NotNull
    private String buildInitialText() {
        if (this.myPackageRoot.isEquivalentTo((PsiElement)this.myDirectory)) {
            return "";
        }
        String root = this.myPackageRoot.getVirtualFile().getPath();
        String current2 = this.myDirectory.getVirtualFile().getPath();
        return current2.substring(root.length() + 1).replace("/", DELIMITER) + DELIMITER;
    }

    @NotNull
    private PsiDirectory getPackageRoot() {
        PsiDirectoryFactory manager = PsiDirectoryFactory.getInstance(this.myProject);
        PsiDirectory directory = this.myDirectory;
        for (PsiDirectory parent = directory.getParent(); parent != null && manager.isPackage(parent); parent = parent.getParent()) {
            directory = parent;
        }
        return directory;
    }
}

