/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.GeneratedSourceFileChangeTracker;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratedFileEditingNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"generated.source.file.editing.notification.panel");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (!GeneratedSourceFileChangeTracker.getInstance(project).isEditedGeneratedFile(file2)) {
            return null;
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText(GeneratedFileEditingNotificationProvider.getText(file2, project));
        return panel2;
    }

    private static @NlsContexts.LinkLabel @NotNull String getText(@NotNull VirtualFile file2, @NotNull Project project) {
        if (!project.isDisposed() && file2.isValid()) {
            for (GeneratedSourcesFilter filter2 : GeneratedSourcesFilter.EP_NAME.getExtensionList()) {
                String text;
                if (!filter2.isGeneratedSource(file2, project) || (text = filter2.getNotificationText(file2, project)) == null) continue;
                return text;
            }
        }
        return LangBundle.message((String)"link.label.generated.source.files", (Object[])new Object[0]);
    }
}

