/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.Patches;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.UIBundle;
import com.intellij.util.ReflectionUtil;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.datatransfer.DataTransferer;

public final class ClipboardSynchronizer
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ClipboardSynchronizer.class);
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.balloonGroup((String)"System Clipboard");
    private final ClipboardHandler myClipboardHandler = ApplicationManager.getApplication().isHeadlessEnvironment() && ApplicationManager.getApplication().isUnitTestMode() ? new HeadlessClipboardHandler() : (Patches.SLOW_GETTING_CLIPBOARD_CONTENTS && SystemInfo.isMac ? new MacClipboardHandler() : (Patches.SLOW_GETTING_CLIPBOARD_CONTENTS && SystemInfo.isXWindow ? new XWinClipboardHandler() : new ClipboardHandler()));

    public static ClipboardSynchronizer getInstance() {
        return (ClipboardSynchronizer)ApplicationManager.getApplication().getService(ClipboardSynchronizer.class);
    }

    public ClipboardSynchronizer() {
        this.myClipboardHandler.init();
    }

    public void dispose() {
        this.myClipboardHandler.dispose();
    }

    public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
        return ClipboardUtil.handleClipboardSafely(() -> this.myClipboardHandler.areDataFlavorsAvailable(flavors), false);
    }

    @Nullable
    public Transferable getContents() {
        return ClipboardUtil.handleClipboardSafely(this.myClipboardHandler::getContents, null);
    }

    @Nullable
    public Object getData(@NotNull DataFlavor dataFlavor) {
        return ClipboardUtil.handleClipboardSafely(() -> {
            try {
                return this.myClipboardHandler.getData(dataFlavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                LOG.debug((Throwable)e);
                return null;
            }
        }, null);
    }

    public void setContent(@NotNull Transferable content2, @NotNull ClipboardOwner owner) {
        this.myClipboardHandler.setContent(content2, owner);
    }

    public void resetContent() {
        this.myClipboardHandler.resetContent();
    }

    @Nullable
    private static Clipboard getClipboard() {
        try {
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (IllegalStateException e) {
            if (SystemInfo.isWindows) {
                LOG.debug("Clipboard is busy");
            } else {
                LOG.warn((Throwable)e);
            }
            return null;
        }
    }

    private static boolean areDataFlavorsAvailable(Transferable contents, DataFlavor ... flavors) {
        for (DataFlavor flavor : flavors) {
            if (!contents.isDataFlavorSupported(flavor)) continue;
            return true;
        }
        return false;
    }

    private static boolean areDataFlavorsAvailable(Collection<DataFlavor> contents, DataFlavor ... flavors) {
        for (DataFlavor flavor : flavors) {
            if (!contents.contains(flavor)) continue;
            return true;
        }
        return false;
    }

    private static class HeadlessClipboardHandler
    extends ClipboardHandler {
        private volatile Transferable myContent = null;

        private HeadlessClipboardHandler() {
        }

        @Override
        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            Transferable content2 = this.myContent;
            return content2 != null && ClipboardSynchronizer.areDataFlavorsAvailable(content2, flavors);
        }

        @Override
        public Transferable getContents() throws IllegalStateException {
            return this.myContent;
        }

        @Override
        @Nullable
        public Object getData(@NotNull DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
            return this.myContent.getTransferData(dataFlavor);
        }

        @Override
        public void setContent(@NotNull Transferable content2, @NotNull ClipboardOwner owner) {
            this.myContent = content2;
        }

        @Override
        public void resetContent() {
            this.myContent = null;
        }
    }

    private static class XWinClipboardHandler
    extends ClipboardHandler {
        private static final String DATA_TRANSFER_TIMEOUT_PROPERTY = "sun.awt.datatransfer.timeout";
        private static final String LONG_TIMEOUT = "2000";
        private static final String SHORT_TIMEOUT = "100";
        private static final FlavorTable FLAVOR_MAP = (FlavorTable)SystemFlavorMap.getDefaultFlavorMap();
        private volatile Transferable myCurrentContent = null;

        private XWinClipboardHandler() {
        }

        @Override
        public void init() {
            if (System.getProperty(DATA_TRANSFER_TIMEOUT_PROPERTY) == null) {
                System.setProperty(DATA_TRANSFER_TIMEOUT_PROPERTY, LONG_TIMEOUT);
            }
        }

        @Override
        public void dispose() {
            this.resetContent();
        }

        @Override
        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            Transferable currentContent = this.myCurrentContent;
            if (currentContent != null) {
                return ClipboardSynchronizer.areDataFlavorsAvailable(currentContent, flavors);
            }
            Collection<DataFlavor> contents = XWinClipboardHandler.checkContentsQuick();
            if (contents != null) {
                return ClipboardSynchronizer.areDataFlavorsAvailable(contents, flavors);
            }
            return super.areDataFlavorsAvailable(flavors);
        }

        @Override
        public Transferable getContents() throws IllegalStateException {
            Transferable currentContent = this.myCurrentContent;
            if (currentContent != null) {
                return currentContent;
            }
            Collection<DataFlavor> contents = XWinClipboardHandler.checkContentsQuick();
            if (contents != null && contents.isEmpty()) {
                return null;
            }
            return super.getContents();
        }

        @Override
        @Nullable
        public Object getData(@NotNull DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
            Transferable currentContent = this.myCurrentContent;
            if (currentContent != null) {
                return currentContent.getTransferData(dataFlavor);
            }
            Collection<DataFlavor> contents = XWinClipboardHandler.checkContentsQuick();
            if (contents != null && !contents.contains(dataFlavor)) {
                return null;
            }
            return super.getData(dataFlavor);
        }

        @Override
        public void setContent(@NotNull Transferable content2, @NotNull ClipboardOwner owner) {
            this.myCurrentContent = content2;
            super.setContent(content2, owner);
        }

        @Override
        public void resetContent() {
            this.myCurrentContent = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private static Collection<DataFlavor> checkContentsQuick() {
            Clipboard clipboard = ClipboardSynchronizer.getClipboard();
            if (clipboard == null) {
                return null;
            }
            Class<?> aClass = clipboard.getClass();
            if (!"sun.awt.X11.XClipboard".equals(aClass.getName())) {
                return null;
            }
            Method getClipboardFormats = ReflectionUtil.getDeclaredMethod(aClass, (String)"getClipboardFormats", (Class[])new Class[0]);
            if (getClipboardFormats == null) {
                return null;
            }
            String timeout = System.getProperty(DATA_TRANSFER_TIMEOUT_PROPERTY);
            System.setProperty(DATA_TRANSFER_TIMEOUT_PROPERTY, SHORT_TIMEOUT);
            try {
                Set<DataFlavor> set;
                long[] formats = (long[])getClipboardFormats.invoke((Object)clipboard, new Object[0]);
                if (formats == null || formats.length == 0) {
                    Set<DataFlavor> set2 = Collections.emptySet();
                    return set2;
                }
                Set<DataFlavor> set3 = set = DataTransferer.getInstance().getFlavorsForFormats(formats, FLAVOR_MAP).keySet();
                return set3;
            }
            catch (IllegalAccessException | IllegalArgumentException formats) {
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IllegalStateException) {
                    throw (IllegalStateException)cause;
                }
            }
            finally {
                System.setProperty(DATA_TRANSFER_TIMEOUT_PROPERTY, timeout);
            }
            return null;
        }
    }

    private static class MacClipboardHandler
    extends ClipboardHandler {
        private Pair<String, Transferable> myFullTransferable;

        private MacClipboardHandler() {
        }

        @Nullable
        private Transferable doGetContents() {
            return super.getContents();
        }

        @Override
        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            if (this.myFullTransferable == null) {
                return super.areDataFlavorsAvailable(flavors);
            }
            Transferable contents = this.getContents();
            return contents != null && ClipboardSynchronizer.areDataFlavorsAvailable(contents, flavors);
        }

        @Override
        public Transferable getContents() {
            Transferable transferable = this.doGetContents();
            if (transferable != null && this.myFullTransferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String stringData = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (stringData.equals(this.myFullTransferable.getFirst())) {
                        return (Transferable)this.myFullTransferable.getSecond();
                    }
                }
                catch (UnsupportedFlavorException | IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            this.myFullTransferable = null;
            return transferable;
        }

        @Override
        @Nullable
        public Object getData(@NotNull DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
            if (this.myFullTransferable == null) {
                return super.getData(dataFlavor);
            }
            Transferable contents = this.getContents();
            return contents == null ? null : contents.getTransferData(dataFlavor);
        }

        @Override
        public void setContent(@NotNull Transferable content2, @NotNull ClipboardOwner owner) {
            if (Registry.is((String)"ide.mac.useNativeClipboard") && content2.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String stringData = (String)content2.getTransferData(DataFlavor.stringFlavor);
                    this.myFullTransferable = Pair.create((Object)stringData, (Object)content2);
                    super.setContent(new StringSelection(stringData), owner);
                }
                catch (UnsupportedFlavorException | IOException e) {
                    LOG.info((Throwable)e);
                }
            } else {
                this.myFullTransferable = null;
                super.setContent(content2, owner);
            }
        }
    }

    private static class ClipboardHandler {
        private ClipboardHandler() {
        }

        public void init() {
        }

        public void dispose() {
        }

        public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
            Clipboard clipboard = ClipboardSynchronizer.getClipboard();
            if (clipboard == null) {
                return false;
            }
            for (DataFlavor flavor : flavors) {
                if (!clipboard.isDataFlavorAvailable(flavor)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public Transferable getContents() {
            Clipboard clipboard = ClipboardSynchronizer.getClipboard();
            return clipboard == null ? null : clipboard.getContents(this);
        }

        @Nullable
        public Object getData(@NotNull DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
            Clipboard clipboard = ClipboardSynchronizer.getClipboard();
            return clipboard == null ? null : clipboard.getData(dataFlavor);
        }

        public void setContent(@NotNull Transferable content2, @NotNull ClipboardOwner owner) {
            Clipboard clipboard = ClipboardSynchronizer.getClipboard();
            if (clipboard != null) {
                try {
                    clipboard.setContents(content2, owner);
                }
                catch (IllegalStateException e) {
                    LOG.debug((Throwable)e);
                    NOTIFICATION_GROUP.createNotification(UIBundle.message((String)"clipboard.is.unavailable", (Object[])new Object[0]), MessageType.WARNING).notify(null);
                }
            }
        }

        public void resetContent() {
        }
    }
}

