/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.framework.detection.impl.DetectedFrameworksData;
import com.intellij.framework.detection.impl.FrameworkDetectionContextImpl;
import com.intellij.framework.detection.impl.FrameworkDetectionIndex;
import com.intellij.framework.detection.impl.FrameworkDetectionIndexListener;
import com.intellij.framework.detection.impl.FrameworkDetectionUtil;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.framework.detection.impl.exclude.DetectionExcludesConfigurationImpl;
import com.intellij.framework.detection.impl.ui.ConfigureDetectedFrameworksDialog;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.LangBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.PlatformModifiableModelsProvider;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class FrameworkDetectionManager
implements FrameworkDetectionIndexListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(FrameworkDetectionManager.class);
    private static final NotificationGroup FRAMEWORK_DETECTION_NOTIFICATION = NotificationGroup.balloonGroup((String)"Framework Detection", (PluginId)PluginManagerCore.CORE_ID);
    private final Update myDetectionUpdate = new Update("detection"){

        public void run() {
            FrameworkDetectionManager.this.doRunDetection();
        }
    };
    private final IntSet myDetectorsToProcess = new IntOpenHashSet();
    private final Project myProject;
    private MergingUpdateQueue myDetectionQueue;
    private final Object myLock = new Object();
    private DetectedFrameworksData myDetectedFrameworksData;

    public static FrameworkDetectionManager getInstance(@NotNull Project project) {
        return (FrameworkDetectionManager)project.getComponent(FrameworkDetectionManager.class);
    }

    public FrameworkDetectionManager(@NotNull Project project) {
        this.myProject = project;
        if (!this.myProject.isDefault() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.doInitialize();
        }
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> {
            int[] ids = FrameworkDetectorRegistry.getInstance().getAllDetectorIds();
            Object object = this.myLock;
            synchronized (object) {
                this.myDetectorsToProcess.clear();
                this.myDetectorsToProcess.addAll((IntCollection)IntArrayList.wrap((int[])ids));
            }
            this.queueDetection();
        });
    }

    public void doInitialize() {
        this.myDetectionQueue = new MergingUpdateQueue("FrameworkDetectionQueue", 500, true, null, (Disposable)this.myProject, null, false);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myDetectionQueue.hideNotify();
        }
        this.myDetectedFrameworksData = new DetectedFrameworksData(this.myProject);
        FrameworkDetectionIndex.getInstance().addListener(this, (Disposable)this.myProject);
        this.myProject.getMessageBus().connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FrameworkDetectionManager.this.myDetectionQueue.suspend();
            }

            public void exitDumbMode() {
                FrameworkDetectionManager.this.myDetectionQueue.resume();
            }
        });
    }

    public void dispose() {
        this.doDispose();
    }

    public void doDispose() {
        if (this.myDetectedFrameworksData != null) {
            this.myDetectedFrameworksData.saveDetected();
            this.myDetectedFrameworksData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileUpdated(@NotNull VirtualFile file2, @NotNull Integer detectorId) {
        Object object = this.myLock;
        synchronized (object) {
            this.myDetectorsToProcess.add(detectorId.intValue());
        }
        this.queueDetection();
    }

    private void queueDetection() {
        if (this.myDetectionQueue != null) {
            this.myDetectionQueue.queue(this.myDetectionUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunDetection() {
        IntOpenHashSet detectorsToProcess;
        if (LightEdit.owns((Project)this.myProject)) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            detectorsToProcess = new IntOpenHashSet((IntCollection)this.myDetectorsToProcess);
            this.myDetectorsToProcess.clear();
        }
        if (detectorsToProcess.isEmpty()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting framework detectors: " + detectorsToProcess);
        }
        ArrayList<? extends DetectedFrameworkDescription> newDescriptions = new ArrayList<DetectedFrameworkDescription>();
        ArrayList oldDescriptions = new ArrayList();
        for (Integer id2 : detectorsToProcess) {
            List frameworks = (List)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> this.runDetector(id2, true));
            oldDescriptions.addAll(frameworks);
            Collection<? extends DetectedFrameworkDescription> updated = this.myDetectedFrameworksData.updateFrameworksList(id2, frameworks);
            newDescriptions.addAll(updated);
            oldDescriptions.removeAll(updated);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(frameworks.size() + " frameworks detected, " + updated.size() + " changed");
        }
        if (!newDescriptions.isEmpty()) {
            HashSet frameworkNames = new HashSet();
            ReadAction.run(() -> {
                for (DetectedFrameworkDescription detectedFrameworkDescription : FrameworkDetectionUtil.removeDisabled(newDescriptions, oldDescriptions)) {
                    frameworkNames.add(detectedFrameworkDescription.getDetector().getFrameworkType().getPresentableName());
                }
            });
            if (!frameworkNames.isEmpty()) {
                String names2 = StringUtil.join(frameworkNames, (String)", ");
                String text = ProjectBundle.message((String)"framework.detected.info.text", (Object[])new Object[]{names2, frameworkNames.size()});
                FRAMEWORK_DETECTION_NOTIFICATION.createNotification("Frameworks Detected", text, NotificationType.INFORMATION, null).addAction((AnAction)new NotificationAction(IdeBundle.messagePointer((String)"action.Anonymous.text.configure", (Object[])new Object[0])){

                    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                        FrameworkDetectionManager.this.showSetupFrameworksDialog(notification);
                    }
                }).notify(this.myProject);
            }
        }
    }

    private List<? extends DetectedFrameworkDescription> runDetector(Integer detectorId, boolean processNewFilesOnly) {
        Collection acceptedFiles = FileBasedIndex.getInstance().getContainingFiles(FrameworkDetectionIndex.NAME, (Object)detectorId, GlobalSearchScope.projectScope((Project)this.myProject));
        Collection<Object> filesToProcess = processNewFilesOnly ? this.myDetectedFrameworksData.retainNewFiles(detectorId, acceptedFiles) : new ArrayList(acceptedFiles);
        FrameworkDetector detector = FrameworkDetectorRegistry.getInstance().getDetectorById(detectorId);
        if (detector == null) {
            LOG.info("Framework detector not found by id " + detectorId);
            return Collections.emptyList();
        }
        DetectionExcludesConfigurationImpl excludesConfiguration = (DetectionExcludesConfigurationImpl)DetectionExcludesConfiguration.getInstance((Project)this.myProject);
        excludesConfiguration.removeExcluded(filesToProcess, detector.getFrameworkType());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detector '" + detector.getDetectorId() + "': " + acceptedFiles.size() + " accepted files, " + filesToProcess.size() + " files to process");
        }
        List frameworks = !filesToProcess.isEmpty() ? detector.detect(filesToProcess, (FrameworkDetectionContext)new FrameworkDetectionContextImpl(this.myProject)) : Collections.emptyList();
        return frameworks;
    }

    private void showSetupFrameworksDialog(Notification notification) {
        List<? extends DetectedFrameworkDescription> descriptions;
        try {
            descriptions = this.getValidDetectedFrameworks();
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)this.myProject).showDumbModeNotification(LangBundle.message((String)"popup.content.information.about.detected.frameworks", (Object[])new Object[0]));
            return;
        }
        if (descriptions.isEmpty()) {
            Messages.showInfoMessage((Project)this.myProject, (String)LangBundle.message((String)"dialog.message.no.frameworks.are.detected", (Object[])new Object[0]), (String)LangBundle.message((String)"dialog.title.framework.detection", (Object[])new Object[0]));
            return;
        }
        ConfigureDetectedFrameworksDialog dialog2 = new ConfigureDetectedFrameworksDialog(this.myProject, descriptions);
        if (dialog2.showAndGet()) {
            notification.expire();
            List<DetectedFrameworkDescription> selected2 = dialog2.getSelectedFrameworks();
            FrameworkDetectionUtil.setupFrameworks(selected2, new PlatformModifiableModelsProvider(), (ModulesProvider)new DefaultModulesProvider(this.myProject));
            for (DetectedFrameworkDescription description : selected2) {
                int detectorId = FrameworkDetectorRegistry.getInstance().getDetectorId(description.getDetector());
                this.myDetectedFrameworksData.putExistentFrameworkFiles(detectorId, description.getRelatedFiles());
            }
        }
    }

    private List<? extends DetectedFrameworkDescription> getValidDetectedFrameworks() {
        Set<Integer> detectors = this.myDetectedFrameworksData.getDetectorsForDetectedFrameworks();
        ArrayList<? extends DetectedFrameworkDescription> descriptions = new ArrayList<DetectedFrameworkDescription>();
        for (Integer id2 : detectors) {
            List<? extends DetectedFrameworkDescription> frameworks = this.runDetector(id2, false);
            descriptions.addAll(frameworks);
        }
        return FrameworkDetectionUtil.removeDisabled(descriptions);
    }

    public void runDetection() {
        FrameworkDetectionManager.ensureIndexIsUpToDate(this.myProject, FrameworkDetectorRegistry.getInstance().getAllDetectorIds());
        this.doRunDetection();
    }

    public List<? extends DetectedFrameworkDescription> getDetectedFrameworks() {
        return this.getValidDetectedFrameworks();
    }

    private static void ensureIndexIsUpToDate(@NotNull Project project, int[] detectors) {
        for (int detectorId : detectors) {
            FileBasedIndex.getInstance().getValues(FrameworkDetectionIndex.NAME, (Object)detectorId, GlobalSearchScope.projectScope((Project)project));
        }
    }

    private static void ensureIndexIsUpToDate(@NotNull Project project, Collection<Integer> detectors) {
        for (Integer detectorId : detectors) {
            FileBasedIndex.getInstance().getValues(FrameworkDetectionIndex.NAME, (Object)detectorId, GlobalSearchScope.projectScope((Project)project));
        }
    }

    private static final class FrameworkDetectionHighlightingPass
    extends TextEditorHighlightingPass {
        private final Collection<Integer> myDetectors;

        FrameworkDetectionHighlightingPass(@NotNull Project project, Editor editor, Collection<Integer> detectors) {
            super(project, editor.getDocument(), false);
            this.myDetectors = detectors;
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress2) {
            FrameworkDetectionManager.ensureIndexIsUpToDate(this.myProject, this.myDetectors);
        }

        @Override
        public void doApplyInformationToEditor() {
        }
    }

    static final class FrameworkDetectionHighlightingPassFactory
    implements TextEditorHighlightingPassFactory,
    TextEditorHighlightingPassFactoryRegistrar {
        FrameworkDetectionHighlightingPassFactory() {
        }

        @Override
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.LAST, -1, false, false);
        }

        @Override
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
            Collection<Integer> detectors = FrameworkDetectorRegistry.getInstance().getDetectorIds(file2.getFileType());
            if (!detectors.isEmpty()) {
                return new FrameworkDetectionHighlightingPass(file2.getProject(), editor, detectors);
            }
            return null;
        }
    }
}

