/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class FindUsagesHelper {
    private static final Logger LOG = Logger.getInstance(FindUsagesHelper.class);

    @Deprecated
    public static boolean processUsagesInText(@NotNull PsiElement element2, @NotNull Collection<String> stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Processor<? super UsageInfo> processor2) {
        return FindUsagesHelper.processUsagesInText(element2, stringToSearch, false, searchScope, processor2);
    }

    public static boolean processUsagesInText(@NotNull PsiElement element2, @NotNull Collection<String> stringToSearch, boolean equivalentReferencesOnly, @NotNull GlobalSearchScope searchScope, @NotNull Processor<? super UsageInfo> processor2) {
        TextRange elementTextRange = (TextRange)ReadAction.compute(() -> !element2.isValid() || element2 instanceof PsiCompiledElement ? null : element2.getTextRange());
        UsageInfoFactory factory2 = (usage, startOffset, endOffset) -> {
            if (!element2.isValid()) {
                return equivalentReferencesOnly ? null : new UsageInfo(usage, startOffset, endOffset, true);
            }
            if (elementTextRange != null && usage.getContainingFile() == element2.getContainingFile() && elementTextRange.contains(startOffset) && elementTextRange.contains(endOffset)) {
                return null;
            }
            PsiReference someReference = usage.findReferenceAt(startOffset);
            if (someReference != null) {
                PsiElement refElement = someReference.getElement();
                for (PsiReference ref : PsiReferenceService.getService().getReferences(refElement, new PsiReferenceService.Hints(element2, null))) {
                    if (!element2.getManager().areElementsEquivalent(ref.resolve(), element2)) continue;
                    TextRange range2 = ref.getRangeInElement().shiftRight(refElement.getTextRange().getStartOffset() - usage.getTextRange().getStartOffset());
                    return new UsageInfo(usage, range2.getStartOffset(), range2.getEndOffset(), true);
                }
            }
            return equivalentReferencesOnly ? null : new UsageInfo(usage, startOffset, endOffset, true);
        };
        for (String s : stringToSearch) {
            if (FindUsagesHelper.processTextOccurrences(element2, s, searchScope, factory2, processor2)) continue;
            return false;
        }
        return true;
    }

    public static boolean processTextOccurrences(@NotNull PsiElement element2, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull UsageInfoFactory factory2, @NotNull Processor<? super UsageInfo> processor2) {
        PsiSearchHelper helper = (PsiSearchHelper)ReadAction.compute(() -> PsiSearchHelper.getInstance((Project)element2.getProject()));
        return helper.processUsagesInNonJavaFiles(element2, stringToSearch, (psiFile, startOffset, endOffset) -> {
            try {
                UsageInfo usageInfo = (UsageInfo)ReadAction.compute(() -> factory2.createUsageInfo((PsiElement)psiFile, startOffset, endOffset));
                return usageInfo == null || processor2.process((Object)usageInfo);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return true;
            }
        }, searchScope);
    }
}

