/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JList;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantsCompletionAction
extends DumbAwareAction
implements LightEditCompatible {
    private final PopupState myPopupState = new PopupState();
    private final JTextComponent myTextField;

    public VariantsCompletionAction(JTextComponent textField2) {
        this.myTextField = textField2;
        AnAction action2 = ActionManager.getInstance().getAction("CodeCompletion");
        if (action2 != null) {
            this.registerCustomShortcutSet(action2.getShortcutSet(), this.myTextField);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (this.myPopupState.isRecentlyHidden()) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        if (editor == null) {
            return;
        }
        String prefix = this.myTextField.getText().substring(0, this.myTextField.getCaretPosition());
        if (StringUtil.isEmpty((String)prefix)) {
            return;
        }
        String[] array2 = VariantsCompletionAction.calcWords(prefix, editor);
        if (array2.length == 0) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("find.completion");
        JBList<String> list2 = new JBList<String>(array2){

            protected void paintComponent(Graphics g) {
                GraphicsUtil.setupAntialiasing((Graphics)g);
                super.paintComponent(g);
            }
        };
        list2.setBackground((Color)new JBColor(new Color(235, 244, 254), new Color(5001041)));
        list2.setFont(editor.getColorsScheme().getFont(EditorFontType.PLAIN));
        Utils.showCompletionPopup(e.getInputEvent() instanceof MouseEvent ? this.myTextField : null, (JList)list2, null, this.myTextField, null, (JBPopupListener)this.myPopupState);
    }

    private static String[] calcWords(String prefix, Editor editor) {
        final Matcher matcher = NameUtil.buildMatcher((String)prefix, (int)0, (boolean)true, (boolean)true);
        final HashSet words = new HashSet();
        CharSequence chars = editor.getDocument().getCharsSequence();
        IdTableBuilding.scanWords(new IdTableBuilding.ScanWordProcessor(){

            @Override
            public void run(CharSequence chars, char @Nullable [] charsArray, int start2, int end) {
                String word = chars.subSequence(start2, end).toString();
                if (matcher.matches(word)) {
                    words.add(word);
                }
            }
        }, chars, 0, chars.length());
        ArrayList sortedWords = new ArrayList(words);
        Collections.sort(sortedWords);
        return ArrayUtilRt.toStringArray(sortedWords);
    }
}

