/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.FindBundle;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.ContextAwareShortcutProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleSelectionOnlyAction
extends ToggleAction
implements ContextAwareShortcutProvider,
DumbAware,
LightEditCompatible {
    public ToggleSelectionOnlyAction() {
        super(FindBundle.message("find.selection.only", new Object[0]), null, AllIcons.Actions.InSelection);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        SearchSession search2 = (SearchSession)e.getData(SearchSession.KEY);
        return search2 != null && !search2.getFindModel().isGlobal();
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(e.getData(SearchSession.KEY) != null);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        SearchSession search2 = (SearchSession)e.getData(SearchSession.KEY);
        if (search2 != null) {
            search2.getFindModel().setGlobal(!state);
        }
    }

    @Override
    @Nullable
    public ShortcutSet getShortcut(@NotNull DataContext context) {
        if (KeymapUtil.isEmacsKeymap()) {
            return null;
        }
        SearchSession search2 = (SearchSession)context.getData(SearchSession.KEY);
        if (search2 != null) {
            boolean replaceState = search2.getFindModel().isReplaceState();
            AnAction action2 = ActionManager.getInstance().getAction(replaceState ? "Replace" : "ToggleFindInSelection");
            return action2 != null ? action2.getShortcutSet() : null;
        }
        return null;
    }
}

