/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageToPsiElementProvider;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageAdapter;
import com.intellij.usages.impl.UsageNode;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUsagesTable
extends JBTable
implements DataProvider {
    final Usage MORE_USAGES_SEPARATOR = new UsageAdapter();
    final Usage USAGES_OUTSIDE_SCOPE_SEPARATOR = new UsageAdapter();
    final Usage USAGES_FILTERED_OUT_SEPARATOR = new UsageAdapter();
    private static final int MARGIN = 2;
    private final ShowUsagesTableCellRenderer myRenderer;
    private final UsageView myUsageView;

    ShowUsagesTable(@NotNull ShowUsagesTableCellRenderer renderer, @NotNull UsageView usageView) {
        this.myRenderer = renderer;
        this.myUsageView = usageView;
        ScrollingUtil.installActions((JTable)((Object)this));
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            int[] selected2 = this.getSelectedRows();
            if (selected2.length == 1) {
                return ShowUsagesTable.getPsiElementForHint(this.getValueAt(selected2[0], 0));
            }
        } else {
            if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
                return PopupUtil.getPopupContainerFor((Component)((Object)this));
            }
            if (UsageView.USAGE_VIEW_KEY.is(dataId)) {
                return this.myUsageView;
            }
        }
        return null;
    }

    public int getRowHeight() {
        return super.getRowHeight() + 4;
    }

    @NotNull
    public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
        Component component2 = super.prepareRenderer(renderer, row, column);
        if (component2 instanceof JComponent) {
            ((JComponent)component2).setBorder((Border)JBUI.Borders.empty((int)2, (int)2, (int)2, (int)0));
        }
        return component2;
    }

    @NotNull
    Runnable prepareTable(@NotNull Runnable appendMoreUsageRunnable, @NotNull Runnable showInMaximalScopeRunnable) {
        MySpeedSearch speedSearch2 = new MySpeedSearch(this);
        speedSearch2.setComparator(new SpeedSearchComparator(false));
        this.setRowHeight(PlatformIcons.CLASS_ICON.getIconHeight() + 2);
        this.setShowGrid(false);
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setTableHeader(null);
        this.setAutoResizeMode(3);
        this.setIntercellSpacing(new Dimension(0, 0));
        AtomicReference selectedUsages = new AtomicReference();
        AtomicBoolean moreUsagesSelected = new AtomicBoolean();
        AtomicBoolean outsideScopeUsagesSelected = new AtomicBoolean();
        AtomicReference filteredOutUsagesSelected = new AtomicReference();
        this.getSelectionModel().addListSelectionListener(e -> {
            selectedUsages.set(null);
            outsideScopeUsagesSelected.set(false);
            moreUsagesSelected.set(false);
            filteredOutUsagesSelected.set(null);
            ArrayList<Usage> usages = null;
            for (int i2 : this.getSelectedRows()) {
                Object value2 = this.getValueAt(i2, 0);
                if (!(value2 instanceof UsageNode)) continue;
                Usage usage = ((UsageNode)value2).getUsage();
                if (usage == this.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                    outsideScopeUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usage == this.MORE_USAGES_SEPARATOR) {
                    moreUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usage == this.USAGES_FILTERED_OUT_SEPARATOR) {
                    filteredOutUsagesSelected.set((ShowUsagesAction.FilteredOutUsagesNode)((Object)((Object)value2)));
                    usages = null;
                    break;
                }
                if (usages == null) {
                    usages = new ArrayList<Usage>();
                }
                usages.add((Usage)(usage instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)usage).getUsageInfo().copy() : usage));
            }
            selectedUsages.set(usages);
        });
        return () -> {
            if (moreUsagesSelected.get()) {
                appendMoreUsageRunnable.run();
                return;
            }
            if (outsideScopeUsagesSelected.get()) {
                showInMaximalScopeRunnable.run();
                return;
            }
            if (filteredOutUsagesSelected.get() != null) {
                ((ShowUsagesAction.FilteredOutUsagesNode)((Object)((Object)filteredOutUsagesSelected.get()))).onSelected();
                return;
            }
            List usages = (List)selectedUsages.get();
            if (usages != null) {
                for (Object usage : usages) {
                    if (usage instanceof UsageInfo) {
                        UsageViewUtil.navigateTo((UsageInfo)usage, true);
                        continue;
                    }
                    if (!(usage instanceof Navigatable)) continue;
                    ((Navigatable)usage).navigate(true);
                }
            }
        };
    }

    public boolean isSeparatorNode(@Nullable Usage node) {
        return node == this.USAGES_OUTSIDE_SCOPE_SEPARATOR || node == this.MORE_USAGES_SEPARATOR || node == this.USAGES_FILTERED_OUT_SEPARATOR;
    }

    @Nullable
    private static PsiElement getPsiElementForHint(Object selectedValue) {
        PsiElement element2;
        Usage usage;
        if (selectedValue instanceof UsageNode && (usage = ((UsageNode)selectedValue).getUsage()) instanceof UsageInfo2UsageAdapter && (element2 = ((UsageInfo2UsageAdapter)usage).getElement()) != null) {
            PsiElement view = UsageToPsiElementProvider.findAppropriateParentFrom((PsiElement)element2);
            return view == null ? element2 : view;
        }
        return null;
    }

    private static int calcColumnCount(@NotNull List<UsageNode> data2) {
        return data2.isEmpty() || data2.get(0) instanceof ShowUsagesAction.StringNode ? 1 : 4;
    }

    @NotNull
    MyModel setTableModel(@NotNull List<UsageNode> data2) {
        MyModel model;
        ApplicationManager.getApplication().assertIsDispatchThread();
        int columnCount = ShowUsagesTable.calcColumnCount(data2);
        MyModel myModel = model = this.getModel() instanceof MyModel ? (MyModel)((Object)this.getModel()) : null;
        if (model == null || model.getColumnCount() != columnCount) {
            model = new MyModel(data2, columnCount);
            this.setModel((TableModel)((Object)model));
            for (int i2 = 0; i2 < this.getColumnModel().getColumnCount(); ++i2) {
                TableColumn column = this.getColumnModel().getColumn(i2);
                column.setPreferredWidth(0);
                column.setCellRenderer(this.myRenderer);
            }
        }
        return model;
    }

    static class MyModel
    extends ListTableModel<UsageNode>
    implements ModelDiff.Model<Object> {
        private MyModel(@NotNull List<UsageNode> data2, int cols) {
            super(MyModel.cols(cols), data2, 0);
        }

        @NotNull
        private static ColumnInfo<UsageNode, UsageNode>[] cols(int cols) {
            ColumnInfo<UsageNode, UsageNode> o = new ColumnInfo<UsageNode, UsageNode>(""){

                @Nullable
                public UsageNode valueOf(UsageNode node) {
                    return node;
                }
            };
            List<1> list2 = Collections.nCopies(cols, o);
            return list2.toArray(ColumnInfo.emptyArray());
        }

        @Override
        public void addToModel(int idx, Object element2) {
            UsageNode node;
            UsageNode usageNode = node = element2 instanceof UsageNode ? (UsageNode)element2 : ShowUsagesAction.createStringNode(element2);
            if (idx < this.getRowCount()) {
                this.insertRow(idx, node);
            } else {
                this.addRow(node);
            }
        }

        @Override
        public void removeRangeFromModel(int start2, int end) {
            for (int i2 = end; i2 >= start2; --i2) {
                this.removeRow(i2);
            }
        }
    }

    private static class MySpeedSearch
    extends SpeedSearchBase<JTable> {
        MySpeedSearch(@NotNull ShowUsagesTable table) {
            super(table);
        }

        @Override
        protected int getSelectedIndex() {
            return this.getTable().getSelectedRow();
        }

        @Override
        protected int convertIndexToModel(int viewIndex) {
            return this.getTable().convertRowIndexToModel(viewIndex);
        }

        @Override
        protected Object @NotNull [] getAllElements() {
            return ((MyModel)((Object)this.getTable().getModel())).getItems().toArray();
        }

        @Override
        protected String getElementText(@NotNull Object element2) {
            if (!(element2 instanceof UsageNode)) {
                return element2.toString();
            }
            UsageNode node = (UsageNode)element2;
            if (node instanceof ShowUsagesAction.StringNode) {
                return "";
            }
            Usage usage = node.getUsage();
            if (usage == this.getTable().MORE_USAGES_SEPARATOR || usage == this.getTable().USAGES_OUTSIDE_SCOPE_SEPARATOR || usage == this.getTable().USAGES_FILTERED_OUT_SEPARATOR) {
                return "";
            }
            GroupNode group = (GroupNode)node.getParent();
            String groupText = group == null ? "" : group.getGroup().getText(null);
            return groupText + usage.getPresentation().getPlainText();
        }

        @Override
        protected void selectElement(Object element2, String selectedText) {
            List data2 = ((MyModel)((Object)this.getTable().getModel())).getItems();
            int i2 = data2.indexOf(element2);
            if (i2 == -1) {
                return;
            }
            int viewRow = this.getTable().convertRowIndexToView(i2);
            this.getTable().getSelectionModel().setSelectionInterval(viewRow, viewRow);
            TableUtil.scrollSelectionToVisible((JTable)((Object)this.getTable()));
        }

        private ShowUsagesTable getTable() {
            return (ShowUsagesTable)((Object)this.myComponent);
        }
    }
}

