/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.actions.CompositeActiveComponent;
import com.intellij.find.actions.FindUsagesAction;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.actions.PingEDT;
import com.intellij.find.actions.ResolverKt;
import com.intellij.find.actions.ShowTargetUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesParameters;
import com.intellij.find.actions.ShowUsagesTable;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.find.actions.UsageListCellRenderer;
import com.intellij.find.actions.UsageVariantHandler;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesHandlerUi;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.usages.SearchTarget;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.internal.statistic.service.fus.collectors.UIEventId;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.ShowUsagesSettings;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearchPresentation;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.UsageGroupingRuleProviderImpl;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUsagesAction
extends AnAction
implements PopupAction,
HintManagerImpl.ActionToIgnore {
    public static final String ID = "ShowUsages";

    public ShowUsagesAction() {
        this.setInjectedContext(true);
    }

    public static int getUsagesPageSize() {
        return Math.max(1, Registry.intValue((String)"ide.usages.page.size", (int)100));
    }

    public void update(@NotNull AnActionEvent e) {
        Object[] usageTargets;
        FindUsagesInFileAction.updateFindUsagesAction(e);
        if (e.getPresentation().isEnabled() && (usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY)) != null && !(ArrayUtil.getFirstElement((Object[])usageTargets) instanceof PsiElementUsageTarget)) {
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        ShowUsagesActionState state = ShowUsagesAction.getState(project);
        Runnable continuation = state.continuation;
        if (continuation != null) {
            state.continuation = null;
            ShowUsagesAction.hideHints();
            continuation.run();
            return;
        }
        RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.usages");
        if (Registry.is((String)"ide.symbol.find.usages")) {
            ShowUsagesAction.showSymbolUsages(project, e.getDataContext());
        } else {
            ShowUsagesAction.showPsiUsages(project, e, popupPosition);
        }
    }

    private static void showSymbolUsages(@NotNull Project project, @NotNull DataContext dataContext) {
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
        SearchScope searchScope = FindUsagesOptions.findScopeByName(project, dataContext, FindSettings.getInstance().getDefaultScopeName());
        ResolverKt.findShowUsages(project, dataContext, FindBundle.message("show.usages.ambiguous.title", new Object[0]), ShowUsagesAction.createVariantHandler(project, editor, popupPosition, searchScope));
    }

    @NotNull
    private static UsageVariantHandler createVariantHandler(final @NotNull Project project, final @Nullable Editor editor, final @NotNull RelativePoint popupPosition, final @NotNull SearchScope searchScope) {
        return new UsageVariantHandler(){

            @Override
            public void handleTarget(@NotNull SearchTarget target2) {
                ShowTargetUsagesActionHandler.showUsages(project, searchScope, target2, ShowUsagesParameters.initial(project, editor, popupPosition));
            }

            @Override
            public void handlePsi(@NotNull PsiElement element2) {
                ShowUsagesAction.startFindUsages(element2, popupPosition, editor);
            }
        };
    }

    @ApiStatus.Internal
    public static void showUsages(@NotNull Project project, @NotNull DataContext dataContext, @NotNull SearchTarget target2) {
        RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
        ShowUsagesAction.showUsages(project, dataContext, popupPosition, target2);
    }

    @ApiStatus.Internal
    public static void showUsages(@NotNull Project project, @NotNull DataContext dataContext, @NotNull RelativePoint popupPosition, @NotNull SearchTarget target2) {
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        SearchScope searchScope = FindUsagesOptions.findScopeByName(project, dataContext, FindSettings.getInstance().getDefaultScopeName());
        UsageVariantHandler variantHandler = ShowUsagesAction.createVariantHandler(project, editor, popupPosition, searchScope);
        ResolverKt.handlePsiOrSymbol(variantHandler, target2);
    }

    private static void showPsiUsages(@NotNull Project project, @NotNull AnActionEvent e, @NotNull RelativePoint popupPosition) {
        PsiElement element3;
        Object[] usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (usageTargets == null) {
            FindUsagesAction.chooseAmbiguousTargetAndPerform(project, editor, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element2 -> {
                ShowUsagesAction.startFindUsages(element2, popupPosition, editor);
                return false;
            }));
        } else if (ArrayUtil.getFirstElement((Object[])usageTargets) instanceof PsiElementUsageTarget && (element3 = ((PsiElementUsageTarget)usageTargets[0]).getElement()) != null) {
            ShowUsagesAction.startFindUsages(element3, popupPosition, editor);
        }
    }

    private static void hideHints() {
        HintManager.getInstance().hideHints(2, false, false);
    }

    public static void startFindUsages(@NotNull PsiElement element2, @NotNull RelativePoint popupPosition, @Nullable Editor editor) {
        Project project = element2.getProject();
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
        FindUsagesHandler handler2 = findUsagesManager.getFindUsagesHandler(element2, FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS);
        if (handler2 == null) {
            return;
        }
        FindUsagesOptions options2 = handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext());
        ShowUsagesAction.showElementUsages(ShowUsagesParameters.initial(project, editor, popupPosition), ShowUsagesAction.createActionHandler(handler2, options2));
    }

    private static void rulesChanged(@NotNull UsageViewImpl usageView, @NotNull PingEDT pingEDT, JBPopup popup2) {
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!(popup2 != null && popup2.isDisposed() || usageView.isDisposed())) {
                usageView.waitForUpdateRequestsCompletion();
                if (!(popup2 != null && popup2.isDisposed() || usageView.isDisposed())) {
                    pingEDT.ping();
                }
            }
        }));
    }

    @NotNull
    private static ShowUsagesActionHandler createActionHandler(final @NotNull FindUsagesHandlerBase handler2, final @NotNull FindUsagesOptions options2) {
        final PsiElement[] primaryElements = handler2.getPrimaryElements();
        final PsiElement[] secondaryElements = handler2.getSecondaryElements();
        final String searchString = FindBundle.message("find.usages.of.element.tab.name", options2.generateUsagesString(), UsageViewUtil.getLongName(handler2.getPsiElement()));
        return new ShowUsagesActionHandler(){

            @Override
            public boolean isValid() {
                return handler2.getPsiElement().isValid();
            }

            @Override
            @NotNull
            public UsageSearchPresentation getPresentation() {
                return () -> searchString;
            }

            @Override
            @NotNull
            public UsageSearcher createUsageSearcher() {
                return FindUsagesManager.createUsageSearcher(handler2, primaryElements, secondaryElements, options2);
            }

            @Override
            @NotNull
            public SearchScope getSelectedScope() {
                return options2.searchScope;
            }

            @NotNull
            public GlobalSearchScope getMaximalScope() {
                return FindUsagesManager.getMaximalScope(handler2);
            }

            @Override
            public ShowUsagesActionHandler showDialog() {
                FindUsagesOptions newOptions = ShowUsagesAction.showDialog(handler2);
                if (newOptions == null) {
                    return null;
                }
                return ShowUsagesAction.createActionHandler(handler2, newOptions);
            }

            @Override
            public void findUsages() {
                Project project = handler2.getProject();
                FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
                findUsagesManager.findUsages(handler2.getPrimaryElements(), handler2.getSecondaryElements(), handler2, options2, FindSettings.getInstance().isSkipResultsWithOneUsage());
            }

            @Override
            @NotNull
            public ShowUsagesActionHandler withScope(@NotNull SearchScope searchScope) {
                FindUsagesOptions newOptions = options2.clone();
                newOptions.searchScope = searchScope;
                return ShowUsagesAction.createActionHandler(handler2, newOptions);
            }
        };
    }

    static void showElementUsages(final @NotNull ShowUsagesParameters parameters2, final @NotNull ShowUsagesActionHandler actionHandler) {
        PsiReference reference2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project = parameters2.project;
        Editor editor = parameters2.editor;
        UsageViewImpl usageView = ShowUsagesAction.createUsageView(project);
        if (editor != null && (reference2 = TargetElementUtil.findReference(editor)) != null) {
            UsageInfo2UsageAdapter origin = new UsageInfo2UsageAdapter(new UsageInfo(reference2));
            usageView.setOriginUsage((Usage)origin);
        }
        SearchScope searchScope = actionHandler.getSelectedScope();
        AtomicInteger outOfScopeUsages = new AtomicInteger();
        ShowUsagesTable table = new ShowUsagesTable(new ShowUsagesTableCellRenderer(usageView, outOfScopeUsages, searchScope), (UsageView)usageView);
        AsyncProcessIcon processIcon = new AsyncProcessIcon("xxx");
        TitlePanel statusPanel = new TitlePanel();
        statusPanel.add((Component)processIcon, (Object)"East");
        ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, new ArrayList());
        ArrayList usages = new ArrayList();
        LinkedHashSet visibleNodes = new LinkedHashSet();
        table.setTableModel((List<UsageNode>)new SmartList((Object)ShowUsagesAction.createStringNode(UsageViewBundle.message((String)"progress.searching", (Object[])new Object[0]))));
        Runnable itemChosenCallback = table.prepareTable(ShowUsagesAction.showMoreUsagesRunnable(parameters2, actionHandler), ShowUsagesAction.showUsagesInMaximalScopeRunnable(parameters2, actionHandler));
        JBPopup popup2 = ShowUsagesAction.createUsagePopup(usageView, (JTable)((Object)table), itemChosenCallback, statusPanel, parameters2, actionHandler);
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        if (!popup2.isDisposed()) {
            Disposer.register((Disposable)popup2, (Disposable)usageView);
            Disposer.register((Disposable)popup2, () -> ((ProgressIndicator)indicator).cancel());
            EdtScheduledExecutorService.getInstance().schedule(() -> {
                if (!usageView.isDisposed()) {
                    ShowUsagesAction.showPopupIfNeedTo(popup2, parameters2.popupPosition);
                }
            }, 300L, TimeUnit.MILLISECONDS);
        }
        UsageNode USAGES_OUTSIDE_SCOPE_NODE = new UsageNode(null, table.USAGES_OUTSIDE_SCOPE_SEPARATOR);
        UsageNode MORE_USAGES_SEPARATOR_NODE = new UsageNode(null, table.MORE_USAGES_SEPARATOR);
        PingEDT pingEDT = new PingEDT("Rebuild popup in EDT", o -> popup2.isDisposed(), 100, () -> {
            boolean hasOutsideScopeUsages;
            ArrayList copy2;
            if (popup2.isDisposed()) {
                return;
            }
            ArrayList<UsageNode> nodes = new ArrayList<UsageNode>(usages.size());
            List list2 = usages;
            synchronized (list2) {
                if (!(popup2.isVisible() || !usages.isEmpty() && ShowUsagesAction.showPopupIfNeedTo(popup2, parameters2.popupPosition))) {
                    return;
                }
                ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, nodes);
                copy2 = new ArrayList(usages);
            }
            boolean shouldShowMoreSeparator = copy2.contains(table.MORE_USAGES_SEPARATOR);
            if (shouldShowMoreSeparator) {
                nodes.add(MORE_USAGES_SEPARATOR_NODE);
            }
            if ((hasOutsideScopeUsages = copy2.contains(table.USAGES_OUTSIDE_SCOPE_SEPARATOR)) && !shouldShowMoreSeparator) {
                nodes.add(USAGES_OUTSIDE_SCOPE_NODE);
            }
            ArrayList<UsageNode> data2 = new ArrayList<UsageNode>(nodes);
            int filteredOutCount = ShowUsagesAction.getFilteredOutNodeCount(copy2, usageView);
            if (filteredOutCount != 0) {
                DefaultActionGroup filteringActions = (DefaultActionGroup)popup2.getUserData(DefaultActionGroup.class);
                if (filteringActions == null) {
                    return;
                }
                final List unselectedActions = Arrays.stream(filteringActions.getChildren(null)).filter(action2 -> action2 instanceof ToggleAction).map(action2 -> (ToggleAction)action2).filter(ta -> !ta.isSelected(ShowUsagesAction.fakeEvent(ta))).filter(ta -> !StringUtil.isEmpty((String)ta.getTemplatePresentation().getText())).collect(Collectors.toList());
                data2.add(new FilteredOutUsagesNode(table.USAGES_FILTERED_OUT_SEPARATOR, UsageViewBundle.message((String)"usages.were.filtered.out", (Object[])new Object[]{filteredOutCount}), UsageViewBundle.message((String)"usages.were.filtered.out.tooltip", (Object[])new Object[0])){

                    @Override
                    public void onSelected() {
                        ShowUsagesAction.toggleFilters(unselectedActions);
                        ShowUsagesAction.showElementUsages(parameters2, actionHandler);
                    }
                });
            }
            data2.sort(new UsageNodeComparator(table));
            boolean hasMore = shouldShowMoreSeparator || hasOutsideScopeUsages;
            int totalCount = copy2.size();
            int visibleCount = totalCount - filteredOutCount;
            statusPanel.setText(ShowUsagesAction.getStatusString(!processIcon.isDisposed(), hasMore, visibleCount, totalCount));
            ShowUsagesAction.rebuildTable(usageView, data2, table, popup2, parameters2.popupPosition, parameters2.minWidth);
        });
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)usageView);
        messageBusConnection.subscribe(UsageFilteringRuleProvider.RULES_CHANGED, () -> ShowUsagesAction.rulesChanged(usageView, pingEDT, popup2));
        Processor collect = usage -> {
            if (!UsageViewManagerImpl.isInScope((Usage)usage, (SearchScope)searchScope)) {
                if (outOfScopeUsages.getAndIncrement() == 0) {
                    visibleNodes.add(USAGES_OUTSIDE_SCOPE_NODE);
                    usages.add(table.USAGES_OUTSIDE_SCOPE_SEPARATOR);
                }
                return true;
            }
            List list2 = usages;
            synchronized (list2) {
                if (visibleNodes.size() >= parameters2.maxUsages) {
                    return false;
                }
                UsageNode node = (UsageNode)ReadAction.compute(() -> usageView.doAppendUsage(usage));
                usages.add(usage);
                if (node != null) {
                    visibleNodes.add(node);
                    boolean continueSearch = true;
                    if (visibleNodes.size() == parameters2.maxUsages) {
                        visibleNodes.add(MORE_USAGES_SEPARATOR_NODE);
                        usages.add(table.MORE_USAGES_SEPARATOR);
                        continueSearch = false;
                    }
                    pingEDT.ping();
                    return continueSearch;
                }
            }
            return true;
        };
        UsageSearcher usageSearcher = actionHandler.createUsageSearcher();
        FindUsagesManager.startProcessUsages(indicator, project, usageSearcher, (Processor<? super Usage>)collect, () -> ApplicationManager.getApplication().invokeLater(() -> {
            Disposer.dispose((Disposable)processIcon);
            Container parent = processIcon.getParent();
            if (parent != null) {
                parent.remove((Component)processIcon);
                parent.repaint();
            }
            pingEDT.ping();
            List list2 = usages;
            synchronized (list2) {
                if (visibleNodes.isEmpty()) {
                    if (usages.isEmpty()) {
                        String hint = UsageViewBundle.message((String)"no.usages.found.in", (Object[])new Object[]{searchScope.getDisplayName()});
                        ShowUsagesAction.hint(false, hint, parameters2, actionHandler);
                        ShowUsagesAction.cancel(popup2);
                    }
                } else if (visibleNodes.size() == 1) {
                    if (usages.size() == 1) {
                        Usage usage = ((UsageNode)visibleNodes.iterator().next()).getUsage();
                        if (usage == table.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                            String hint = UsageViewManagerImpl.outOfScopeMessage((int)outOfScopeUsages.get(), (SearchScope)searchScope);
                            ShowUsagesAction.hint(true, hint, parameters2, actionHandler);
                        } else {
                            String hint = UsageViewBundle.message((String)"show.usages.only.usage", (Object[])new Object[]{searchScope.getDisplayName()});
                            ShowUsagesAction.navigateAndHint(usage, hint, parameters2, actionHandler);
                        }
                        ShowUsagesAction.cancel(popup2);
                    } else {
                        assert (usages.size() > 1) : usages;
                        Usage visibleUsage = ((UsageNode)visibleNodes.iterator().next()).getUsage();
                        if (ShowUsagesAction.areAllUsagesInOneLine(visibleUsage, usages)) {
                            String hint = UsageViewBundle.message((String)"all.usages.are.in.this.line", (Object[])new Object[]{usages.size(), searchScope.getDisplayName()});
                            ShowUsagesAction.navigateAndHint(visibleUsage, hint, parameters2, actionHandler);
                            ShowUsagesAction.cancel(popup2);
                        }
                    }
                }
            }
        }, project.getDisposed()));
    }

    private static void toggleFilters(@NotNull List<? extends ToggleAction> unselectedActions) {
        for (ToggleAction toggleAction : unselectedActions) {
            toggleAction.actionPerformed(ShowUsagesAction.fakeEvent(toggleAction));
        }
    }

    @NotNull
    private static AnActionEvent fakeEvent(@NotNull ToggleAction action2) {
        return new AnActionEvent(null, DataContext.EMPTY_CONTEXT, "", action2.getTemplatePresentation(), ActionManager.getInstance(), 0);
    }

    @NotNull
    private static UsageViewImpl createUsageView(@NotNull Project project) {
        UsageViewPresentation usageViewPresentation = new UsageViewPresentation();
        usageViewPresentation.setDetachedMode(true);
        return new UsageViewImpl(project, usageViewPresentation, UsageTarget.EMPTY_ARRAY, null){

            @NotNull
            public UsageViewSettings getUsageViewSettings() {
                return ShowUsagesSettings.getInstance().getState();
            }
        };
    }

    @NotNull
    static UsageNode createStringNode(@NotNull Object string) {
        return new StringNode(string);
    }

    private static boolean showPopupIfNeedTo(@NotNull JBPopup popup2, @NotNull RelativePoint popupPosition) {
        if (!popup2.isDisposed() && !popup2.isVisible()) {
            popup2.show(popupPosition);
            return true;
        }
        return false;
    }

    @NotNull
    private static JComponent createHintComponent(@NotNull String secondInvocationTitle, boolean isWarning, @NotNull JComponent button2) {
        JComponent label2 = HintUtil.createInformationLabel(secondInvocationTitle);
        if (isWarning) {
            label2.setBackground(MessageType.WARNING.getPopupBackground());
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        button2.setBackground(label2.getBackground());
        panel2.setBackground(label2.getBackground());
        label2.setOpaque(false);
        label2.setBorder(null);
        panel2.setBorder(HintUtil.createHintBorder());
        panel2.add((Component)label2, "Center");
        panel2.add((Component)button2, "East");
        return panel2;
    }

    @NotNull
    private static InplaceButton createSettingsButton(@NotNull Project project, @NotNull Runnable cancelAction, @NotNull Runnable showDialogAndFindUsagesRunnable) {
        String shortcutText = "";
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            shortcutText = "(" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")";
        }
        return new InplaceButton("Settings..." + shortcutText, AllIcons.General.Settings, __ -> {
            ApplicationManager.getApplication().invokeLater(showDialogAndFindUsagesRunnable, project.getDisposed());
            cancelAction.run();
        });
    }

    @Nullable
    private static FindUsagesOptions showDialog(@NotNull FindUsagesHandlerBase handler2) {
        UIEventLogger.logUIEvent((UIEventId)UIEventId.ShowUsagesPopupShowSettings);
        AbstractFindUsagesDialog dialog2 = handler2 instanceof FindUsagesHandlerUi ? ((FindUsagesHandlerUi)((Object)handler2)).getFindUsagesDialog(false, false, false) : FindUsagesHandler.createDefaultFindUsagesDialog(false, false, false, handler2);
        if (dialog2.showAndGet()) {
            dialog2.calcFindUsagesOptions();
            return handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext());
        }
        return null;
    }

    @NotNull
    private static JBPopup createUsagePopup(@NotNull UsageViewImpl usageView, @NotNull JTable table, @NotNull Runnable itemChoseCallback, final @NotNull TitlePanel statusPanel, final @NotNull ShowUsagesParameters parameters2, final @NotNull ShowUsagesActionHandler actionHandler) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project = parameters2.project;
        PopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(table);
        String title = UsageViewBundle.message((String)"search.title.0.in.1", (Object[])new Object[]{actionHandler.getPresentation().getSearchString(), actionHandler.getSelectedScope().getDisplayName()});
        builder2.setTitle(XmlStringUtil.wrapInHtml((CharSequence)("<body><nobr>" + StringUtil.escapeXmlEntities((String)title) + "</nobr></body>")));
        builder2.setAdText(ShowUsagesActionHandler.getSecondInvocationTitle(actionHandler));
        builder2.setMovable(true).setResizable(true);
        builder2.setItemChoosenCallback(itemChoseCallback);
        final JBPopup[] popup2 = new JBPopup[1];
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    ShowUsagesAction.cancel(popup2[0]);
                    ShowUsagesAction.showDialogAndRestart(parameters2, actionHandler);
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        if ((shortcut = ShowUsagesAction.getShowUsagesShortcut()) != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    ShowUsagesAction.cancel(popup2[0]);
                    ShowUsagesAction.showUsagesInMaximalScope(parameters2, actionHandler);
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        InplaceButton settingsButton = ShowUsagesAction.createSettingsButton(project, () -> ShowUsagesAction.cancel(popup2[0]), ShowUsagesAction.showDialogAndRestartRunnable(parameters2, actionHandler));
        ActiveComponent statusComponent = new ActiveComponent(){

            public void setActive(boolean active) {
                statusPanel.setActive(active);
            }

            @NotNull
            public JComponent getComponent() {
                return statusPanel;
            }
        };
        DefaultActionGroup pinGroup = new DefaultActionGroup();
        ActiveComponent pin = ShowUsagesAction.createPinButton(project, popup2, pinGroup, actionHandler::findUsages);
        builder2.setCommandButton((ActiveComponent)new CompositeActiveComponent(new ActiveComponent[]{statusComponent, settingsButton, pin}));
        DefaultActionGroup toolbar = new DefaultActionGroup();
        usageView.addFilteringActions(toolbar);
        toolbar.add((AnAction)UsageGroupingRuleProviderImpl.createGroupByFileStructureAction((UsageViewImpl)usageView));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", (ActionGroup)toolbar, true);
        actionToolbar.setTargetComponent((JComponent)table);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        JComponent toolBar = actionToolbar.getComponent();
        toolBar.setOpaque(false);
        builder2.setSettingButton((Component)toolBar);
        builder2.setCancelKeyEnabled(false);
        PopupUpdateProcessor processor2 = new PopupUpdateProcessor(usageView.getProject()){

            public void updatePopup(Object lookupItemObject) {
            }
        };
        builder2.addListener((JBPopupListener)processor2);
        popup2[0] = builder2.createPopup();
        JComponent content2 = popup2[0].getContent();
        String fullTitle = title + ShowUsagesAction.getStatusString(true, false, 0, 0);
        int approxWidth = (int)(toolBar.getPreferredSize().getWidth() + new JLabel(fullTitle).getPreferredSize().getWidth() + settingsButton.getPreferredSize().getWidth());
        IntRef minWidth = parameters2.minWidth;
        minWidth.set(Math.max(minWidth.get(), approxWidth));
        for (AnAction action2 : toolbar.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        for (AnAction action2 : pinGroup.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        popup2[0].setUserData(Collections.singletonList(toolbar));
        return popup2[0];
    }

    @NotNull
    private static ActiveComponent createPinButton(@NotNull Project project, final JBPopup @NotNull [] popup2, @NotNull DefaultActionGroup pinGroup, final @NotNull Runnable findUsagesRunnable) {
        Icon icon2 = ToolWindowManager.getInstance((Project)project).getLocationIcon("Find", AllIcons.General.Pin_tab);
        AnAction pinAction = new AnAction(IdeBundle.messagePointer((String)"show.in.find.window.button.name", (Object[])new Object[0]), IdeBundle.messagePointer((String)"show.in.find.window.button.pin.description", (Object[])new Object[0]), icon2){
            {
                super(x0, x1, x2);
                AnAction action2 = ActionManager.getInstance().getAction("FindUsages");
                this.setShortcutSet(action2.getShortcutSet());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                ShowUsagesAction.hideHints();
                ShowUsagesAction.cancel(popup2[0]);
                findUsagesRunnable.run();
            }
        };
        pinGroup.add(pinAction);
        ActionToolbar pinToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", (ActionGroup)pinGroup, true);
        pinToolbar.setReservePlaceAutoPopupIcon(false);
        final JComponent pinToolBar = pinToolbar.getComponent();
        pinToolBar.setBorder(null);
        pinToolBar.setOpaque(false);
        return new ActiveComponent.Adapter(){

            @NotNull
            public JComponent getComponent() {
                return pinToolBar;
            }
        };
    }

    private static void cancel(@Nullable JBPopup popup2) {
        if (popup2 != null) {
            popup2.cancel();
        }
    }

    @NotNull
    private static String getStatusString(boolean findUsagesInProgress, boolean hasMore, int visibleCount, int totalCount) {
        if (findUsagesInProgress || hasMore) {
            return UsageViewBundle.message((String)"showing.0.usages", (Object[])new Object[]{visibleCount - (hasMore ? 1 : 0)});
        }
        if (visibleCount != totalCount) {
            return UsageViewBundle.message((String)"showing.0.of.1.usages", (Object[])new Object[]{visibleCount, totalCount});
        }
        return UsageViewBundle.message((String)"found.0.usages", (Object[])new Object[]{totalCount});
    }

    @NotNull
    private static String suggestSecondInvocation(@NotNull String text, @Nullable String title) {
        if (title != null) {
            text = text + "<br><small>" + title + "</small>";
        }
        return XmlStringUtil.wrapInHtml((CharSequence)UIUtil.convertSpace2Nbsp((String)text));
    }

    @Nullable
    static KeyboardShortcut getShowUsagesShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut(ID);
    }

    private static int getFilteredOutNodeCount(@NotNull List<? extends Usage> usages, @NotNull UsageViewImpl usageView) {
        return (int)usages.stream().filter(usage -> !usageView.isVisible(usage)).count();
    }

    private static int getUsageOffset(@NotNull Usage usage) {
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return -1;
        }
        PsiElement element2 = ((UsageInfo2UsageAdapter)usage).getElement();
        if (element2 == null) {
            return -1;
        }
        return element2.getTextRange().getStartOffset();
    }

    private static boolean areAllUsagesInOneLine(@NotNull Usage visibleUsage, @NotNull List<? extends Usage> usages) {
        Editor editor = ShowUsagesAction.getEditorFor(visibleUsage);
        if (editor == null) {
            return false;
        }
        int offset = ShowUsagesAction.getUsageOffset(visibleUsage);
        if (offset == -1) {
            return false;
        }
        int lineNumber = editor.getDocument().getLineNumber(offset);
        for (Usage usage : usages) {
            Editor otherEditor = ShowUsagesAction.getEditorFor(usage);
            if (otherEditor != editor) {
                return false;
            }
            int otherOffset = ShowUsagesAction.getUsageOffset(usage);
            if (otherOffset == -1) {
                return false;
            }
            int otherLine = otherEditor.getDocument().getLineNumber(otherOffset);
            if (otherLine == lineNumber) continue;
            return false;
        }
        return true;
    }

    private static int calcMaxWidth(@NotNull JTable table) {
        int colsNum = table.getColumnModel().getColumnCount();
        int totalWidth = 0;
        for (int col = 0; col < colsNum - 1; ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            int preferred = column.getPreferredWidth();
            int width = Math.max(preferred, ShowUsagesAction.columnMaxWidth(table, col));
            totalWidth += width;
            column.setMinWidth(width);
            column.setMaxWidth(width);
            column.setWidth(width);
            column.setPreferredWidth(width);
        }
        return totalWidth += ShowUsagesAction.columnMaxWidth(table, colsNum - 1);
    }

    private static int columnMaxWidth(@NotNull JTable table, int col) {
        TableColumn column = table.getColumnModel().getColumn(col);
        int width = 0;
        for (int row = 0; row < table.getRowCount(); ++row) {
            Component component2 = table.prepareRenderer(column.getCellRenderer(), row, col);
            int rendererWidth = component2.getPreferredSize().width;
            width = Math.max(width, rendererWidth + table.getIntercellSpacing().width);
        }
        return width;
    }

    private static void rebuildTable(@NotNull UsageViewImpl usageView, @NotNull List<UsageNode> data2, @NotNull ShowUsagesTable table, @Nullable JBPopup popup2, @NotNull RelativePoint popupPosition, @NotNull IntRef minWidth) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ShowUsagesTable.MyModel tableModel = table.setTableModel(data2);
        List existingData = tableModel.getItems();
        int row = table.getSelectedRow();
        int newSelection = ShowUsagesAction.updateModel(tableModel, existingData, data2, row == -1 ? 0 : row);
        if (newSelection < 0 || newSelection >= tableModel.getRowCount()) {
            ScrollingUtil.ensureSelectionExists((JTable)((Object)table));
            newSelection = table.getSelectedRow();
        } else {
            Object valueInTopRow;
            if (newSelection == 0 && table.getModel().getRowCount() > 1 && (valueInTopRow = table.getModel().getValueAt(0, 0)) instanceof UsageNode && usageView.isOriginUsage(((UsageNode)valueInTopRow).getUsage())) {
                ++newSelection;
            }
            table.getSelectionModel().setSelectionInterval(newSelection, newSelection);
        }
        ScrollingUtil.ensureIndexIsVisible((JTable)((Object)table), (int)newSelection, (int)0);
        if (popup2 != null) {
            ShowUsagesAction.setSizeAndDimensions((JTable)((Object)table), popup2, popupPosition, minWidth, data2);
        }
    }

    private static int updateModel(@NotNull ShowUsagesTable.MyModel tableModel, @NotNull List<? extends UsageNode> listOld, @NotNull List<? extends UsageNode> listNew, int oldSelection) {
        Object[] oa = listOld.toArray(new UsageNode[0]);
        Object[] na = listNew.toArray(new UsageNode[0]);
        List<ModelDiff.Cmd> cmds = ModelDiff.createDiffCmds(tableModel, oa, na);
        int selection = oldSelection;
        if (cmds != null) {
            for (ModelDiff.Cmd cmd : cmds) {
                selection = cmd.translateSelection(selection);
                cmd.apply();
            }
        }
        return selection;
    }

    private static void setSizeAndDimensions(@NotNull JTable table, @NotNull JBPopup popup2, @NotNull RelativePoint popupPosition, @NotNull IntRef minWidth, @NotNull List<? extends UsageNode> data2) {
        if (ShowUsagesAction.isCodeWithMeClientInstance(popup2)) {
            return;
        }
        JComponent content2 = popup2.getContent();
        Window window = SwingUtilities.windowForComponent(content2);
        Dimension d = window.getSize();
        int width = ShowUsagesAction.calcMaxWidth(table);
        width = (int)Math.max(d.getWidth(), (double)width);
        Dimension headerSize = ((AbstractPopup)popup2).getHeaderPreferredSize();
        width = Math.max((int)headerSize.getWidth(), width);
        width = Math.max(minWidth.get(), width);
        int delta = minWidth.get() == -1 ? 0 : width - minWidth.get();
        int newWidth = Math.max(width, d.width + delta);
        minWidth.set(newWidth);
        Dimension footerSize = ((AbstractPopup)popup2).getFooterPreferredSize();
        int footer = footerSize.height;
        int footerBorder = footer == 0 ? 0 : 1;
        Insets insets = ((AbstractPopup)popup2).getPopupBorder().getBorderInsets((Component)content2);
        int minHeight = headerSize.height + footer + footerBorder + insets.top + insets.bottom;
        Rectangle rectangle = ShowUsagesAction.getPreferredBounds(table, popupPosition.getScreenPoint(), newWidth, minHeight, data2.size());
        table.setSize(rectangle.width, rectangle.height - minHeight);
        if (!data2.isEmpty()) {
            ScrollingUtil.ensureSelectionExists((JTable)table);
        }
        Dimension newDim = rectangle.getSize();
        window.setBounds(rectangle);
        window.setMinimumSize(newDim);
        window.setMaximumSize(newDim);
        window.validate();
        window.repaint();
    }

    private static boolean isCodeWithMeClientInstance(@NotNull JBPopup popup2) {
        JComponent content2 = popup2.getContent();
        return content2.getClientProperty("THIN_CLIENT") != null;
    }

    @NotNull
    private static Rectangle getPreferredBounds(@NotNull JTable table, @NotNull Point point, int width, int minHeight, int modelRows) {
        boolean addExtraSpace = Registry.is((String)"ide.preferred.scrollable.viewport.extra.space");
        int visibleRows = Math.min(30, modelRows);
        int rowHeight = table.getRowHeight();
        int space = addExtraSpace && visibleRows < modelRows ? rowHeight / 2 : 0;
        int height = visibleRows * rowHeight + minHeight + space;
        Rectangle bounds2 = new Rectangle(point.x, point.y, width, height);
        ScreenUtil.fitToScreen((Rectangle)bounds2);
        if (bounds2.height != height) {
            bounds2.height = Math.max(1, (bounds2.height - (minHeight += addExtraSpace && space == 0 ? rowHeight / 2 : space)) / rowHeight) * rowHeight + minHeight;
        }
        return bounds2;
    }

    private static void addUsageNodes(@NotNull GroupNode root, @NotNull UsageViewImpl usageView, @NotNull List<? super UsageNode> outNodes) {
        for (UsageNode node : root.getUsageNodes()) {
            Usage usage = node.getUsage();
            if (!usageView.isVisible(usage)) continue;
            node.setParent((MutableTreeNode)root);
            outNodes.add((UsageNode)node);
        }
        for (GroupNode groupNode : root.getSubGroups()) {
            groupNode.setParent((MutableTreeNode)root);
            ShowUsagesAction.addUsageNodes(groupNode, usageView, outNodes);
        }
    }

    private static void navigateAndHint(@NotNull Usage usage, @NotNull String hint, @NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        usage.navigate(true);
        Editor newEditor = ShowUsagesAction.getEditorFor(usage);
        if (newEditor == null) {
            return;
        }
        ShowUsagesAction.hint(false, hint, parameters2.withEditor(newEditor), actionHandler);
    }

    private static void hint(boolean isWarning, @NotNull String hint, @NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        Project project = parameters2.project;
        Editor editor = parameters2.editor;
        Runnable runnable2 = () -> {
            if (!actionHandler.isValid()) {
                return;
            }
            JComponent label2 = ShowUsagesAction.createHintComponent(ShowUsagesAction.suggestSecondInvocation(hint, ShowUsagesActionHandler.getSecondInvocationTitle(actionHandler)), isWarning, (JComponent)ShowUsagesAction.createSettingsButton(project, ShowUsagesAction::hideHints, ShowUsagesAction.showDialogAndRestartRunnable(parameters2, actionHandler)));
            ShowUsagesActionState state = ShowUsagesAction.getState(project);
            state.continuation = ShowUsagesAction.showUsagesInMaximalScopeRunnable(parameters2, actionHandler);
            ShowUsagesAction.runWhenHidden(label2, () -> {
                state.continuation = null;
            });
            if (editor == null || editor.isDisposed() || !editor.getComponent().isShowing()) {
                int flags = 42;
                HintManager.getInstance().showHint(label2, parameters2.popupPosition, flags, 0);
            } else {
                HintManager.getInstance().showInformationHint(editor, label2);
            }
        };
        if (editor == null) {
            IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(runnable2));
        } else {
            IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> editor.getScrollingModel().runActionOnScrollingFinished(() -> IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> AsyncEditorLoader.performWhenLoaded(editor, runnable2))));
        }
    }

    @Nullable
    private static Editor getEditorFor(@NotNull Usage usage) {
        FileEditorLocation location = usage.getLocation();
        FileEditor newFileEditor = location == null ? null : location.getEditor();
        return newFileEditor instanceof TextEditor ? ((TextEditor)newFileEditor).getEditor() : null;
    }

    @NotNull
    private static Runnable showMoreUsagesRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        return () -> ShowUsagesAction.showElementUsages(parameters2.moreUsages(), actionHandler);
    }

    @NotNull
    private static Runnable showUsagesInMaximalScopeRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        return () -> ShowUsagesAction.showUsagesInMaximalScope(parameters2, actionHandler);
    }

    private static void showUsagesInMaximalScope(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        ShowUsagesAction.showElementUsages(parameters2, actionHandler.withScope(actionHandler.getMaximalScope()));
    }

    @NotNull
    private static Runnable showDialogAndRestartRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        return () -> ShowUsagesAction.showDialogAndRestart(parameters2, actionHandler);
    }

    private static void showDialogAndRestart(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        ShowUsagesActionHandler newActionHandler = actionHandler.showDialog();
        if (newActionHandler != null) {
            ShowUsagesAction.showElementUsages(parameters2, newActionHandler);
        }
    }

    @NotNull
    private static ShowUsagesActionState getState(@NotNull Project project) {
        return (ShowUsagesActionState)ServiceManager.getService((Project)project, ShowUsagesActionState.class);
    }

    private static void runWhenHidden(@NotNull Component c, @NotNull Runnable r) {
        c.addHierarchyListener(ShowUsagesAction.runWhenHidden(r));
    }

    @NotNull
    private static HierarchyListener runWhenHidden(final @NotNull Runnable r) {
        return new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (!BitUtil.isSet((long)e.getChangeFlags(), (long)2L)) {
                    return;
                }
                Component component2 = e.getComponent();
                if (component2.isDisplayable()) {
                    return;
                }
                r.run();
                component2.removeHierarchyListener(this);
            }
        };
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public void startFindUsages(@NotNull PsiElement element2, @NotNull RelativePoint popupPosition, @Nullable Editor editor, int maxUsages) {
        ShowUsagesAction.startFindUsages(element2, popupPosition, editor);
    }

    @Service
    private static final class ShowUsagesActionState {
        Runnable continuation;

        private ShowUsagesActionState() {
        }
    }

    static abstract class FilteredOutUsagesNode
    extends UsageNode {
        @NotNull
        private final String myString;
        private final String myToolTip;

        private FilteredOutUsagesNode(@NotNull Usage fakeUsage, @NotNull String string, @NotNull String toolTip) {
            super(null, fakeUsage);
            this.myString = string;
            this.myToolTip = toolTip;
        }

        public String toString() {
            return this.myString;
        }

        @NotNull
        public String getTooltip() {
            return this.myToolTip;
        }

        public abstract void onSelected();
    }

    static class StringNode
    extends UsageNode {
        @NotNull
        private final Object myString;

        private StringNode(@NotNull Object string) {
            super(null, (Usage)NullUsage.INSTANCE);
            this.myString = string;
        }

        public String toString() {
            return this.myString.toString();
        }
    }

    private static class UsageNodeComparator
    implements Comparator<UsageNode> {
        private final ShowUsagesTable myTable;

        private UsageNodeComparator(@NotNull ShowUsagesTable table) {
            this.myTable = table;
        }

        @Override
        public int compare(UsageNode c1, UsageNode c2) {
            VirtualFile v2;
            String name2;
            int weight2;
            int weight1;
            if (c1 instanceof StringNode || c2 instanceof StringNode) {
                if (c1 instanceof StringNode && c2 instanceof StringNode) {
                    return Comparing.compare((Comparable)((Object)c1.toString()), (Comparable)((Object)c2.toString()));
                }
                return c1 instanceof StringNode ? 1 : -1;
            }
            Usage o1 = c1.getUsage();
            Usage o2 = c2.getUsage();
            int n = o1 == this.myTable.USAGES_FILTERED_OUT_SEPARATOR ? 3 : (o1 == this.myTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight1 = o1 == this.myTable.MORE_USAGES_SEPARATOR ? 1 : 0));
            int n2 = o2 == this.myTable.USAGES_FILTERED_OUT_SEPARATOR ? 3 : (o2 == this.myTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight2 = o2 == this.myTable.MORE_USAGES_SEPARATOR ? 1 : 0));
            if (weight1 != weight2) {
                return weight1 - weight2;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            VirtualFile v1 = UsageListCellRenderer.getVirtualFile(o1);
            String name1 = v1 == null ? null : v1.getName();
            int i2 = Comparing.compare((Comparable)((Object)name1), (Comparable)((Object)(name2 = (v2 = UsageListCellRenderer.getVirtualFile(o2)) == null ? null : v2.getName())));
            if (i2 != 0) {
                return i2;
            }
            if (Comparing.equal((Object)v1, (Object)v2)) {
                FileEditorLocation loc1 = o1.getLocation();
                FileEditorLocation loc2 = o2.getLocation();
                return Comparing.compare((Comparable)loc1, (Comparable)loc2);
            }
            String path1 = v1 == null ? null : v1.getPath();
            String path2 = v2 == null ? null : v2.getPath();
            return Comparing.compare((Comparable)((Object)path1), (Comparable)((Object)path2));
        }
    }
}

