/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.facet.ui.FacetDependentToolWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.RegisterToolWindowTaskProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class FacetDependentToolWindowManager
implements RegisterToolWindowTaskProvider {
    FacetDependentToolWindowManager() {
    }

    @Override
    @NotNull
    public Collection<ToolWindowEP> getTasks(@NotNull Project project) {
        List facetDependentToolWindows = FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList();
        if (facetDependentToolWindows.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ToolWindowEP> result2 = new ArrayList<ToolWindowEP>();
        ProjectFacetManager projectFacetManager = ProjectFacetManager.getInstance((Project)project);
        block0: for (FacetDependentToolWindow extension : facetDependentToolWindows) {
            for (FacetType type : extension.getFacetTypes()) {
                if (!projectFacetManager.hasFacets(type.getId())) continue;
                result2.add((ToolWindowEP)extension);
                continue block0;
            }
        }
        FacetDependentToolWindowManager.projectOpened(project);
        return result2;
    }

    private static void projectOpened(final @NotNull Project project) {
        ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener((ProjectWideFacetListener)new ProjectWideFacetAdapter<Facet>(){

            public void facetAdded(@NotNull Facet facet) {
                for (FacetDependentToolWindow extension : FacetDependentToolWindowManager.getDependentExtensions(facet)) {
                    FacetDependentToolWindowManager.ensureToolWindowExists(extension, project);
                }
            }

            public void facetRemoved(@NotNull Facet facet) {
                ProjectFacetManager facetManager = ProjectFacetManager.getInstance((Project)project);
                if (facetManager.hasFacets(facet.getTypeId())) {
                    return;
                }
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                for (FacetDependentToolWindow extension : FacetDependentToolWindowManager.getDependentExtensions(facet)) {
                    ToolWindow toolWindow = toolWindowManager.getToolWindow(extension.id);
                    if (toolWindow == null) continue;
                    for (FacetType facetType : extension.getFacetTypes()) {
                        if (!facetManager.hasFacets(facetType.getId())) continue;
                        return;
                    }
                    toolWindow.remove();
                }
            }
        }, (Disposable)project);
        FacetDependentToolWindow.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FacetDependentToolWindow>(){

            public void extensionAdded(@NotNull FacetDependentToolWindow extension, @NotNull PluginDescriptor pluginDescriptor) {
                FacetDependentToolWindowManager.initToolWindowIfNeeded(extension, project);
            }

            public void extensionRemoved(@NotNull FacetDependentToolWindow extension, @NotNull PluginDescriptor pluginDescriptor) {
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(extension.id);
                if (window != null) {
                    window.remove();
                }
            }
        }, (Disposable)project);
    }

    private static void initToolWindowIfNeeded(@NotNull FacetDependentToolWindow extension, @NotNull Project project) {
        ProjectFacetManager projectFacetManager = ProjectFacetManager.getInstance((Project)project);
        for (FacetType type : extension.getFacetTypes()) {
            if (!projectFacetManager.hasFacets(type.getId())) continue;
            FacetDependentToolWindowManager.ensureToolWindowExists(extension, project);
            return;
        }
    }

    private static void ensureToolWindowExists(@NotNull FacetDependentToolWindow extension, @NotNull Project project) {
        ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(extension.id);
        if (toolWindow == null) {
            toolWindowManager.initToolWindow((ToolWindowEP)extension);
        }
    }

    @NotNull
    private static List<FacetDependentToolWindow> getDependentExtensions(@NotNull Facet<?> facet) {
        return ContainerUtil.filter((Collection)FacetDependentToolWindow.EXTENSION_POINT_NAME.getExtensionList(), toolWindowEP -> {
            for (String id2 : toolWindowEP.getFacetIds()) {
                if (!facet.getType().getStringId().equals(id2)) continue;
                return true;
            }
            return false;
        });
    }
}

