/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.pointers;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.pointers.FacetPointerImpl;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointerListener;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class FacetPointersManagerImpl
extends FacetPointersManager {
    private final Map<String, FacetPointerImpl> myPointers = new HashMap<String, FacetPointerImpl>();
    private final Map<Class<? extends Facet>, EventDispatcher<FacetPointerListener>> myDispatchers = new HashMap<Class<? extends Facet>, EventDispatcher<FacetPointerListener>>();
    @NotNull
    private final Project myProject;

    public FacetPointersManagerImpl(@NotNull Project project) {
        this.myProject = project;
        this.initComponent();
    }

    public <F extends Facet> FacetPointer<F> create(F facet) {
        String id2 = FacetPointersManagerImpl.constructId(facet);
        FacetPointerImpl<F> pointer = this.myPointers.get(id2);
        if (pointer == null) {
            if (!FacetUtil.isRegistered(facet)) {
                return this.create(id2);
            }
            pointer = new FacetPointerImpl<F>(this, facet);
            this.myPointers.put(id2, pointer);
        }
        return pointer;
    }

    public <F extends Facet> FacetPointer<F> create(String id2) {
        FacetPointerImpl pointer = this.myPointers.get(id2);
        if (pointer == null) {
            pointer = new FacetPointerImpl(this, id2);
            this.myPointers.put(id2, pointer);
        }
        return pointer;
    }

    <F extends Facet> void dispose(FacetPointer<F> pointer) {
        this.myPointers.remove(pointer.getId());
    }

    private void initComponent() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                FacetPointersManagerImpl.this.refreshPointers(module);
            }

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules2, @NotNull Function<Module, String> oldNameProvider) {
                for (Module module : modules2) {
                    FacetPointersManagerImpl.this.refreshPointers(module);
                }
            }
        });
        connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetAdded(@NotNull Facet facet) {
                FacetPointersManagerImpl.this.refreshPointers(facet.getModule());
            }

            public void beforeFacetRenamed(@NotNull Facet facet) {
                FacetPointerImpl pointer = (FacetPointerImpl)FacetPointersManagerImpl.this.myPointers.get(FacetPointersManager.constructId((Facet)facet));
                if (pointer != null) {
                    pointer.refresh();
                }
            }

            public void facetRenamed(@NotNull Facet facet, @NotNull String oldName) {
                FacetPointersManagerImpl.this.refreshPointers(facet.getModule());
            }
        });
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            this.refreshPointers(module);
        }
    }

    private void refreshPointers(@NotNull Module module) {
        ArrayList<Pair> changed2 = new ArrayList<Pair>();
        for (FacetPointerImpl pointer : this.myPointers.values()) {
            String oldId = pointer.getId();
            pointer.refresh();
            if (oldId.equals(pointer.getId())) continue;
            changed2.add(Pair.create((Object)pointer, (Object)oldId));
        }
        for (Pair pair : changed2) {
            Class facetClass;
            FacetPointerImpl pointer = (FacetPointerImpl)pair.getFirst();
            Object facet = pointer.getFacet();
            Class clazz = facetClass = facet != null ? facet.getClass() : Facet.class;
            while (facetClass != Object.class) {
                EventDispatcher<FacetPointerListener> dispatcher = this.myDispatchers.get(facetClass);
                if (dispatcher != null) {
                    ((FacetPointerListener)dispatcher.getMulticaster()).pointerIdChanged((FacetPointer)pointer, (String)pair.getSecond());
                }
                facetClass = facetClass.getSuperclass();
            }
        }
    }

    public boolean isRegistered(FacetPointer<?> pointer) {
        return this.myPointers.containsKey(pointer.getId());
    }

    public void addListener(FacetPointerListener<Facet> listener2) {
        this.addListener(Facet.class, listener2);
    }

    public void removeListener(FacetPointerListener<Facet> listener2) {
        this.removeListener(Facet.class, listener2);
    }

    public void addListener(FacetPointerListener<Facet> listener2, Disposable parentDisposable) {
        this.addListener(Facet.class, listener2, parentDisposable);
    }

    public <F extends Facet> void addListener(final Class<F> facetClass, final FacetPointerListener<F> listener2, Disposable parentDisposable) {
        this.addListener(facetClass, listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                FacetPointersManagerImpl.this.removeListener(facetClass, listener2);
            }
        });
    }

    public <F extends Facet> void addListener(Class<F> facetClass, FacetPointerListener<F> listener2) {
        EventDispatcher dispatcher = this.myDispatchers.get(facetClass);
        if (dispatcher == null) {
            dispatcher = EventDispatcher.create(FacetPointerListener.class);
            this.myDispatchers.put(facetClass, (EventDispatcher<FacetPointerListener>)dispatcher);
        }
        dispatcher.addListener(listener2);
    }

    public <F extends Facet> void removeListener(Class<F> facetClass, FacetPointerListener<F> listener2) {
        EventDispatcher<FacetPointerListener> dispatcher = this.myDispatchers.get(facetClass);
        if (dispatcher != null) {
            dispatcher.removeListener(listener2);
        }
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }
}

