/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.invalid;

import com.intellij.facet.Facet;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.invalid.InvalidFacetManager;
import com.intellij.facet.impl.invalid.InvalidFacetType;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@State(name="InvalidFacetManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class InvalidFacetManagerImpl
extends InvalidFacetManager
implements PersistentStateComponent<InvalidFacetManagerState> {
    public static final String COMPONENT_NAME = "InvalidFacetManager";
    private InvalidFacetManagerState myState = new InvalidFacetManagerState();
    private final Project myProject;

    public InvalidFacetManagerImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public boolean isIgnored(@NotNull InvalidFacet facet) {
        return this.myState.getIgnoredFacets().contains(FacetPointersManager.constructId((Facet)facet));
    }

    public InvalidFacetManagerState getState() {
        return this.myState;
    }

    public void loadState(@NotNull InvalidFacetManagerState state) {
        this.myState = state;
    }

    @Override
    public void setIgnored(@NotNull InvalidFacet facet, boolean ignored) {
        String id2 = FacetPointersManager.constructId((Facet)facet);
        if (ignored) {
            this.myState.getIgnoredFacets().add(id2);
        } else {
            this.myState.getIgnoredFacets().remove(id2);
        }
    }

    @Override
    public List<InvalidFacet> getInvalidFacets() {
        return ProjectFacetManager.getInstance((Project)this.myProject).getFacets(InvalidFacetType.TYPE_ID);
    }

    public static class InvalidFacetManagerState {
        private Set<String> myIgnoredFacets = new HashSet<String>();

        @XCollection(propertyElementName="ignored-facets", elementName="facet", valueAttributeName="id")
        public Set<String> getIgnoredFacets() {
            return this.myIgnoredFacets;
        }

        public void setIgnoredFacets(Set<String> ignoredFacets) {
            this.myIgnoredFacets = ignoredFacets;
        }
    }
}

