/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ProjectFacetListener;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.facet.impl.FacetEventsPublisher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;

final class ProjectWideFacetListenersRegistryImpl
extends ProjectWideFacetListenersRegistry {
    private final Project myProject;

    ProjectWideFacetListenersRegistryImpl(@NotNull Project project) {
        this.myProject = project;
    }

    public <F extends Facet<?>> void registerListener(@NotNull FacetTypeId<F> typeId, @NotNull ProjectWideFacetListener<? extends F> listener2) {
        FacetEventsPublisher.getInstance(this.myProject).registerListener(typeId, new ProjectWideFacetListenerWrapper(listener2));
    }

    public <F extends Facet<?>> void unregisterListener(@NotNull FacetTypeId<F> typeId, @NotNull ProjectWideFacetListener<? extends F> listener2) {
        FacetEventsPublisher.getInstance(this.myProject).unregisterListener(typeId, new ProjectWideFacetListenerWrapper(listener2));
    }

    public <F extends Facet<?>> void registerListener(final @NotNull FacetTypeId<F> typeId, final @NotNull ProjectWideFacetListener<? extends F> listener2, @NotNull Disposable parentDisposable) {
        this.registerListener(typeId, listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ProjectWideFacetListenersRegistryImpl.this.unregisterListener(typeId, listener2);
            }
        });
    }

    public void registerListener(@NotNull ProjectWideFacetListener<Facet> listener2) {
        FacetEventsPublisher.getInstance(this.myProject).registerListener(null, new ProjectWideFacetListenerWrapper(listener2));
    }

    public void unregisterListener(@NotNull ProjectWideFacetListener<Facet> listener2) {
        FacetEventsPublisher.getInstance(this.myProject).registerListener(null, new ProjectWideFacetListenerWrapper(listener2));
    }

    public void registerListener(final @NotNull ProjectWideFacetListener<Facet> listener2, @NotNull Disposable parentDisposable) {
        this.registerListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ProjectWideFacetListenersRegistryImpl.this.unregisterListener((ProjectWideFacetListener<Facet>)listener2);
            }
        });
    }

    private static class ProjectWideFacetListenerWrapper<F extends Facet<?>>
    implements ProjectFacetListener<F> {
        @NotNull
        private final ProjectWideFacetListener<F> myListener;

        private ProjectWideFacetListenerWrapper(@NotNull ProjectWideFacetListener<F> listener2) {
            this.myListener = listener2;
        }

        public void firstFacetAdded(@NotNull Project project) {
            this.myListener.firstFacetAdded();
        }

        public void facetAdded(@NotNull F facet) {
            this.myListener.facetAdded(facet);
        }

        public void beforeFacetRemoved(@NotNull F facet) {
            this.myListener.beforeFacetRemoved(facet);
        }

        public void facetRemoved(@NotNull F facet, @NotNull Project project) {
            this.myListener.facetRemoved(facet);
        }

        public void allFacetsRemoved(@NotNull Project project) {
            this.myListener.allFacetsRemoved();
        }

        public void facetConfigurationChanged(@NotNull F facet) {
            this.myListener.facetConfigurationChanged(facet);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.myListener.equals(((ProjectWideFacetListenerWrapper)o).myListener);
        }

        public int hashCode() {
            return this.myListener.hashCode();
        }
    }
}

