/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.impl.RunnerLayout;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="RunnerLayoutSettings", storages={@Storage(value="runner.layout.xml", roamingType=RoamingType.DISABLED)})
public class RunnerLayoutSettings
implements PersistentStateComponent<Element> {
    public static final String NOT_PERSISTENT_ID = "not_persistent_id";
    private final Map<String, RunnerLayout> myRunnerId2Settings = new LinkedHashMap<String, RunnerLayout>();

    public static RunnerLayoutSettings getInstance() {
        return (RunnerLayoutSettings)ServiceManager.getService(RunnerLayoutSettings.class);
    }

    public RunnerLayout getLayout(@NotNull String id2) {
        if (id2 == NOT_PERSISTENT_ID) {
            return new RunnerLayout();
        }
        RunnerLayout layout = this.myRunnerId2Settings.get(id2);
        if (layout == null) {
            layout = new RunnerLayout();
            this.myRunnerId2Settings.put(id2, layout);
        }
        return layout;
    }

    public Element getState() {
        Element runners = new Element("runners");
        for (String eachID : this.myRunnerId2Settings.keySet()) {
            RunnerLayout layout = this.myRunnerId2Settings.get(eachID);
            Element runnerElement = new Element("runner");
            runnerElement.setAttribute("id", eachID);
            layout.write(runnerElement);
            runners.addContent(runnerElement);
        }
        return runners;
    }

    public void loadState(@NotNull Element state) {
        List runners = state.getChildren("runner");
        for (Object each : runners) {
            Element eachRunnerElement = (Element)each;
            String eachID = eachRunnerElement.getAttributeValue("id");
            RunnerLayout eachLayout = new RunnerLayout();
            eachLayout.read(eachRunnerElement);
            this.myRunnerId2Settings.put(eachID, eachLayout);
        }
    }
}

