/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.CellTransform;
import com.intellij.execution.ui.layout.GridCell;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.Tab;
import com.intellij.execution.ui.layout.View;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.execution.ui.layout.actions.CloseViewAction;
import com.intellij.execution.ui.layout.actions.MinimizeViewAction;
import com.intellij.execution.ui.layout.impl.GridImpl;
import com.intellij.execution.ui.layout.impl.JBRunnerTabsBase;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewContextEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.MutualMap;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.DefaultTabPainterAdapter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.SingleHeightTabs;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabPainterAdapter;
import com.intellij.ui.tabs.impl.singleRow.ScrollableSingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GridCellImpl
implements GridCell {
    private final GridImpl myContainer;
    private final MutualMap<Content, TabInfo> myContents = new MutualMap(true);
    private final Set<Content> myMinimizedContents = new HashSet<Content>();
    private final JBTabs myTabs;
    private final GridImpl.Placeholder myPlaceholder;
    private final PlaceInGrid myPlaceInGrid;
    private final ViewContextEx myContext;
    private JBPopup myPopup;

    public GridCellImpl(ViewContextEx context, @NotNull GridImpl container2, GridImpl.Placeholder placeholder, PlaceInGrid placeInGrid) {
        this.myContext = context;
        this.myContainer = container2;
        this.myPlaceInGrid = placeInGrid;
        this.myPlaceholder = placeholder;
        this.myPlaceholder.setContentProvider(() -> this.getContents());
        this.myTabs = new GridCellTabs(context, container2);
        this.myTabs.setDataProvider(dataId -> {
            if (ViewContext.CONTENT_KEY.is(dataId)) {
                TabInfo target2 = this.myTabs.getTargetInfo();
                if (target2 != null) {
                    return new Content[]{this.getContentFor(target2)};
                }
            } else if (ViewContext.CONTEXT_KEY.is(dataId)) {
                return this.myContext;
            }
            return null;
        });
        this.myTabs.getPresentation().setSideComponentVertical(true).setFocusCycle(false).setPaintFocus(true).setTabDraggingEnabled(context.isMoveToGridActionEnabled()).setSideComponentOnTabs(false);
        this.myTabs.addTabMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (UIUtil.isCloseClick((MouseEvent)e)) {
                    GridCellImpl.this.closeOrMinimize(e);
                }
            }
        });
        this.rebuildPopupGroup();
        this.myTabs.addListener(new TabsListener(){

            public void beforeSelectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                if (oldSelection != null && GridCellImpl.this.myContext.isStateBeingRestored()) {
                    GridCellImpl.this.saveUiState();
                }
            }

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                GridCellImpl.this.updateSelection(GridCellImpl.this.myTabs.getComponent().isShowing());
                if (!GridCellImpl.this.myTabs.getComponent().isShowing()) {
                    return;
                }
                if (newSelection != null) {
                    newSelection.stopAlerting();
                }
            }
        });
    }

    public void rebuildPopupGroup() {
        this.myTabs.setPopupGroup(this.myContext.getCellPopupGroup("debuggerCellPopup"), "debuggerCellPopup", true);
    }

    public PlaceInGrid getPlaceInGrid() {
        return this.myPlaceInGrid;
    }

    void add(Content content2) {
        if (this.myContents.containsKey((Object)content2)) {
            return;
        }
        this.myContents.put((Object)content2, null);
        this.revalidateCell(() -> this.myTabs.addTab(this.createTabInfoFor(content2)));
        this.updateSelection(this.myTabs.getComponent().getRootPane() != null);
    }

    void remove(Content content2) {
        if (!this.myContents.containsKey((Object)content2)) {
            return;
        }
        TabInfo info = this.getTabFor(content2);
        this.myContents.remove((Object)content2);
        this.revalidateCell(() -> this.myTabs.removeTab(info));
        this.updateSelection(this.myTabs.getComponent().getRootPane() != null);
    }

    private void revalidateCell(Runnable contentAction) {
        if (this.myContents.size() == 0) {
            this.myPlaceholder.removeAll();
            this.myTabs.removeAllTabs();
            if (this.myPopup != null) {
                this.myPopup.cancel();
                this.myPopup = null;
            }
        } else {
            if (this.myPlaceholder.isNull()) {
                this.myPlaceholder.setContent(this.myTabs.getComponent());
            }
            contentAction.run();
        }
        this.restoreProportions();
        this.myTabs.getComponent().revalidate();
        this.myTabs.getComponent().repaint();
    }

    void setHideTabs(boolean hide) {
        this.myTabs.getPresentation().setHideTabs(hide);
    }

    private TabInfo createTabInfoFor(Content content2) {
        TabInfo tabInfo = GridCellImpl.updatePresentation(new TabInfo((JComponent)((Object)new ProviderWrapper(content2, this.myContext))), content2).setObject((Object)content2).setPreferredFocusableComponent(content2.getPreferredFocusableComponent()).setActionsContextComponent(content2.getActionsContextComponent());
        this.myContents.remove((Object)content2);
        this.myContents.put((Object)content2, (Object)tabInfo);
        ActionGroup group = (ActionGroup)this.myContext.getActionManager().getAction("Runner.View.Toolbar");
        tabInfo.setTabLabelActions(group, "debuggerCellToolbar");
        tabInfo.setDragOutDelegate((TabInfo.DragOutDelegate)((RunnerContentUi)this.myContext).myDragOutDelegate);
        return tabInfo;
    }

    @Nullable
    private static TabInfo updatePresentation(TabInfo info, Content content2) {
        if (info == null) {
            return null;
        }
        return info.setIcon(content2.getIcon()).setText(content2.getDisplayName()).setTooltipText(content2.getDescription()).setActionsContextComponent(content2.getActionsContextComponent()).setActions(content2.getActions(), content2.getPlace());
    }

    public ActionCallback select(Content content2, boolean requestFocus) {
        TabInfo tabInfo = (TabInfo)this.myContents.getValue((Object)content2);
        return tabInfo != null ? this.myTabs.select(tabInfo, requestFocus) : ActionCallback.DONE;
    }

    public void processAlert(Content content2, boolean activate2) {
        TabInfo tab;
        if (this.myMinimizedContents.contains(content2)) {
            content2.fireAlert();
        }
        if ((tab = this.getTabFor(content2)) == null) {
            return;
        }
        if (this.myTabs.getSelectedInfo() != tab) {
            if (activate2) {
                tab.fireAlert();
            } else {
                tab.stopAlerting();
            }
        }
    }

    public void updateTabPresentation(Content content2) {
        GridCellImpl.updatePresentation(this.myTabs.findInfo((Object)content2), content2);
    }

    public boolean isMinimized(Content content2) {
        return this.myMinimizedContents.contains(content2);
    }

    public boolean contains(Component c) {
        return this.myTabs.getComponent().isAncestorOf(c);
    }

    @Nullable
    TabInfo getTabFor(Content content2) {
        return (TabInfo)this.myContents.getValue((Object)content2);
    }

    @NotNull
    private Content getContentFor(TabInfo tab) {
        return (Content)this.myContents.getKey((Object)tab);
    }

    public void setToolbarHorizontal(boolean horizontal) {
        this.myTabs.getPresentation().setSideComponentVertical(!horizontal);
    }

    public void setToolbarBefore(boolean before) {
        this.myTabs.getPresentation().setSideComponentBefore(before);
    }

    public ActionCallback restoreLastUiState() {
        boolean detached;
        ActionCallback result2 = new ActionCallback();
        this.restoreProportions();
        Content[] contents = this.getContents();
        SmartList toMinimize = new SmartList();
        int window = 0;
        for (Content each : contents) {
            View view = this.myContainer.getStateFor(each);
            if (view.isMinimizedInGrid()) {
                toMinimize.add(each);
            }
            window = view.getWindow();
        }
        this.minimize(toMinimize.toArray(new Content[0]));
        Tab tab = this.myContainer.getTab();
        boolean bl = detached = tab != null && tab.isDetached(this.myPlaceInGrid) || window != this.myContext.getWindow();
        if (detached && contents.length > 0) {
            if (tab != null) {
                tab.setDetached(this.myPlaceInGrid, false);
            }
            this.myContext.detachTo(window, this).notifyWhenDone(result2);
        } else {
            result2.setDone();
        }
        return result2;
    }

    Content[] getContents() {
        return this.myContents.getKeys().toArray(new Content[this.myContents.size()]);
    }

    public int getContentCount() {
        return this.myContents.size();
    }

    public void saveUiState() {
        Window frame;
        this.saveProportions();
        for (Content each : this.myContents.getKeys()) {
            this.saveState(each, false);
        }
        for (Content each : this.myMinimizedContents) {
            this.saveState(each, true);
        }
        DimensionService service = DimensionService.getInstance();
        Dimension size = this.myContext.getContentManager().getComponent().getSize();
        service.setSize(this.getDimensionKey(), size, this.myContext.getProject());
        if (this.myContext.getWindow() != 0 && (frame = SwingUtilities.getWindowAncestor((Component)((Object)this.myPlaceholder))) != null) {
            service.setLocation(this.getDimensionKey(), frame.getLocationOnScreen());
        }
    }

    public void saveProportions() {
        this.myContainer.saveSplitterProportions(this.myPlaceInGrid);
    }

    private void saveState(Content content2, boolean minimized) {
        View state = this.myContext.getStateFor(content2);
        state.setMinimizedInGrid(minimized);
        state.setPlaceInGrid(this.myPlaceInGrid);
        List<Content> contents = this.myContainer.getContents();
        Tab tab = this.myContainer.getTabIndex();
        if (minimized && contents.size() == 1 && contents.get(0).equals(content2)) {
            state.setTabIndex(-1);
            if (tab instanceof TabImpl) {
                ((TabImpl)tab).setIndex(-1);
            }
        }
        state.assignTab(tab);
        state.setWindow(this.myContext.getWindow());
    }

    public void restoreProportions() {
        this.myContainer.restoreLastSplitterProportions(this.myPlaceInGrid);
    }

    public void updateSelection(boolean isShowing) {
        ContentManager contentManager2 = this.myContext.getContentManager();
        if (contentManager2.isDisposed()) {
            return;
        }
        for (Content each : this.myContents.getKeys()) {
            boolean isSelected;
            TabInfo eachTab = this.getTabFor(each);
            boolean bl = isSelected = eachTab != null && this.myTabs.getSelectedInfo() == eachTab;
            if (isSelected && isShowing) {
                contentManager2.addSelectedContent(each);
                continue;
            }
            contentManager2.removeFromSelection(each);
        }
        for (Content each : this.myMinimizedContents) {
            contentManager2.removeFromSelection(each);
        }
    }

    public void minimize(Content[] contents) {
        if (contents.length == 0) {
            return;
        }
        this.myContext.saveUiState();
        for (final Content each : contents) {
            this.myMinimizedContents.add(each);
            this.remove(each);
            this.saveState(each, true);
            boolean isShowing = this.myTabs.getComponent().getRootPane() != null;
            this.myContainer.minimize(each, new CellTransform.Restore(){

                public ActionCallback restoreInGrid() {
                    GridCellImpl.this.restore(each);
                    return ActionCallback.DONE;
                }
            });
            this.updateSelection(isShowing);
        }
    }

    @Nullable
    public Point getLocation() {
        return DimensionService.getInstance().getLocation(this.getDimensionKey(), this.myContext.getProject());
    }

    @Nullable
    public Dimension getSize() {
        return DimensionService.getInstance().getSize(this.getDimensionKey(), this.myContext.getProject());
    }

    private String getDimensionKey() {
        return "GridCell.Tab." + this.myContainer.getTab().getIndex() + "." + this.myPlaceInGrid.name();
    }

    public boolean isValidForCalculateProportions() {
        return this.getContentCount() > 0;
    }

    public void minimize(Content content2) {
        this.minimize(new Content[]{content2});
    }

    public void closeOrMinimize(MouseEvent e) {
        TabInfo tabInfo = this.myTabs.findInfo(e);
        if (tabInfo == null) {
            return;
        }
        Content content2 = this.getContentFor(tabInfo);
        if (CloseViewAction.isEnabled(new Content[]{content2})) {
            CloseViewAction.perform(this.myContext, content2);
        } else if (MinimizeViewAction.isEnabled(this.myContext, this.getContents(), "debuggerCellToolbar")) {
            this.minimize(content2);
        }
    }

    void restore(@NotNull Content content2) {
        this.myMinimizedContents.remove(content2);
    }

    private static class GridCellTabs
    extends SingleHeightTabs {
        private final ViewContextEx myContext;

        protected TabPainterAdapter createTabPainterAdapter() {
            return new DefaultTabPainterAdapter(JBTabPainter.getDEBUGGER());
        }

        private GridCellTabs(@NotNull ViewContextEx context, @NotNull GridImpl container2) {
            super(context.getProject(), context.getFocusManager(), (Disposable)container2);
            this.myContext = context;
            JBRunnerTabsBase tabs = ((RunnerContentUi)this.myContext).myTabs;
            ((JBTabsImpl)tabs).addNestedTabs((JBTabsImpl)this, (Disposable)this.myContext);
        }

        public boolean useSmallLabels() {
            return true;
        }

        protected SingleRowLayout createSingleRowLayout() {
            return new ScrollableSingleRowLayout((JBTabsImpl)this);
        }

        public int tabMSize() {
            return 12;
        }

        public void processDropOver(TabInfo over, RelativePoint point) {
            ((RunnerContentUi)this.myContext).myTabs.processDropOver(over, point);
        }

        public Image startDropOver(TabInfo tabInfo, RelativePoint point) {
            return ((RunnerContentUi)this.myContext).myTabs.startDropOver(tabInfo, point);
        }

        public void resetDropOver(TabInfo tabInfo) {
            ((RunnerContentUi)this.myContext).myTabs.resetDropOver(tabInfo);
        }

        @NotNull
        protected TabLabel createTabLabel(@NotNull TabInfo info) {
            return new SingleHeightTabs.SingleHeightLabel((JBTabsImpl)this, info){

                public void setAlignmentToCenter(boolean toCenter) {
                    super.setAlignmentToCenter(false);
                }
            };
        }
    }

    private static class ProviderWrapper
    extends NonOpaquePanel
    implements DataProvider {
        Content myContent;
        ViewContext myContext;

        private ProviderWrapper(Content content2, ViewContext context) {
            this.myContent = content2;
            this.myContext = context;
            this.setLayout(new BorderLayout());
            this.add(content2.getComponent(), "Center");
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (ViewContext.CONTENT_KEY.is(dataId)) {
                return new Content[]{this.myContent};
            }
            if (ViewContext.CONTEXT_KEY.is(dataId)) {
                return this.myContext;
            }
            return null;
        }
    }
}

