/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.InputRedirectAware;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgramInputRedirectPanel
extends JPanel
implements PanelWithAnchor {
    private final JBCheckBox myCheckBox = new JBCheckBox(ExecutionBundle.message((String)"redirect.input.from", (Object[])new Object[0]));
    private final TextFieldWithBrowseButton myInputFile = new TextFieldWithBrowseButton();

    public ProgramInputRedirectPanel() {
        super(new BorderLayout(10, 2));
        this.myInputFile.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFileDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.add((Component)this.myInputFile, "Center");
        this.myInputFile.setEnabled(false);
        this.add((Component)this.myCheckBox, "West");
        this.setAnchor((JComponent)this.myCheckBox);
        this.myCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramInputRedirectPanel.this.myInputFile.setEnabled(ProgramInputRedirectPanel.this.myCheckBox.isSelected());
            }
        });
    }

    @NotNull
    public TextFieldWithBrowseButton getComponent() {
        return this.myInputFile;
    }

    public JComponent getAnchor() {
        return this.myCheckBox.getAnchor();
    }

    public void setAnchor(@Nullable JComponent anchor2) {
        this.myCheckBox.setAnchor(anchor2);
    }

    public void applyTo(@NotNull InputRedirectAware.InputRedirectOptions configuration) {
        configuration.setRedirectInput(this.myCheckBox.isSelected());
        String filePath = this.myInputFile.getText();
        configuration.setRedirectInputPath(StringUtil.isEmpty((String)filePath) ? null : FileUtil.toSystemIndependentName((String)filePath));
    }

    public void reset(@Nullable InputRedirectAware.InputRedirectOptions configuration) {
        boolean isRedirectInput = configuration != null && configuration.isRedirectInput();
        this.myCheckBox.setSelected(isRedirectInput);
        this.myInputFile.setEnabled(isRedirectInput);
        this.myInputFile.setText(configuration != null ? FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)configuration.getRedirectInputPath())) : "");
    }
}

