/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.util.Key;
import jetbrains.buildServer.messages.serviceMessages.BaseTestMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import org.jetbrains.annotations.NotNull;

public class TestOutputEvent
extends TreeNodeEvent {
    private final String myText;
    private final Key myOutputType;

    public TestOutputEvent(@NotNull BaseTestMessage message, @NotNull String text, @NotNull Key outputType) {
        super(message.getTestName(), TreeNodeEvent.getNodeId((ServiceMessage)message));
        this.myText = text;
        this.myOutputType = outputType;
    }

    public TestOutputEvent(@NotNull String testName, @NotNull String text, boolean stdOut) {
        super(testName, null);
        this.myText = text;
        this.myOutputType = stdOut ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @NotNull
    public Key getOutputType() {
        return this.myOutputType;
    }

    @Override
    protected void appendToStringInfo(@NotNull StringBuilder buf) {
        TestOutputEvent.append(buf, "text", this.myText);
        TestOutputEvent.append(buf, "outputType", this.myOutputType);
    }
}

