/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.FileUrlProvider;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.runner.GeneralIdBasedToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.GeneralToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.ui.AttachToProcessListener;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerUIActionsHandler;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestLocationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SMTestRunnerConnectionUtil {
    private static final String TEST_RUNNER_DEBUG_MODE_PROPERTY = "idea.smrunner.debug";

    private SMTestRunnerConnectionUtil() {
    }

    @NotNull
    public static BaseTestsOutputConsoleView createAndAttachConsole(@NotNull String testFrameworkName, @NotNull ProcessHandler processHandler2, @NotNull TestConsoleProperties consoleProperties) throws ExecutionException {
        BaseTestsOutputConsoleView console = SMTestRunnerConnectionUtil.createConsole(testFrameworkName, consoleProperties);
        console.attachToProcess(processHandler2);
        return console;
    }

    @NotNull
    public static BaseTestsOutputConsoleView createConsole(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName(testFrameworkName);
        SMTRunnerConsoleView consoleView = new SMTRunnerConsoleView(consoleProperties, splitterPropertyName);
        SMTestRunnerConnectionUtil.initConsoleView(consoleView, testFrameworkName);
        return consoleView;
    }

    @NotNull
    public static SMTRunnerConsoleView createConsole(@NotNull SMTRunnerConsoleProperties consoleProperties) {
        return (SMTRunnerConsoleView)SMTestRunnerConnectionUtil.createConsole(consoleProperties.getTestFrameworkName(), consoleProperties);
    }

    @NotNull
    public static String getSplitterPropertyName(@NotNull String testFrameworkName) {
        return testFrameworkName + ".Splitter.Proportion";
    }

    public static void initConsoleView(final @NotNull SMTRunnerConsoleView consoleView, final @NotNull String testFrameworkName) {
        consoleView.addAttachToProcessListener(new AttachToProcessListener(){

            @Override
            public void onAttachToProcess(@NotNull ProcessHandler processHandler2) {
                SMTestLocator customLocator;
                TestProxyFilterProvider filterProvider;
                TestConsoleProperties properties = consoleView.getProperties();
                TestProxyPrinterProvider printerProvider = null;
                if (properties instanceof SMTRunnerConsoleProperties && (filterProvider = ((SMTRunnerConsoleProperties)properties).getFilterProvider()) != null) {
                    printerProvider = new TestProxyPrinterProvider(consoleView, filterProvider);
                }
                SMTestLocator testLocator = FileUrlProvider.INSTANCE;
                if (properties instanceof SMTRunnerConsoleProperties && (customLocator = ((SMTRunnerConsoleProperties)properties).getTestLocator()) != null) {
                    testLocator = new CombinedTestLocator(customLocator);
                }
                boolean idBasedTestTree = false;
                if (properties instanceof SMTRunnerConsoleProperties) {
                    idBasedTestTree = ((SMTRunnerConsoleProperties)properties).isIdBasedTestTree();
                }
                SMTestRunnerResultsForm resultsForm = consoleView.getResultsViewer();
                resultsForm.getTestsRootNode().setHandler(processHandler2);
                SMTestRunnerConnectionUtil.attachEventsProcessors(properties, resultsForm, processHandler2, testFrameworkName, testLocator, idBasedTestTree, printerProvider);
            }
        });
        consoleView.setHelpId("reference.runToolWindow.testResultsTab");
        consoleView.initUI();
    }

    public static boolean isInDebugMode() {
        return Boolean.valueOf(System.getProperty(TEST_RUNNER_DEBUG_MODE_PROPERTY));
    }

    private static void attachEventsProcessors(TestConsoleProperties consoleProperties, SMTestRunnerResultsForm resultsViewer, ProcessHandler processHandler2, String testFrameworkName, @Nullable SMTestLocator locator, boolean idBasedTestTree, @Nullable TestProxyPrinterProvider printerProvider) {
        final OutputToGeneralTestEventsConverter outputConsumer = consoleProperties instanceof SMCustomMessagesParsing ? ((SMCustomMessagesParsing)((Object)consoleProperties)).createTestEventsConverter(testFrameworkName, consoleProperties) : new OutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties);
        SMTRunnerUIActionsHandler uiActionsHandler = new SMTRunnerUIActionsHandler(consoleProperties);
        resultsViewer.addEventsListener(uiActionsHandler);
        outputConsumer.setTestingStartedHandler(() -> {
            GeneralTestEventsProcessor eventsProcessor = idBasedTestTree ? new GeneralIdBasedToSMTRunnerEventsConvertor(consoleProperties.getProject(), resultsViewer.getTestsRootNode(), testFrameworkName) : new GeneralToSMTRunnerEventsConvertor(consoleProperties.getProject(), resultsViewer.getTestsRootNode(), testFrameworkName);
            if (locator != null) {
                eventsProcessor.setLocator(locator);
            }
            if (printerProvider != null) {
                eventsProcessor.setPrinterProvider(printerProvider);
            }
            eventsProcessor.addEventsListener(resultsViewer);
            outputConsumer.setProcessor(eventsProcessor);
        });
        outputConsumer.startTesting();
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                outputConsumer.flushBufferOnProcessTermination(event.getExitCode());
                outputConsumer.finishTesting();
                Disposer.dispose((Disposable)outputConsumer);
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                outputConsumer.process(event.getText(), outputType);
            }
        });
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static SMTRunnerConsoleView createConsoleWithCustomLocator(final @NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, final @Nullable TestLocationProvider locator, final boolean idBasedTreeConstruction, final @Nullable TestProxyFilterProvider filterProvider) {
        String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName(testFrameworkName);
        final SMTRunnerConsoleView consoleView = new SMTRunnerConsoleView(consoleProperties, splitterPropertyName);
        consoleView.addAttachToProcessListener(new AttachToProcessListener(){

            @Override
            public void onAttachToProcess(@NotNull ProcessHandler processHandler2) {
                TestConsoleProperties properties = consoleView.getProperties();
                CompositeTestLocationProvider testLocator = new CompositeTestLocationProvider(locator);
                TestProxyPrinterProvider printerProvider = null;
                if (filterProvider != null) {
                    printerProvider = new TestProxyPrinterProvider(consoleView, filterProvider);
                }
                SMTestRunnerResultsForm resultsForm = consoleView.getResultsViewer();
                SMTestRunnerConnectionUtil.attachEventsProcessors(properties, resultsForm, processHandler2, testFrameworkName, testLocator, idBasedTreeConstruction, printerProvider);
            }
        });
        consoleView.setHelpId("reference.runToolWindow.testResultsTab");
        consoleView.initUI();
        return consoleView;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    private static class CompositeTestLocationProvider
    implements SMTestLocator {
        private final TestLocationProvider myPrimaryLocator;

        private CompositeTestLocationProvider(@Nullable TestLocationProvider primaryLocator) {
            this.myPrimaryLocator = primaryLocator;
        }

        @Override
        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
            List<Location> locations;
            boolean isDumbMode = DumbService.isDumb((Project)project);
            if (!(this.myPrimaryLocator == null || isDumbMode && !DumbService.isDumbAware((Object)this.myPrimaryLocator) || (locations = this.myPrimaryLocator.getLocation(protocol, path, project)).isEmpty())) {
                return locations;
            }
            if ("file".equals(protocol) && !(locations = FileUrlProvider.INSTANCE.getLocation(protocol, path, project, scope)).isEmpty()) {
                return locations;
            }
            for (TestLocationProvider provider : TestLocationProvider.EP_NAME.getExtensionList()) {
                List<Location> locations2;
                if (isDumbMode && !DumbService.isDumbAware((Object)provider) || (locations2 = provider.getLocation(protocol, path, project)).isEmpty()) continue;
                return locations2;
            }
            return Collections.emptyList();
        }
    }

    private static class CombinedTestLocator
    implements SMTestLocator,
    DumbAware {
        private final SMTestLocator myLocator;

        CombinedTestLocator(SMTestLocator locator) {
            this.myLocator = locator;
        }

        @Override
        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
            return this.getLocation(protocol, path, null, project, scope);
        }

        @Override
        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @Nullable String metainfo, @NotNull Project project, @NotNull GlobalSearchScope scope) {
            if ("file".equals(protocol)) {
                return FileUrlProvider.INSTANCE.getLocation(protocol, path, project, scope);
            }
            if (!DumbService.isDumb((Project)project) || DumbService.isDumbAware((Object)this.myLocator) || DumbService.getInstance((Project)project).isAlternativeResolveEnabled()) {
                return this.myLocator.getLocation(protocol, path, metainfo, project, scope);
            }
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Location> getLocation(@NotNull String stacktraceLine, @NotNull Project project, @NotNull GlobalSearchScope scope) {
            return this.myLocator.getLocation(stacktraceLine, project, scope);
        }

        @Override
        @NotNull
        public ModificationTracker getLocationCacheModificationTracker(@NotNull Project project) {
            return this.myLocator.getLocationCacheModificationTracker(project);
        }
    }
}

