/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUrlProvider
implements SMTestLocator,
DumbAware {
    public static final FileUrlProvider INSTANCE = new FileUrlProvider();

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        int columnNumber;
        int lineNumber;
        String filePath;
        if (!"file".equals(protocol)) {
            return Collections.emptyList();
        }
        int lastColonIndex = path.lastIndexOf(58);
        if (lastColonIndex > 3) {
            int lastValue = StringUtil.parseInt((String)path.substring(lastColonIndex + 1), (int)-1);
            int penultimateColonIndex = path.lastIndexOf(58, lastColonIndex - 1);
            if (penultimateColonIndex > 3) {
                int penultimateValue = StringUtil.parseInt((String)path.substring(penultimateColonIndex + 1, lastColonIndex), (int)-1);
                filePath = path.substring(0, penultimateColonIndex);
                lineNumber = penultimateValue;
                columnNumber = lineNumber <= 0 ? -1 : lastValue;
            } else {
                filePath = path.substring(0, lastColonIndex);
                lineNumber = lastValue;
                columnNumber = -1;
            }
        } else {
            filePath = path;
            lineNumber = -1;
            columnNumber = -1;
        }
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)filePath);
        List<VirtualFile> virtualFiles = TestsLocationProviderUtil.findSuitableFilesFor(systemIndependentPath, project);
        if (virtualFiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Location> locations = new ArrayList<Location>(2);
        for (VirtualFile file2 : virtualFiles) {
            locations.add(FileUrlProvider.createLocationFor(project, file2, lineNumber, columnNumber));
        }
        return locations;
    }

    @Nullable
    public static Location createLocationFor(@NotNull Project project, @NotNull VirtualFile virtualFile, int lineNum) {
        return FileUrlProvider.createLocationFor(project, virtualFile, lineNum, -1);
    }

    @Nullable
    public static Location createLocationFor(@NotNull Project project, @NotNull VirtualFile virtualFile, int lineNum, int columnNum) {
        int offset;
        int length;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        if (lineNum <= 0) {
            return PsiLocation.fromPsiElement((PsiElement)psiFile);
        }
        Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        if (doc == null) {
            return null;
        }
        if (lineNum > doc.getLineCount()) {
            return PsiLocation.fromPsiElement((PsiElement)psiFile);
        }
        int lineStartOffset = doc.getLineStartOffset(lineNum - 1);
        int endOffset = doc.getLineEndOffset(lineNum - 1);
        PsiElement elementAtLine = null;
        for (offset = Math.min(lineStartOffset + Math.max(columnNum - 1, 0), endOffset); offset <= endOffset && (elementAtLine = psiFile.findElementAt(offset)) instanceof PsiWhiteSpace; offset += (length = elementAtLine.getTextLength()) > 1 ? length - 1 : 1) {
        }
        if (elementAtLine instanceof PsiPlainText && offset > 0) {
            final int offsetInPlainTextFile = offset;
            return new PsiLocation<PsiPlainText>(project, (PsiPlainText)elementAtLine){

                @Nullable
                public OpenFileDescriptor getOpenFileDescriptor() {
                    VirtualFile file2 = this.getVirtualFile();
                    return file2 != null ? new OpenFileDescriptor(this.getProject(), file2, offsetInPlainTextFile) : null;
                }
            };
        }
        return PsiLocation.fromPsiElement((Project)project, (PsiElement)(elementAtLine != null ? elementAtLine : psiFile));
    }
}

