/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ui.BaseTestProxyNodeDescriptor;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class FailedTestsNavigator
implements OccurenceNavigator {
    private TestFrameworkRunningModel myModel;

    public boolean hasNextOccurence() {
        return this.myModel != null && this.getNextOccurenceInfo().hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myModel != null && this.getPreviousOccurenceInfo().hasNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        FailedTestInfo result2 = this.getNextOccurenceInfo();
        this.myModel.selectAndNotify(result2.getDefect());
        return new OccurenceNavigator.OccurenceInfo(TestsUIUtil.getOpenFileDescriptor(result2.myDefect, this.myModel), result2.getDefectNumber(), result2.getDefectsCount());
    }

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
        Disposer.register((Disposable)this.myModel, (Disposable)new Disposable(){

            public void dispose() {
                FailedTestsNavigator.this.myModel = null;
            }
        });
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        FailedTestInfo result2 = this.getPreviousOccurenceInfo();
        this.myModel.selectAndNotify(result2.getDefect());
        return new OccurenceNavigator.OccurenceInfo(TestsUIUtil.getOpenFileDescriptor(result2.myDefect, this.myModel), result2.getDefectNumber(), result2.getDefectsCount());
    }

    @NotNull
    public String getNextOccurenceActionName() {
        return FailedTestsNavigator.getNextName();
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        return FailedTestsNavigator.getPreviousName();
    }

    private FailedTestInfo getNextOccurenceInfo() {
        return new NextFailedTestInfo().execute();
    }

    private FailedTestInfo getPreviousOccurenceInfo() {
        return new PreviousFailedTestInfo().execute();
    }

    static String getNextName() {
        return ExecutionBundle.message((String)"next.faled.test.action.name", (Object[])new Object[0]);
    }

    static String getPreviousName() {
        return ExecutionBundle.message((String)"prev.faled.test.action.name", (Object[])new Object[0]);
    }

    private class PreviousFailedTestInfo
    extends FailedTestInfo {
        private PreviousFailedTestInfo() {
        }

        @Override
        protected int nextIndex(int defectIndex) {
            return defectIndex - 1;
        }

        @Override
        protected int getBoundIndex() {
            return 0;
        }
    }

    private class NextFailedTestInfo
    extends FailedTestInfo {
        private NextFailedTestInfo() {
        }

        @Override
        protected int nextIndex(int defectIndex) {
            return defectIndex + 1;
        }

        @Override
        protected int getBoundIndex() {
            return this.getDefectsCount() - 1;
        }
    }

    protected abstract class FailedTestInfo {
        private AbstractTestProxy myDefect = null;
        private List<AbstractTestProxy> myAllTests;
        private List<AbstractTestProxy> myDefects;

        protected FailedTestInfo() {
        }

        public AbstractTestProxy getDefect() {
            return this.myDefect;
        }

        private int getDefectNumber() {
            return this.myDefect == null ? this.getDefectsCount() : this.myDefects.indexOf(this.myDefect) + 1;
        }

        public FailedTestInfo execute() {
            this.myAllTests = new ArrayList<AbstractTestProxy>();
            this.collectTests(this.myAllTests, (TreeNode)FailedTestsNavigator.this.myModel.getTreeView().getModel().getRoot());
            this.myDefects = Filter.DEFECTIVE_LEAF.select(this.myAllTests);
            if (this.myDefects.isEmpty()) {
                return this;
            }
            AbstractTestProxy selectedTest = FailedTestsNavigator.this.myModel.getTreeView().getSelectedTest();
            int selectionIndex = this.myAllTests.indexOf(selectedTest);
            if (selectionIndex == -1) {
                return this;
            }
            AbstractTestProxy defect = this.findNextDefect(selectionIndex);
            if (defect == null) {
                return this;
            }
            if (defect != selectedTest) {
                this.myDefect = defect;
                return this;
            }
            int defectIndex = this.myDefects.indexOf(defect);
            if (defectIndex == -1 || defectIndex == this.getBoundIndex()) {
                return this;
            }
            this.myDefect = this.myDefects.get(this.nextIndex(defectIndex));
            return this;
        }

        private void collectTests(List<? super AbstractTestProxy> tests, TreeNode node) {
            if (node == null) {
                return;
            }
            Object elementFor = TreeUtil.getUserObject((Object)node);
            if (elementFor instanceof BaseTestProxyNodeDescriptor) {
                elementFor = ((BaseTestProxyNodeDescriptor)((Object)elementFor)).getElement();
            }
            if (elementFor instanceof AbstractTestProxy) {
                tests.add((AbstractTestProxy)elementFor);
            }
            for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                this.collectTests(tests, node.getChildAt(i2));
            }
        }

        private AbstractTestProxy findNextDefect(int startIndex) {
            int i2 = this.nextIndex(startIndex);
            while (0 <= i2 && i2 < this.myAllTests.size()) {
                AbstractTestProxy nextDefect = this.myAllTests.get(i2);
                if (Filter.DEFECTIVE_LEAF.shouldAccept(nextDefect)) {
                    return nextDefect;
                }
                i2 = this.nextIndex(i2);
            }
            return null;
        }

        protected abstract int nextIndex(int var1);

        protected abstract int getBoundIndex();

        protected int getDefectsCount() {
            return this.myDefects.size();
        }

        private boolean hasNextOccurence() {
            return this.myDefect != null;
        }
    }
}

