/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDnDDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewManagerImpl;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ServiceViewDragHelper {
    ServiceViewDragHelper() {
    }

    static DnDSource createSource(@NotNull ServiceView serviceView) {
        return new ServiceViewDnDSource(serviceView);
    }

    static DnDTarget createTarget(@NotNull JTree tree) {
        return new ServiceViewDnDTarget(tree);
    }

    static void installDnDSupport(final @NotNull Project project, final @NotNull InternalDecorator decorator, final @NotNull ContentManager contentManager2) {
        final Content dropTargetContent = ServiceViewDragHelper.createDropTargetContent();
        DnDSupport.createBuilder((JComponent)decorator).setTargetChecker(new DnDTargetChecker(){

            public boolean update(DnDEvent event) {
                Object o = event.getAttachedObject();
                boolean dropPossible = o instanceof ServiceViewDragBean && event.getPoint().y < decorator.getHeaderHeight();
                event.setDropPossible(dropPossible, "");
                if (dropPossible) {
                    ServiceViewDragBean dragBean;
                    if (contentManager2.getIndexOfContent(dropTargetContent) < 0) {
                        contentManager2.addContent(dropTargetContent);
                    }
                    ItemPresentation presentation2 = (dragBean = (ServiceViewDragBean)o).getItems().size() > 1 && dragBean.getContributor() != null ? dragBean.getContributor().getViewDescriptor(project).getPresentation() : dragBean.getItems().get(0).getViewDescriptor().getPresentation();
                    dropTargetContent.setDisplayName(ServiceViewDragHelper.getDisplayName(presentation2));
                    dropTargetContent.setIcon(presentation2.getIcon(false));
                } else if (contentManager2.getIndexOfContent(dropTargetContent) >= 0) {
                    contentManager2.removeContent(dropTargetContent, false);
                }
                return true;
            }
        }).setCleanUpOnLeaveCallback(() -> {
            if (!contentManager2.isDisposed() && contentManager2.getIndexOfContent(dropTargetContent) >= 0) {
                contentManager2.removeContent(dropTargetContent, false);
            }
        }).setDropHandler(new DnDDropHandler(){

            public void drop(DnDEvent event) {
                Object o = event.getAttachedObject();
                if (o instanceof ServiceViewDragBean) {
                    ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project)).extract((ServiceViewDragBean)o);
                }
            }
        }).install();
        decorator.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (contentManager2.getIndexOfContent(dropTargetContent) >= 0) {
                    contentManager2.removeContent(dropTargetContent, false);
                }
            }
        });
    }

    static String getDisplayName(ItemPresentation presentation2) {
        StringBuilder result2 = new StringBuilder();
        if (presentation2 instanceof PresentationData) {
            List fragments = ((PresentationData)presentation2).getColoredText();
            if (fragments.isEmpty() && presentation2.getPresentableText() != null) {
                result2.append(presentation2.getPresentableText());
            } else {
                for (PresentableNodeDescriptor.ColoredFragment fragment : fragments) {
                    result2.append(fragment.getText());
                }
            }
        } else if (presentation2.getPresentableText() != null) {
            result2.append(presentation2.getPresentableText());
        }
        return result2.toString();
    }

    @Nullable
    static ServiceViewContributor getTheOnlyRootContributor(List<ServiceModel.ServiceViewItem> items) {
        ServiceViewContributor<?> result2 = null;
        for (ServiceModel.ServiceViewItem node : items) {
            if (result2 == null) {
                result2 = node.getRootContributor();
                continue;
            }
            if (result2 == node.getRootContributor()) continue;
            return null;
        }
        return result2;
    }

    private static Content createDropTargetContent() {
        Content content2 = ContentFactory.SERVICE.getInstance().createContent((JComponent)new JPanel(), null, false);
        content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        content2.setCloseable(true);
        return content2;
    }

    private static class ServiceViewDnDTarget
    implements DnDTarget {
        private final JTree myTree;

        ServiceViewDnDTarget(@NotNull JTree tree) {
            this.myTree = tree;
        }

        public void drop(DnDEvent event) {
            EventContext eventContext = this.getEventContext(event.getPoint());
            if (eventContext == null) {
                return;
            }
            if (eventContext.descriptor.canDrop(event, ServiceViewDnDDescriptor.Position.INTO)) {
                eventContext.descriptor.drop(event, ServiceViewDnDDescriptor.Position.INTO);
            } else {
                eventContext.descriptor.drop(event, eventContext.getPosition());
            }
            event.hideHighlighter();
        }

        public boolean update(DnDEvent event) {
            event.setDropPossible(false);
            EventContext eventContext = this.getEventContext(event.getPoint());
            if (eventContext == null) {
                return true;
            }
            if (eventContext.descriptor.canDrop(event, ServiceViewDnDDescriptor.Position.INTO)) {
                event.setDropPossible(true);
                RelativeRectangle rectangle = new RelativeRectangle((Component)this.myTree, eventContext.cellBounds);
                event.setHighlighting(rectangle, 1);
                return false;
            }
            ServiceViewDnDDescriptor.Position position = eventContext.getPosition();
            if (eventContext.descriptor.canDrop(event, position)) {
                event.setDropPossible(true);
                if (position != ServiceViewDnDDescriptor.Position.ABOVE) {
                    eventContext.cellBounds.y += eventContext.cellBounds.height - 2;
                }
                RelativeRectangle rectangle = new RelativeRectangle((Component)this.myTree, eventContext.cellBounds);
                rectangle.getDimension().height = 2;
                event.setHighlighting(rectangle, 2);
                return false;
            }
            event.hideHighlighter();
            return false;
        }

        private EventContext getEventContext(Point point) {
            TreePath path = this.myTree.getPathForLocation(point.x, point.y);
            if (path == null || !(path.getLastPathComponent() instanceof ServiceModel.ServiceViewItem)) {
                return null;
            }
            Rectangle cellBounds = this.myTree.getPathBounds(path);
            if (cellBounds == null) {
                return null;
            }
            ServiceModel.ServiceViewItem item = (ServiceModel.ServiceViewItem)path.getLastPathComponent();
            ServiceViewDescriptor viewDescriptor = item.getViewDescriptor();
            if (!(viewDescriptor instanceof ServiceViewDnDDescriptor)) {
                return null;
            }
            return new EventContext(point, cellBounds, (ServiceViewDnDDescriptor)viewDescriptor);
        }

        private static class EventContext {
            final Point point;
            final Rectangle cellBounds;
            final ServiceViewDnDDescriptor descriptor;

            private EventContext(Point point, Rectangle cellBounds, ServiceViewDnDDescriptor descriptor2) {
                this.point = point;
                this.cellBounds = cellBounds;
                this.descriptor = descriptor2;
            }

            ServiceViewDnDDescriptor.Position getPosition() {
                return this.point.y < this.cellBounds.y + this.cellBounds.height / 2 ? ServiceViewDnDDescriptor.Position.ABOVE : ServiceViewDnDDescriptor.Position.BELOW;
            }
        }
    }

    private static class ServiceViewDnDSource
    implements DnDSource {
        private final ServiceView myServiceView;

        ServiceViewDnDSource(@NotNull ServiceView serviceView) {
            this.myServiceView = serviceView;
        }

        public boolean canStartDragging(DnDAction action2, Point dragOrigin) {
            return !this.myServiceView.getSelectedItems().isEmpty();
        }

        public DnDDragStartBean startDragging(DnDAction action2, Point dragOrigin) {
            return new DnDDragStartBean((Object)new ServiceViewDragBean(this.myServiceView, this.myServiceView.getSelectedItems()));
        }

        public void dropActionChanged(int gestureModifiers) {
        }

        public Pair<Image, Point> createDraggedImage(DnDAction action2, Point dragOrigin, @NotNull DnDDragStartBean bean) {
            ServiceViewDragBean dragBean = (ServiceViewDragBean)bean.getAttachedObject();
            int size = dragBean.getItems().size();
            ItemPresentation presentation2 = null;
            if (size == 1) {
                presentation2 = dragBean.getItems().get(0).getViewDescriptor().getPresentation();
            } else {
                ServiceViewContributor contributor = dragBean.getContributor();
                if (contributor != null) {
                    presentation2 = contributor.getViewDescriptor(this.myServiceView.getProject()).getPresentation();
                }
            }
            SimpleColoredComponent c = new SimpleColoredComponent();
            c.setForeground(this.myServiceView.getForeground());
            c.setBackground(this.myServiceView.getBackground());
            if (presentation2 != null) {
                c.setIcon(presentation2.getIcon(false));
                c.append(ServiceViewDragHelper.getDisplayName(presentation2));
            } else {
                String text = ExecutionBundle.message((String)"service.view.items", (Object[])new Object[]{size});
                c.append(text);
            }
            Dimension preferredSize = c.getPreferredSize();
            c.setSize(preferredSize);
            BufferedImage image = UIUtil.createImage((Component)c, (int)preferredSize.width, (int)preferredSize.height, (int)2);
            c.setOpaque(false);
            Graphics2D g = image.createGraphics();
            c.paint((Graphics)g);
            g.dispose();
            return Pair.create((Object)image, (Object)new Point(0, 0));
        }
    }

    static class ServiceViewDragBean
    implements DataProvider {
        private final ServiceView myServiceView;
        private final List<ServiceModel.ServiceViewItem> myItems;
        private final ServiceViewContributor myContributor;

        ServiceViewDragBean(@NotNull ServiceView serviceView, @NotNull List<ServiceModel.ServiceViewItem> items) {
            this.myServiceView = serviceView;
            this.myItems = ContainerUtil.filter(items, item -> {
                for (ServiceModel.ServiceViewItem parent = item.getParent(); parent != null; parent = parent.getParent()) {
                    if (!items.contains(parent)) continue;
                    return false;
                }
                return true;
            });
            this.myContributor = ServiceViewDragHelper.getTheOnlyRootContributor(this.myItems);
        }

        @NotNull
        ServiceView getServiceView() {
            return this.myServiceView;
        }

        @NotNull
        List<ServiceModel.ServiceViewItem> getItems() {
            return this.myItems;
        }

        @Nullable
        ServiceViewContributor getContributor() {
            return this.myContributor;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return ContainerUtil.map2Array(this.myItems, ServiceModel.ServiceViewItem::getValue);
            }
            return null;
        }
    }
}

