/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewActionProvider;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewManagerImpl;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class OpenEachInNewTabAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        ServiceView serviceView = ServiceViewActionProvider.getSelectedView(e);
        boolean enabled = serviceView != null && !serviceView.getSelectedItems().isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || !ActionPlaces.isPopupPlace((String)e.getPlace()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        ServiceView serviceView = ServiceViewActionProvider.getSelectedView(e);
        if (serviceView == null) {
            return;
        }
        ServiceViewManagerImpl manager = (ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)project);
        for (ServiceModel.ServiceViewItem item : serviceView.getSelectedItems()) {
            manager.extract(new ServiceViewDragHelper.ServiceViewDragBean(serviceView, Collections.singletonList(item)));
        }
    }
}

