/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProcessStreamsSynchronizer {
    static final long AWAIT_SAME_STREAM_TEXT_NANO = TimeUnit.MILLISECONDS.toNanos(10L);
    private final Object myLock = new Object();
    private final List<Chunk> myPendingChunks = new ArrayList<Chunk>();
    private final Alarm myAlarm;
    private final boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
    private boolean myFlushedChunksEndWithNewline = true;
    private ProcessOutputType myLastFlushedChunkBaseOutputType = null;
    private long myLastFlushedChunkCreatedNanoTime = 0L;
    private int myReschedules = 0;

    ProcessStreamsSynchronizer(@NotNull Disposable parentDisposable) {
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                Object object = ProcessStreamsSynchronizer.this.myLock;
                synchronized (object) {
                    ProcessStreamsSynchronizer.this.flushAllPendingChunks();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doWhenStreamsSynchronized(@NotNull String text, @NotNull ProcessOutputType outputType, @NotNull Runnable flushRunnable) {
        long nowNano = this.getNanoTime();
        Object object = this.myLock;
        synchronized (object) {
            Boolean textEndsWithNewline;
            ProcessOutputType baseOutputType = outputType.getBaseOutputType();
            if (ProcessOutputType.SYSTEM.equals((Object)baseOutputType)) {
                this.handleSystemOutput(flushRunnable, nowNano);
                return;
            }
            Boolean bl = textEndsWithNewline = text.isEmpty() ? null : Boolean.valueOf(StringUtil.endsWithChar((CharSequence)text, (char)'\n'));
            if (this.myLastFlushedChunkBaseOutputType == null || baseOutputType.equals((Object)this.myLastFlushedChunkBaseOutputType)) {
                boolean newlineAdded;
                boolean bl2 = newlineAdded = !this.myFlushedChunksEndWithNewline && Boolean.TRUE.equals(textEndsWithNewline);
                if (textEndsWithNewline != null) {
                    this.myFlushedChunksEndWithNewline = textEndsWithNewline;
                }
                this.myLastFlushedChunkBaseOutputType = baseOutputType;
                this.myLastFlushedChunkCreatedNanoTime = nowNano;
                flushRunnable.run();
                if (newlineAdded && this.myPendingChunks.size() > 0 && this.myPendingChunks.get(0).getNanoTimePassedSinceLastFlushedChunk(nowNano) >= AWAIT_SAME_STREAM_TEXT_NANO) {
                    this.processPendingChunks(nowNano);
                }
                return;
            }
            Chunk chunk = new Chunk(textEndsWithNewline, baseOutputType, nowNano, this.myLastFlushedChunkCreatedNanoTime, flushRunnable);
            this.myPendingChunks.add(chunk);
            if (!this.isProcessingScheduled()) {
                long delayNano = AWAIT_SAME_STREAM_TEXT_NANO - chunk.getNanoTimePassedSinceLastFlushedChunk(nowNano);
                if (delayNano <= 0L) {
                    this.processPendingChunks(nowNano);
                } else {
                    ++this.myReschedules;
                    this.scheduleProcessPendingChunks(delayNano);
                }
            }
        }
    }

    boolean isProcessingScheduled() {
        return !this.myAlarm.isEmpty();
    }

    long getNanoTime() {
        return System.nanoTime();
    }

    void scheduleProcessPendingChunks(long delayNano) {
        this.myAlarm.addRequest(() -> this.processPendingChunks(this.getNanoTime()), TimeUnit.NANOSECONDS.toMillis(delayNano));
    }

    private void handleSystemOutput(@NotNull Runnable flushRunnable, long nowNano) {
        if (this.myPendingChunks.isEmpty()) {
            flushRunnable.run();
            return;
        }
        Chunk first = this.myPendingChunks.get(0);
        this.myPendingChunks.add(new Chunk(null, first.myBaseOutputType, nowNano, this.myLastFlushedChunkCreatedNanoTime, flushRunnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void processPendingChunks(long nowNano) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myPendingChunks.isEmpty()) {
                this.myReschedules = 0;
                return;
            }
            Chunk eldestChunk = this.myPendingChunks.get(0);
            long awaitNano = eldestChunk.getNanoTimePassedSinceLastFlushedChunk(nowNano);
            if (awaitNano >= AWAIT_SAME_STREAM_TEXT_NANO && this.myFlushedChunksEndWithNewline || this.myReschedules > (this.isUnitTestMode ? 10 : 1)) {
                this.flushAllPendingChunks();
            }
            if (!this.myPendingChunks.isEmpty()) {
                ++this.myReschedules;
                this.scheduleProcessPendingChunks(AWAIT_SAME_STREAM_TEXT_NANO);
            } else {
                this.myReschedules = 0;
            }
        }
    }

    private void flushAllPendingChunks() {
        for (Chunk chunk : this.myPendingChunks) {
            this.flush(chunk);
        }
        this.myPendingChunks.clear();
    }

    private void flush(@NotNull Chunk chunk) {
        if (chunk.myTextEndsWithNewline != null) {
            this.myFlushedChunksEndWithNewline = chunk.myTextEndsWithNewline;
        }
        this.myLastFlushedChunkBaseOutputType = chunk.myBaseOutputType;
        this.myLastFlushedChunkCreatedNanoTime = chunk.myCreatedNanoTime;
        chunk.myFlushRunnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForAllFlushed() {
        while (true) {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myPendingChunks.isEmpty()) {
                    return;
                }
                if (this.myAlarm.isEmpty()) {
                    throw new RuntimeException("No requests scheduled");
                }
            }
            try {
                this.myAlarm.waitForAllExecuted(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class Chunk {
        @Nullable
        private final Boolean myTextEndsWithNewline;
        private final ProcessOutputType myBaseOutputType;
        private final long myCreatedNanoTime;
        private final long myPrevFlushedChunkCreatedNanoTime;
        private final Runnable myFlushRunnable;

        private Chunk(@Nullable Boolean textEndsWithNewline, @NotNull ProcessOutputType baseOutputType, long createdNanoTime, long prevFlushedChunkCreatedNanoTime, @NotNull Runnable flushRunnable) {
            this.myTextEndsWithNewline = textEndsWithNewline;
            this.myBaseOutputType = baseOutputType;
            this.myCreatedNanoTime = createdNanoTime;
            this.myPrevFlushedChunkCreatedNanoTime = prevFlushedChunkCreatedNanoTime;
            this.myFlushRunnable = flushRunnable;
        }

        long getNanoTimePassedSinceLastFlushedChunk(long nowNanoTime) {
            return this.myPrevFlushedChunkCreatedNanoTime > 0L ? nowNanoTime - this.myPrevFlushedChunkCreatedNanoTime : nowNanoTime - this.myCreatedNanoTime;
        }

        public String toString() {
            return "ends-with-newline='" + this.myTextEndsWithNewline + '\'' + ", outputType=" + this.myBaseOutputType;
        }
    }
}

