/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.ProjectTopics;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ModuleRunConfigurationManager")
public final class ModuleRunConfigurationManager
implements PersistentStateComponent<Element> {
    @NonNls
    @NotNull
    private static final String STORE_LOCAL_REGISTRY_OPTION = "ruby.store.local.run.conf.in.modules";
    private static final String SHARED = "shared";
    private static final String LOCAL = "local";
    private static final Logger LOG = Logger.getInstance(ModuleRunConfigurationManager.class);
    @NotNull
    private final Module myModule;
    @NotNull
    private final Condition<RunnerAndConfigurationSettings> myModuleConfigCondition = settings -> settings != null && this.usesMyModule((RunnerAndConfigurationSettings)settings);

    public ModuleRunConfigurationManager(@NotNull Module module) {
        this.myModule = module;
        this.myModule.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
                if (ModuleRunConfigurationManager.this.myModule.equals(module)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("time to remove something from project (" + project + ")");
                    }
                    ModuleRunConfigurationManager.this.getRunManager().removeConfigurations(ModuleRunConfigurationManager.this.getModuleRunConfigurationSettings());
                }
            }
        });
    }

    @Nullable
    public Element getState() {
        try {
            Element element2 = new Element("state").addContent(this.writeExternal(new Element(SHARED), true));
            if (Registry.is((String)STORE_LOCAL_REGISTRY_OPTION)) {
                element2.addContent(this.writeExternal(new Element(LOCAL), false));
            }
            return element2;
        }
        catch (WriteExternalException e1) {
            LOG.error((Throwable)e1);
            return null;
        }
    }

    public void loadState(@NotNull Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private Collection<? extends RunnerAndConfigurationSettings> getModuleRunConfigurationSettings() {
        return ContainerUtil.filter(this.getRunManager().getAllSettings(), this.myModuleConfigCondition);
    }

    @NotNull
    private RunManagerImpl getRunManager() {
        return (RunManagerImpl)RunManager.getInstance((Project)this.myModule.getProject());
    }

    private boolean usesMyModule(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        if (runnerAndConfigurationSettings.isStoredInArbitraryFileInProject()) {
            return false;
        }
        RunConfiguration config2 = runnerAndConfigurationSettings.getConfiguration();
        return config2 instanceof ModuleBasedConfiguration && this.myModule.equals(((ModuleBasedConfiguration)config2).getConfigurationModule().getModule());
    }

    public Element writeExternal(@NotNull Element element2, boolean isShared) throws WriteExternalException {
        LOG.debug("writeExternal(" + this.myModule + "); shared: " + isShared);
        this.getRunManager().writeConfigurations(element2, ContainerUtil.filter(this.getModuleRunConfigurationSettings(), settings -> settings.isStoredInDotIdeaFolder() == isShared));
        return element2;
    }

    public void readExternal(@NotNull Element element2) {
        Element localElement;
        Element sharedElement = element2.getChild(SHARED);
        if (sharedElement != null) {
            this.doReadExternal(sharedElement, true);
        }
        if ((localElement = element2.getChild(LOCAL)) != null) {
            this.doReadExternal(localElement, false);
        }
    }

    private void doReadExternal(@NotNull Element element2, boolean isShared) {
        LOG.debug("readExternal(" + this.myModule + ");  shared: " + isShared);
        RunManagerImpl runManager = this.getRunManager();
        for (Element child2 : element2.getChildren("configuration")) {
            runManager.loadConfiguration(child2, isShared);
        }
        runManager.requestSort();
    }

    static class ModuleRunConfigurationManagerStartupActivity
    implements StartupActivity {
        ModuleRunConfigurationManagerStartupActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (!project.isDefault()) {
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    if (module.isDisposed()) continue;
                    module.getService(ModuleRunConfigurationManager.class);
                }
            }
        }
    }
}

