/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.impl.AsyncFilterRunner;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHyperlinkSupport {
    private static final Key<TextAttributes> OLD_HYPERLINK_TEXT_ATTRIBUTES = Key.create((String)"OLD_HYPERLINK_TEXT_ATTRIBUTES");
    private static final Key<HyperlinkInfoTextAttributes> HYPERLINK = Key.create((String)"HYPERLINK");
    private static final Key<EditorHyperlinkSupport> EDITOR_HYPERLINK_SUPPORT_KEY = Key.create((String)"EDITOR_HYPERLINK_SUPPORT_KEY");
    private final EditorEx myEditor;
    @NotNull
    private final Project myProject;
    private final AsyncFilterRunner myFilterRunner;

    public EditorHyperlinkSupport(@NotNull Editor editor, @NotNull Project project) {
        this.myEditor = (EditorEx)editor;
        this.myProject = project;
        this.myFilterRunner = new AsyncFilterRunner(this, this.myEditor);
        editor.addEditorMouseListener(new EditorMouseListener(){
            private MouseEvent myInitialMouseEvent = null;

            public void mousePressed(@NotNull EditorMouseEvent e) {
                this.myInitialMouseEvent = e.getMouseEvent();
            }

            public void mouseReleased(@NotNull EditorMouseEvent e) {
                MouseEvent initialMouseEvent = this.myInitialMouseEvent;
                this.myInitialMouseEvent = null;
                MouseEvent mouseEvent = e.getMouseEvent();
                if (mouseEvent.getButton() == 1 && !mouseEvent.isPopupTrigger()) {
                    if (!(initialMouseEvent == null || mouseEvent.getComponent() == initialMouseEvent.getComponent() && mouseEvent.getPoint().equals(initialMouseEvent.getPoint()))) {
                        return;
                    }
                    Runnable runnable2 = EditorHyperlinkSupport.this.getLinkNavigationRunnable(e.getLogicalPosition());
                    if (runnable2 != null) {
                        runnable2.run();
                    }
                }
            }
        });
        editor.addEditorMouseMotionListener(new EditorMouseMotionListener(){

            public void mouseMoved(@NotNull EditorMouseEvent e) {
                if (e.getArea() != EditorMouseEventArea.EDITING_AREA) {
                    return;
                }
                HyperlinkInfo info = EditorHyperlinkSupport.this.getHyperlinkInfoByEvent(e);
                EditorHyperlinkSupport.this.myEditor.setCustomCursor(EditorHyperlinkSupport.class, info == null ? null : Cursor.getPredefinedCursor(12));
            }
        });
    }

    public static EditorHyperlinkSupport get(@NotNull Editor editor) {
        EditorHyperlinkSupport instance = (EditorHyperlinkSupport)editor.getUserData(EDITOR_HYPERLINK_SUPPORT_KEY);
        if (instance == null) {
            Project project = editor.getProject();
            assert (project != null);
            instance = new EditorHyperlinkSupport(editor, project);
            editor.putUserData(EDITOR_HYPERLINK_SUPPORT_KEY, (Object)instance);
        }
        return instance;
    }

    public void clearHyperlinks() {
        for (RangeHighlighter highlighter : EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor)) {
            this.removeHyperlink(highlighter);
        }
    }

    public void waitForPendingFilters(long timeoutMs) {
        this.myFilterRunner.waitForPendingFilters(timeoutMs);
    }

    @Deprecated
    public Map<RangeHighlighter, HyperlinkInfo> getHyperlinks() {
        LinkedHashMap result2 = new LinkedHashMap();
        for (RangeHighlighter highlighter : EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor)) {
            HyperlinkInfo info = EditorHyperlinkSupport.getHyperlinkInfo(highlighter);
            if (info == null) continue;
            result2.put((Object)highlighter, (Object)info);
        }
        return result2;
    }

    @Nullable
    public Runnable getLinkNavigationRunnable(LogicalPosition logical) {
        if (EditorUtil.inVirtualSpace(this.myEditor, logical)) {
            return null;
        }
        int positionOffset = this.myEditor.logicalPositionToOffset(logical);
        RangeHighlighter range2 = this.findLinkRangeAt(positionOffset);
        if (range2 != null) {
            if (range2.getEndOffset() == positionOffset) {
                return null;
            }
            HyperlinkInfo hyperlinkInfo = EditorHyperlinkSupport.getHyperlinkInfo(range2);
            if (hyperlinkInfo != null) {
                return () -> {
                    if (hyperlinkInfo instanceof HyperlinkInfoBase) {
                        Point point = this.myEditor.logicalPositionToXY(logical);
                        MouseEvent event = new MouseEvent(this.myEditor.getContentComponent(), 0, 0L, 0, point.x, point.y, 1, false);
                        ((HyperlinkInfoBase)hyperlinkInfo).navigate(this.myProject, new RelativePoint(event));
                    } else {
                        hyperlinkInfo.navigate(this.myProject);
                    }
                    EditorHyperlinkSupport.linkFollowed(this.myEditor, EditorHyperlinkSupport.getHyperlinks(0, this.myEditor.getDocument().getTextLength(), this.myEditor), range2);
                };
            }
        }
        return null;
    }

    @Nullable
    public static HyperlinkInfo getHyperlinkInfo(@NotNull RangeHighlighter range2) {
        HyperlinkInfoTextAttributes attributes = (HyperlinkInfoTextAttributes)((Object)range2.getUserData(HYPERLINK));
        return attributes != null ? attributes.getHyperlinkInfo() : null;
    }

    @Nullable
    private RangeHighlighter findLinkRangeAt(int offset) {
        Iterator<RangeHighlighter> iterator2 = EditorHyperlinkSupport.getHyperlinks(offset, offset, this.myEditor).iterator();
        if (iterator2.hasNext()) {
            RangeHighlighter highlighter = iterator2.next();
            return highlighter;
        }
        return null;
    }

    @Nullable
    public HyperlinkInfo getHyperlinkAt(int offset) {
        RangeHighlighter range2 = this.findLinkRangeAt(offset);
        return range2 == null ? null : EditorHyperlinkSupport.getHyperlinkInfo(range2);
    }

    public List<RangeHighlighter> findAllHyperlinksOnLine(int line) {
        int lineStart = this.myEditor.getDocument().getLineStartOffset(line);
        int lineEnd = this.myEditor.getDocument().getLineEndOffset(line);
        return EditorHyperlinkSupport.getHyperlinks(lineStart, lineEnd, this.myEditor);
    }

    private static List<RangeHighlighter> getHyperlinks(int startOffset, int endOffset, Editor editor) {
        MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor();
        markupModel.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new FilteringProcessor(rangeHighlighterEx -> rangeHighlighterEx.isValid() && EditorHyperlinkSupport.getHyperlinkInfo(rangeHighlighterEx) != null, (Processor)processor2));
        return new ArrayList<RangeHighlighter>(processor2.getResults());
    }

    public void removeHyperlink(@NotNull RangeHighlighter hyperlink) {
        this.myEditor.getMarkupModel().removeHighlighter(hyperlink);
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByLineAndCol(int line, int col) {
        return this.getHyperlinkAt(this.myEditor.logicalPositionToOffset(new LogicalPosition(line, col)));
    }

    @Deprecated
    public void addHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo) {
        this.createHyperlink(highlightStartOffset, highlightEndOffset, highlightAttributes, hyperlinkInfo);
    }

    public void createHyperlink(@NotNull RangeHighlighter highlighter, @NotNull HyperlinkInfo hyperlinkInfo) {
        EditorHyperlinkSupport.associateHyperlink(highlighter, hyperlinkInfo, null);
    }

    @NotNull
    public RangeHighlighter createHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo) {
        return this.createHyperlink(highlightStartOffset, highlightEndOffset, highlightAttributes, hyperlinkInfo, null, 5900);
    }

    @NotNull
    private RangeHighlighter createHyperlink(int highlightStartOffset, int highlightEndOffset, @Nullable TextAttributes highlightAttributes, @NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes, int layer) {
        RangeHighlighterEx highlighter = this.myEditor.getMarkupModel().addRangeHighlighterAndChangeAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES, highlightStartOffset, highlightEndOffset, layer, HighlighterTargetArea.EXACT_RANGE, false, (Consumer<? super RangeHighlighterEx>)((Consumer)ex -> {
            if (highlightAttributes != null) {
                ex.setTextAttributes(highlightAttributes);
            }
        }));
        EditorHyperlinkSupport.associateHyperlink(highlighter, hyperlinkInfo, followedHyperlinkAttributes);
        return highlighter;
    }

    @Deprecated
    public static void associateHyperlink(@NotNull RangeHighlighter highlighter, @NotNull HyperlinkInfo hyperlinkInfo) {
        EditorHyperlinkSupport.associateHyperlink(highlighter, hyperlinkInfo, null);
    }

    private static void associateHyperlink(@NotNull RangeHighlighter highlighter, @NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes) {
        highlighter.putUserData(HYPERLINK, (Object)new HyperlinkInfoTextAttributes(hyperlinkInfo, followedHyperlinkAttributes));
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByPoint(Point p) {
        LogicalPosition pos = this.myEditor.xyToLogicalPosition(new Point(p.x, p.y));
        if (EditorUtil.inVirtualSpace(this.myEditor, pos)) {
            return null;
        }
        return this.getHyperlinkInfoByLineAndCol(pos.line, pos.column);
    }

    @Nullable
    public HyperlinkInfo getHyperlinkInfoByEvent(@NotNull EditorMouseEvent event) {
        return event.isOverText() ? this.getHyperlinkAt(event.getOffset()) : null;
    }

    @Deprecated
    public void highlightHyperlinks(@NotNull Filter customFilter, Filter predefinedMessageFilter, int line1, int endLine) {
        this.highlightHyperlinks((line, entireLength) -> {
            Filter.Result result2 = customFilter.applyFilter(line, entireLength);
            return result2 != null ? result2 : predefinedMessageFilter.applyFilter(line, entireLength);
        }, line1, endLine);
    }

    public void highlightHyperlinks(@NotNull Filter customFilter, int line1, int endLine) {
        this.myFilterRunner.highlightHyperlinks(this.myProject, customFilter, Math.max(0, line1), endLine);
    }

    void highlightHyperlinks(@NotNull Filter.Result result2, int offsetDelta) {
        int length = this.myEditor.getDocument().getTextLength();
        SmartList inlays = new SmartList();
        for (Filter.ResultItem resultItem : result2.getResultItems()) {
            int start2 = resultItem.getHighlightStartOffset() + offsetDelta;
            int end = resultItem.getHighlightEndOffset() + offsetDelta;
            if (start2 < 0 || end < start2 || end > length) continue;
            TextAttributes attributes = resultItem.getHighlightAttributes();
            if (resultItem instanceof InlayProvider) {
                inlays.add((InlayProvider)resultItem);
                continue;
            }
            if (resultItem.getHyperlinkInfo() != null) {
                this.createHyperlink(start2, end, attributes, resultItem.getHyperlinkInfo(), resultItem.getFollowedHyperlinkAttributes(), resultItem.getHighlighterLayer());
                continue;
            }
            if (attributes == null) continue;
            this.addHighlighter(start2, end, attributes, resultItem.getHighlighterLayer());
        }
        if (!inlays.isEmpty()) {
            this.myEditor.getInlayModel().execute(inlays.size() > 100, () -> this.lambda$highlightHyperlinks$4((List)inlays, offsetDelta));
        }
    }

    public void addHighlighter(int highlightStartOffset, int highlightEndOffset, TextAttributes highlightAttributes) {
        this.addHighlighter(highlightStartOffset, highlightEndOffset, highlightAttributes, 5800);
    }

    public void addHighlighter(int highlightStartOffset, int highlightEndOffset, TextAttributes highlightAttributes, int highlighterLayer) {
        this.myEditor.getMarkupModel().addRangeHighlighter(highlightStartOffset, highlightEndOffset, highlighterLayer, highlightAttributes, HighlighterTargetArea.EXACT_RANGE);
    }

    @NotNull
    private static TextAttributes getFollowedHyperlinkAttributes(@NotNull RangeHighlighter range2) {
        TextAttributes result2;
        HyperlinkInfoTextAttributes attrs = (HyperlinkInfoTextAttributes)((Object)HYPERLINK.get((UserDataHolder)range2));
        TextAttributes textAttributes = result2 = attrs != null ? attrs.getFollowedHyperlinkAttributes() : null;
        if (result2 == null) {
            result2 = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.FOLLOWED_HYPERLINK_ATTRIBUTES);
        }
        return result2;
    }

    @Nullable
    public static OccurenceNavigator.OccurenceInfo getNextOccurrence(final Editor editor, int delta, final Consumer<? super RangeHighlighter> action2) {
        RangeHighlighter range2;
        int i2;
        final List<RangeHighlighter> ranges = EditorHyperlinkSupport.getHyperlinks(0, editor.getDocument().getTextLength(), editor);
        if (ranges.isEmpty()) {
            return null;
        }
        for (i2 = 0; i2 < ranges.size() && (range2 = ranges.get(i2)).getUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES) == null; ++i2) {
        }
        int newIndex = i2 %= ranges.size();
        while (newIndex < ranges.size() && newIndex >= 0) {
            newIndex = (newIndex + delta + ranges.size()) % ranges.size();
            final RangeHighlighter next = ranges.get(newIndex);
            HyperlinkInfo info = EditorHyperlinkSupport.getHyperlinkInfo(next);
            assert (info != null);
            if (info.includeInOccurenceNavigation()) {
                boolean inCollapsedRegion;
                boolean bl = inCollapsedRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(next.getStartOffset()) != null;
                if (!inCollapsedRegion) {
                    return new OccurenceNavigator.OccurenceInfo((Navigatable)new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            action2.consume((Object)next);
                            EditorHyperlinkSupport.linkFollowed(editor, ranges, next);
                        }
                    }, newIndex == -1 ? -1 : newIndex + 1, ranges.size());
                }
            }
            if (newIndex != i2) continue;
            break;
        }
        return null;
    }

    private static void linkFollowed(Editor editor, Collection<? extends RangeHighlighter> ranges, RangeHighlighter link) {
        MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
        for (RangeHighlighter rangeHighlighter : ranges) {
            TextAttributes oldAttr = (TextAttributes)rangeHighlighter.getUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES);
            if (oldAttr != null) {
                markupModel.setRangeHighlighterAttributes(rangeHighlighter, oldAttr);
                rangeHighlighter.putUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES, null);
            }
            if (rangeHighlighter != link) continue;
            rangeHighlighter.putUserData(OLD_HYPERLINK_TEXT_ATTRIBUTES, (Object)rangeHighlighter.getTextAttributes(editor.getColorsScheme()));
            markupModel.setRangeHighlighterAttributes(rangeHighlighter, EditorHyperlinkSupport.getFollowedHyperlinkAttributes(rangeHighlighter));
        }
        markupModel.addRangeHighlighter(CodeInsightColors.HYPERLINK_ATTRIBUTES, 0, 0, link.getLayer(), HighlighterTargetArea.EXACT_RANGE).dispose();
    }

    @NotNull
    public static String getLineText(@NotNull Document document, int lineNumber, boolean includeEol) {
        return EditorHyperlinkSupport.getLineSequence(document, lineNumber, includeEol).toString();
    }

    @NotNull
    private static CharSequence getLineSequence(@NotNull Document document, int lineNumber, boolean includeEol) {
        int endOffset = document.getLineEndOffset(lineNumber);
        if (includeEol && endOffset < document.getTextLength()) {
            ++endOffset;
        }
        return document.getImmutableCharSequence().subSequence(document.getLineStartOffset(lineNumber), endOffset);
    }

    private /* synthetic */ void lambda$highlightHyperlinks$4(List inlays, int offsetDelta) {
        for (InlayProvider item : inlays) {
            this.myEditor.getInlayModel().addInlineElement(((Filter.ResultItem)item).getHighlightEndOffset() + offsetDelta, item.createInlayRenderer(this.myEditor));
        }
    }

    private static class HyperlinkInfoTextAttributes
    extends TextAttributes {
        private final HyperlinkInfo myHyperlinkInfo;
        private final TextAttributes myFollowedHyperlinkAttributes;

        HyperlinkInfoTextAttributes(@NotNull HyperlinkInfo hyperlinkInfo, @Nullable TextAttributes followedHyperlinkAttributes) {
            this.myHyperlinkInfo = hyperlinkInfo;
            this.myFollowedHyperlinkAttributes = followedHyperlinkAttributes;
        }

        @NotNull
        HyperlinkInfo getHyperlinkInfo() {
            return this.myHyperlinkInfo;
        }

        @Nullable
        TextAttributes getFollowedHyperlinkAttributes() {
            return this.myFollowedHyperlinkAttributes;
        }
    }
}

