/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.PanelContentUI;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardDefaultTypesProvider;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardServiceViewContributor;
import com.intellij.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.execution.dashboard.tree.RunDashboardStatusFilter;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewManagerImpl;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="RunDashboard", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class RunDashboardManagerImpl
implements RunDashboardManager,
PersistentStateComponent<State> {
    private static final ExtensionPointName<RunDashboardCustomizer> CUSTOMIZER_EP_NAME = ExtensionPointName.create((String)"com.intellij.runDashboardCustomizer");
    private static final ExtensionPointName<RunDashboardDefaultTypesProvider> DEFAULT_TYPES_PROVIDER_EP_NAME = ExtensionPointName.create((String)"com.intellij.runDashboardDefaultTypesProvider");
    static final ExtensionPointName<RunDashboardGroupingRule> GROUPING_RULE_EP_NAME = ExtensionPointName.create((String)"com.intellij.runDashboardGroupingRule");
    private final Project myProject;
    private final ContentManager myContentManager;
    private final ContentManagerListener myServiceContentManagerListener;
    private State myState = new State();
    private final Set<String> myTypes = new THashSet();
    private final Set<RunConfiguration> myHiddenConfigurations = new THashSet();
    private volatile List<List<RunDashboardServiceImpl>> myServices = Collections.emptyList();
    private final ReentrantReadWriteLock myServiceLock = new ReentrantReadWriteLock();
    private final RunDashboardStatusFilter myStatusFilter = new RunDashboardStatusFilter();
    private String myToolWindowId;
    private final Predicate<Content> myReuseCondition;
    private final AtomicBoolean myListenersInitialized = new AtomicBoolean();

    public RunDashboardManagerImpl(@NotNull Project project) {
        this.myProject = project;
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        this.myContentManager = contentFactory.createContentManager((ContentUI)new PanelContentUI(), false, project);
        this.myServiceContentManagerListener = new ServiceContentManagerListener();
        this.myReuseCondition = this::canReuseContent;
        this.initExtensionPointListeners();
    }

    private void initExtensionPointListeners() {
        final ExtensionPointListener dashboardUpdater = new ExtensionPointListener(){

            public void extensionAdded(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                RunDashboardManagerImpl.this.updateDashboard(true);
            }

            public void extensionRemoved(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                ((ServiceEventListener)RunDashboardManagerImpl.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createSyncResetEvent(RunDashboardServiceViewContributor.class));
            }
        };
        CUSTOMIZER_EP_NAME.addExtensionPointListener(dashboardUpdater, (Disposable)this.myProject);
        GROUPING_RULE_EP_NAME.addExtensionPointListener(dashboardUpdater, (Disposable)this.myProject);
        ExtensionPointListener typeUpdater = new ExtensionPointListener(){

            public void extensionAdded(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                RunDashboardManagerImpl.this.setTypes(new HashSet<String>(RunDashboardManagerImpl.this.getTypes()));
            }

            public void extensionRemoved(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                RunDashboardManagerImpl.this.setTypes(new HashSet<String>(RunDashboardManagerImpl.this.getTypes()));
                dashboardUpdater.extensionRemoved(extension, pluginDescriptor);
            }
        };
        DEFAULT_TYPES_PROVIDER_EP_NAME.addExtensionPointListener(typeUpdater, (Disposable)this.myProject);
        ConfigurationType.CONFIGURATION_TYPE_EP.addExtensionPointListener(typeUpdater, (Disposable)this.myProject);
    }

    private void initServiceContentListeners() {
        if (!this.myListenersInitialized.compareAndSet(false, true)) {
            return;
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){
            private volatile boolean myUpdateStarted;

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.syncConfigurations();
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                RunDashboardManagerImpl.this.myHiddenConfigurations.remove(settings.getConfiguration());
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.syncConfigurations();
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            @Override
            public void beginUpdate() {
                this.myUpdateStarted = true;
            }

            @Override
            public void endUpdate() {
                this.myUpdateStarted = false;
                RunDashboardManagerImpl.this.syncConfigurations();
                RunDashboardManagerImpl.this.updateDashboard(true);
            }
        });
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }
        });
        connection.subscribe(RunDashboardManager.DASHBOARD_TOPIC, (Object)new RunDashboardListener(){

            public void configurationChanged(@NotNull RunConfiguration configuration, boolean withStructure) {
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(configuration, withStructure);
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                RunDashboardManagerImpl.this.updateDashboard(false);
            }
        });
        this.myContentManager.addContentManagerListener(this.myServiceContentManagerListener);
    }

    public ContentManager getDashboardContentManager() {
        return this.myContentManager;
    }

    @NotNull
    public String getToolWindowId() {
        if (this.myToolWindowId == null) {
            String toolWindowId = ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)this.myProject)).getToolWindowId(RunDashboardServiceViewContributor.class);
            this.myToolWindowId = toolWindowId != null ? toolWindowId : "Services";
        }
        return this.myToolWindowId;
    }

    @NotNull
    public Icon getToolWindowIcon() {
        return AllIcons.Toolwindows.ToolWindowServices;
    }

    public List<RunDashboardManager.RunDashboardService> getRunConfigurations() {
        this.myServiceLock.readLock().lock();
        try {
            List<RunDashboardManager.RunDashboardService> list2 = this.myServices.stream().flatMap(Collection::stream).collect(Collectors.toList());
            return list2;
        }
        finally {
            this.myServiceLock.readLock().unlock();
        }
    }

    private List<RunContentDescriptor> filterByContent(List<RunContentDescriptor> descriptors) {
        return ContainerUtil.filter(descriptors, descriptor2 -> {
            Content content2 = descriptor2.getAttachedContent();
            return content2 != null && content2.getManager() == this.myContentManager;
        });
    }

    public boolean isShowInDashboard(@NotNull RunConfiguration runConfiguration) {
        return this.myTypes.contains(runConfiguration.getType().getId()) && !this.myHiddenConfigurations.contains(runConfiguration);
    }

    @NotNull
    public Set<String> getTypes() {
        return Collections.unmodifiableSet(this.myTypes);
    }

    public void setTypes(@NotNull Set<String> types) {
        HashSet removed = new HashSet(Sets.difference(this.myTypes, types));
        HashSet added = new HashSet(Sets.difference(types, this.myTypes));
        this.myTypes.clear();
        this.myTypes.addAll(types);
        if (!this.myTypes.isEmpty()) {
            this.initServiceContentListeners();
        }
        Set<String> enableByDefaultTypes = this.getEnableByDefaultTypes();
        this.myState.configurationTypes.clear();
        this.myState.configurationTypes.addAll(this.myTypes);
        this.myState.configurationTypes.removeAll(enableByDefaultTypes);
        this.myState.excludedTypes.clear();
        this.myState.excludedTypes.addAll(enableByDefaultTypes);
        this.myState.excludedTypes.removeAll(this.myTypes);
        this.syncConfigurations();
        if (!removed.isEmpty()) {
            this.moveRemovedContent((Condition<? super RunnerAndConfigurationSettings>)((Condition)settings -> removed.contains(settings.getType().getId())));
        }
        if (!added.isEmpty()) {
            this.moveAddedContent((Condition<? super RunnerAndConfigurationSettings>)((Condition)settings -> added.contains(settings.getType().getId())));
        }
        this.updateDashboard(true);
    }

    private void moveRemovedContent(Condition<? super RunnerAndConfigurationSettings> condition) {
        RunContentManagerImpl runContentManager = (RunContentManagerImpl)RunContentManager.getInstance((Project)this.myProject);
        for (RunDashboardManager.RunDashboardService service : this.getRunConfigurations()) {
            Executor executor;
            RunContentDescriptor descriptor2;
            Content content2 = service.getContent();
            if (content2 == null || !condition.value((Object)service.getSettings()) || (descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2)) == null || (executor = RunContentManagerImpl.getExecutorByContent(content2)) == null) continue;
            descriptor2.setContentToolWindowId(null);
            RunDashboardManagerImpl.updateContentToolbar(content2, true);
            runContentManager.moveContent(executor, descriptor2);
        }
    }

    private void moveAddedContent(Condition<? super RunnerAndConfigurationSettings> condition) {
        RunContentManagerImpl runContentManager = (RunContentManagerImpl)RunContentManager.getInstance((Project)this.myProject);
        List<RunContentDescriptor> descriptors = ((ExecutionManagerImpl)ExecutionManager.getInstance((Project)this.myProject)).getRunningDescriptors(condition);
        for (RunContentDescriptor descriptor2 : descriptors) {
            Executor executor;
            Content content2 = descriptor2.getAttachedContent();
            if (content2 == null || (executor = RunContentManagerImpl.getExecutorByContent(content2)) == null) continue;
            descriptor2.setContentToolWindowId(this.getToolWindowId());
            runContentManager.moveContent(executor, descriptor2);
        }
    }

    public Set<RunConfiguration> getHiddenConfigurations() {
        return Collections.unmodifiableSet(this.myHiddenConfigurations);
    }

    public void hideConfigurations(Collection<RunConfiguration> configurations) {
        this.myHiddenConfigurations.addAll(configurations);
        this.syncConfigurations();
        if (!configurations.isEmpty()) {
            this.moveRemovedContent((Condition<? super RunnerAndConfigurationSettings>)((Condition)settings -> configurations.contains(settings.getConfiguration())));
        }
        this.updateDashboard(true);
    }

    public void restoreConfigurations(Collection<RunConfiguration> configurations) {
        this.myHiddenConfigurations.removeAll(configurations);
        this.syncConfigurations();
        if (!configurations.isEmpty()) {
            this.moveAddedContent((Condition<? super RunnerAndConfigurationSettings>)((Condition)settings -> configurations.contains(settings.getConfiguration())));
        }
        this.updateDashboard(true);
    }

    @NotNull
    static List<RunDashboardCustomizer> getCustomizers(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor2) {
        SmartList customizers = new SmartList();
        for (RunDashboardCustomizer customizer : (RunDashboardCustomizer[])CUSTOMIZER_EP_NAME.getExtensions()) {
            if (!customizer.isApplicable(settings, descriptor2)) continue;
            customizers.add(customizer);
        }
        return customizers;
    }

    private void updateDashboardIfNeeded(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings != null) {
            this.updateDashboardIfNeeded(settings.getConfiguration(), true);
        }
    }

    private void updateDashboardIfNeeded(@NotNull RunConfiguration configuration, boolean withStructure) {
        if (this.isShowInDashboard(configuration) || !this.filterByContent(ExecutionManagerImpl.getInstance(this.myProject).getDescriptors((Condition<? super RunnerAndConfigurationSettings>)((Condition)s -> configuration.equals(s.getConfiguration())))).isEmpty()) {
            this.updateDashboard(withStructure);
        }
    }

    @NotNull
    public Predicate<Content> getReuseCondition() {
        return this.myReuseCondition;
    }

    private boolean canReuseContent(Content content2) {
        RunContentDescriptor descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2);
        if (descriptor2 == null) {
            return false;
        }
        ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(this.myProject);
        Set<RunnerAndConfigurationSettings> descriptorConfigurations = executionManager.getConfigurations(descriptor2);
        if (descriptorConfigurations.isEmpty()) {
            return true;
        }
        HashSet storedConfigurations = new HashSet(RunManager.getInstance((Project)this.myProject).getAllConfigurationsList());
        return descriptorConfigurations.stream().noneMatch(descriptorConfiguration -> {
            RunConfiguration configuration = descriptorConfiguration.getConfiguration();
            return this.isShowInDashboard(configuration) && storedConfigurations.contains(configuration);
        });
    }

    public void updateDashboard(boolean withStructure) {
        ((ServiceEventListener)this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(RunDashboardServiceViewContributor.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncConfigurations() {
        List settingsList = ContainerUtil.filter((Collection)RunManager.getInstance((Project)this.myProject).getAllSettings(), settings -> this.isShowInDashboard(settings.getConfiguration()));
        ArrayList<List<RunDashboardServiceImpl>> result2 = new ArrayList<List<RunDashboardServiceImpl>>();
        this.myServiceLock.writeLock().lock();
        try {
            for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : settingsList) {
                SmartList syncedServices = this.getServices(runnerAndConfigurationSettings);
                if (syncedServices == null) {
                    syncedServices = new SmartList((Object)new RunDashboardServiceImpl(runnerAndConfigurationSettings));
                }
                result2.add((List<RunDashboardServiceImpl>)syncedServices);
            }
            for (List list2 : this.myServices) {
                RunDashboardManager.RunDashboardService oldService = (RunDashboardManager.RunDashboardService)list2.get(0);
                if (oldService.getContent() == null || settingsList.contains(oldService.getSettings()) || RunDashboardManagerImpl.updateServiceSettings(result2, list2)) continue;
                result2.add(list2);
            }
            this.myServices = result2;
        }
        finally {
            this.myServiceLock.writeLock().unlock();
        }
    }

    private void addServiceContent(@NotNull Content content2) {
        RunnerAndConfigurationSettings settings = this.findSettings(content2);
        if (settings == null) {
            return;
        }
        this.myServiceLock.writeLock().lock();
        try {
            this.doAddServiceContent(settings, content2);
        }
        finally {
            this.myServiceLock.writeLock().unlock();
        }
    }

    private void removeServiceContent(@NotNull Content content2) {
        this.myServiceLock.writeLock().lock();
        try {
            RunDashboardServiceImpl service = this.findService(content2);
            if (service == null) {
                return;
            }
            this.doRemoveServiceContent(service);
        }
        finally {
            this.myServiceLock.writeLock().unlock();
            this.updateDashboard(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServiceContent(@NotNull Content content2) {
        RunnerAndConfigurationSettings settings = this.findSettings(content2);
        if (settings == null) {
            return;
        }
        this.myServiceLock.writeLock().lock();
        try {
            RunDashboardServiceImpl service = this.findService(content2);
            if (service == null || service.getSettings().equals(settings)) {
                return;
            }
            this.doAddServiceContent(settings, content2);
            this.doRemoveServiceContent(service);
        }
        finally {
            this.myServiceLock.writeLock().unlock();
        }
    }

    private void doAddServiceContent(@NotNull RunnerAndConfigurationSettings settings, @NotNull Content content2) {
        RunDashboardServiceImpl newService;
        RunDashboardServiceImpl service;
        SmartList settingsServices = this.getServices(settings);
        if (settingsServices == null) {
            settingsServices = new SmartList((Object)new RunDashboardServiceImpl(settings));
            this.myServices.add((List<RunDashboardServiceImpl>)settingsServices);
        }
        if ((service = settingsServices.get(0)).getContent() == null) {
            newService = service;
        } else {
            newService = new RunDashboardServiceImpl(settings);
            settingsServices.add(newService);
        }
        newService.setContent(content2);
    }

    private void doRemoveServiceContent(@NotNull RunDashboardServiceImpl service) {
        service.setContent(null);
        RunnerAndConfigurationSettings contentSettings = service.getSettings();
        List<RunDashboardServiceImpl> services = this.getServices(contentSettings);
        if (services == null) {
            return;
        }
        if (services.size() > 1) {
            services.remove(service);
        } else if (!this.isShowInDashboard(contentSettings.getConfiguration()) || !RunManager.getInstance((Project)this.myProject).getAllSettings().contains(contentSettings)) {
            this.myServices.remove(services);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RunDashboardServiceImpl findService(@NotNull Content content2) {
        this.myServiceLock.readLock().lock();
        try {
            for (List<RunDashboardServiceImpl> services : this.myServices) {
                for (RunDashboardServiceImpl service : services) {
                    if (!content2.equals(service.getContent())) continue;
                    RunDashboardServiceImpl runDashboardServiceImpl = service;
                    return runDashboardServiceImpl;
                }
            }
        }
        finally {
            this.myServiceLock.readLock().unlock();
            this.updateDashboard(true);
        }
        return null;
    }

    @Nullable
    private RunnerAndConfigurationSettings findSettings(@NotNull Content content2) {
        RunContentDescriptor descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2);
        if (descriptor2 == null) {
            return null;
        }
        Set<RunnerAndConfigurationSettings> settingsSet = ExecutionManagerImpl.getInstance(this.myProject).getConfigurations(descriptor2);
        RunnerAndConfigurationSettings result2 = (RunnerAndConfigurationSettings)ContainerUtil.getFirstItem(settingsSet);
        if (result2 != null) {
            return result2;
        }
        ProcessHandler processHandler2 = descriptor2.getProcessHandler();
        return processHandler2 == null ? null : (RunnerAndConfigurationSettings)processHandler2.getUserData(RunContentManagerImpl.TEMPORARY_CONFIGURATION_KEY);
    }

    @Nullable
    private List<RunDashboardServiceImpl> getServices(@NotNull RunnerAndConfigurationSettings settings) {
        for (List<RunDashboardServiceImpl> services : this.myServices) {
            if (!services.get(0).getSettings().equals(settings)) continue;
            return services;
        }
        return null;
    }

    private static boolean updateServiceSettings(List<List<RunDashboardServiceImpl>> newServiceList, List<RunDashboardServiceImpl> oldServices) {
        RunDashboardServiceImpl oldService = oldServices.get(0);
        RunnerAndConfigurationSettings oldSettings = oldService.getSettings();
        for (List<RunDashboardServiceImpl> newServices : newServiceList) {
            RunnerAndConfigurationSettings newSettings = newServices.get(0).getSettings();
            if (!newSettings.getType().equals(oldSettings.getType()) || !newSettings.getName().equals(oldSettings.getName())) continue;
            newServices.get(0).setContent(oldService.getContent());
            for (int i2 = 1; i2 < oldServices.size(); ++i2) {
                RunDashboardServiceImpl newService = new RunDashboardServiceImpl(newSettings);
                newService.setContent(oldServices.get(i2).getContent());
                newServices.add(newService);
            }
            return true;
        }
        return false;
    }

    private static void updateContentToolbar(Content content2, boolean visible) {
        RunContentDescriptor descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2);
        RunnerLayoutUiImpl ui = RunDashboardManagerImpl.getRunnerLayoutUi(descriptor2);
        if (ui != null) {
            ui.setLeftToolbarVisible(visible);
            ui.setContentToolbarBefore(visible);
        } else {
            ActionToolbar toolbar = RunDashboardManagerImpl.findActionToolbar(descriptor2);
            if (toolbar != null) {
                toolbar.getComponent().setVisible(visible);
            }
        }
    }

    void setSelectedContent(@NotNull Content content2) {
        ContentManager contentManager2 = content2.getManager();
        if (contentManager2 == null || content2 == contentManager2.getSelectedContent()) {
            return;
        }
        if (contentManager2 != this.myContentManager) {
            contentManager2.setSelectedContent(content2);
            return;
        }
        this.myContentManager.removeContentManagerListener(this.myServiceContentManagerListener);
        this.myContentManager.setSelectedContent(content2);
        RunDashboardManagerImpl.updateContentToolbar(content2, false);
        this.myContentManager.addContentManagerListener(this.myServiceContentManagerListener);
    }

    void removeFromSelection(@NotNull Content content2) {
        ContentManager contentManager2 = content2.getManager();
        if (contentManager2 == null || content2 != contentManager2.getSelectedContent()) {
            return;
        }
        if (contentManager2 != this.myContentManager) {
            contentManager2.removeFromSelection(content2);
            return;
        }
        this.myContentManager.removeContentManagerListener(this.myServiceContentManagerListener);
        this.myContentManager.removeFromSelection(content2);
        this.myContentManager.addContentManagerListener(this.myServiceContentManagerListener);
    }

    @NotNull
    public RunDashboardStatusFilter getStatusFilter() {
        return this.myStatusFilter;
    }

    @Nullable
    static RunnerLayoutUiImpl getRunnerLayoutUi(@Nullable RunContentDescriptor descriptor2) {
        if (descriptor2 == null) {
            return null;
        }
        RunnerLayoutUi layoutUi = descriptor2.getRunnerLayoutUi();
        return layoutUi instanceof RunnerLayoutUiImpl ? (RunnerLayoutUiImpl)layoutUi : null;
    }

    @Nullable
    static ActionToolbar findActionToolbar(@Nullable RunContentDescriptor descriptor2) {
        if (descriptor2 == null) {
            return null;
        }
        for (Component component2 : descriptor2.getComponent().getComponents()) {
            if (!(component2 instanceof ActionToolbar)) continue;
            return (ActionToolbar)component2;
        }
        return null;
    }

    Set<String> getEnableByDefaultTypes() {
        THashSet result2 = new THashSet();
        for (RunDashboardDefaultTypesProvider provider : DEFAULT_TYPES_PROVIDER_EP_NAME.getExtensionList()) {
            result2.addAll(provider.getDefaultTypeIds(this.myProject));
        }
        return result2;
    }

    @Nullable
    public State getState() {
        this.myState.hiddenConfigurations.clear();
        for (RunConfiguration configuration : this.myHiddenConfigurations) {
            ConfigurationType type = configuration.getType();
            if (!this.myTypes.contains(type.getId())) continue;
            THashSet configurations = this.myState.hiddenConfigurations.get(type.getId());
            if (configurations == null) {
                configurations = new THashSet();
                this.myState.hiddenConfigurations.put(type.getId(), (Set<String>)configurations);
            }
            configurations.add(configuration.getName());
        }
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
        this.myTypes.clear();
        this.myTypes.addAll(this.myState.configurationTypes);
        Set<String> enableByDefaultTypes = this.getEnableByDefaultTypes();
        enableByDefaultTypes.removeAll(this.myState.excludedTypes);
        this.myTypes.addAll(enableByDefaultTypes);
        if (!this.myTypes.isEmpty()) {
            this.loadHiddenConfigurations();
            this.initServiceContentListeners();
            this.syncConfigurations();
        }
    }

    private void loadHiddenConfigurations() {
        for (Map.Entry<String, Set<String>> entry : this.myState.hiddenConfigurations.entrySet()) {
            ConfigurationType type = ConfigurationTypeUtil.findConfigurationType((String)entry.getKey());
            if (type == null) continue;
            List configurations = RunManager.getInstance((Project)this.myProject).getConfigurationsList(type);
            for (String name : entry.getValue()) {
                for (RunConfiguration configuration : configurations) {
                    if (!configuration.getName().equals(name)) continue;
                    this.myHiddenConfigurations.add(configuration);
                }
            }
        }
    }

    public void noStateLoaded() {
        this.myTypes.clear();
        this.myTypes.addAll(this.getEnableByDefaultTypes());
        if (!this.myTypes.isEmpty()) {
            this.initServiceContentListeners();
            this.syncConfigurations();
        }
    }

    private class ServiceContentManagerListener
    implements ContentManagerListener {
        private ServiceContentManagerListener() {
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            RunnerAndConfigurationSettings settings;
            boolean onAdd = event.getOperation() == ContentManagerEvent.ContentOperation.add;
            Content content2 = event.getContent();
            if (onAdd) {
                RunDashboardManagerImpl.updateContentToolbar(content2, false);
                RunDashboardManagerImpl.this.updateServiceContent(content2);
            }
            RunDashboardManagerImpl.this.updateDashboard(true);
            if (onAdd && (settings = RunDashboardManagerImpl.this.findSettings(content2)) != null) {
                RunDashboardServiceImpl service = new RunDashboardServiceImpl(settings);
                service.setContent(content2);
                RunContentDescriptor descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2);
                RunConfigurationNode node = new RunConfigurationNode(RunDashboardManagerImpl.this.myProject, service, RunDashboardManagerImpl.getCustomizers(settings, descriptor2));
                ServiceViewManager.getInstance((Project)RunDashboardManagerImpl.this.myProject).select((Object)node, RunDashboardServiceViewContributor.class, true, false);
            }
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            RunDashboardManagerImpl.this.addServiceContent(event.getContent());
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            RunDashboardManagerImpl.this.removeServiceContent(event.getContent());
        }
    }

    private static class RunDashboardServiceImpl
    implements RunDashboardManager.RunDashboardService {
        private final RunnerAndConfigurationSettings mySettings;
        private volatile Content myContent;

        RunDashboardServiceImpl(@NotNull RunnerAndConfigurationSettings settings) {
            this.mySettings = settings;
        }

        @NotNull
        public RunnerAndConfigurationSettings getSettings() {
            return this.mySettings;
        }

        @Nullable
        public RunContentDescriptor getDescriptor() {
            Content content2 = this.myContent;
            return content2 == null ? null : RunContentManagerImpl.getRunContentDescriptorByContent(content2);
        }

        @Nullable
        public Content getContent() {
            return this.myContent;
        }

        void setContent(@Nullable Content content2) {
            this.myContent = content2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RunDashboardServiceImpl service = (RunDashboardServiceImpl)o;
            return this.mySettings.equals(service.mySettings) && Comparing.equal((Object)this.myContent, (Object)service.myContent);
        }

        public int hashCode() {
            int result2 = this.mySettings.hashCode();
            result2 = 31 * result2 + (this.myContent != null ? this.myContent.hashCode() : 0);
            return result2;
        }
    }

    static class State {
        public final Set<String> configurationTypes = new THashSet();
        public final Set<String> excludedTypes = new THashSet();
        public final Map<String, Set<String>> hiddenConfigurations = new THashMap();

        State() {
        }
    }
}

