/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.ide.scratch.RootType;
import com.intellij.openapi.util.text.StringHash;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConsoleRootType
extends RootType {
    public static final String SEPARATOR = "-. . -..- - / . -. - .-. -.--";
    private static final String PATH_PREFIX = "consoles/";

    protected ConsoleRootType(@NotNull String consoleTypeId, @Nullable String displayName) {
        super(PATH_PREFIX + consoleTypeId, displayName);
    }

    public final String getConsoleTypeId() {
        return this.getId().substring(PATH_PREFIX.length());
    }

    @NotNull
    public String getEntrySeparator() {
        return "\n-. . -..- - / . -. - .-. -.--\n";
    }

    @NotNull
    public String getContentPathName(@NotNull String id2) {
        return Long.toHexString(StringHash.calc((String)id2));
    }

    @NotNull
    public String getHistoryPathName(@NotNull String id2) {
        return Long.toHexString(StringHash.calc((String)id2));
    }

    @NotNull
    public String getDefaultFileExtension() {
        return "txt";
    }
}

