/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import org.jetbrains.annotations.NotNull;

public class EditRunConfigurationsAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null && project.isDisposed()) {
            return;
        }
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        new EditConfigurationsDialog(project).show();
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation2 = e.getPresentation();
        Project project = e.getProject();
        presentation2.setEnabled(project == null || !DumbService.isDumb((Project)project));
        if ("RunConfigurationsCombobox".equals(e.getPlace())) {
            presentation2.setText(ExecutionBundle.messagePointer((String)"edit.configuration.action", (Object[])new Object[0]));
            presentation2.setDescription(presentation2.getText());
        }
    }
}

