/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class RunManagerConfig {
    public static final int MIN_RECENT_LIMIT = 0;
    public static final int DEFAULT_RECENT_LIMIT = 5;
    private final PropertiesComponent myPropertiesComponent;
    @NonNls
    private static final String RECENTS_LIMIT = "recentsLimit";
    @NonNls
    private static final String RESTART_REQUIRES_CONFIRMATION = "restartRequiresConfirmation";
    @NonNls
    private static final String DELETION_FROM_POPUP_REQUIRES_CONFIRMATION = "deletionFromPopupRequiresConfirmation";
    @NonNls
    private static final String STOP_INCOMPATIBLE_REQUIRES_CONFIRMATION = "stopIncompatibleRequiresConfirmation";

    public RunManagerConfig(@NotNull PropertiesComponent propertiesComponent) {
        this.myPropertiesComponent = propertiesComponent;
    }

    public int getRecentsLimit() {
        return Math.max(0, StringUtil.parseInt((String)this.myPropertiesComponent.getValue(RECENTS_LIMIT), (int)5));
    }

    public void setRecentsLimit(int recentsLimit) {
        this.myPropertiesComponent.setValue(RECENTS_LIMIT, recentsLimit, 5);
    }

    public boolean isRestartRequiresConfirmation() {
        return this.myPropertiesComponent.getBoolean(RESTART_REQUIRES_CONFIRMATION, true);
    }

    public void setRestartRequiresConfirmation(boolean restartRequiresConfirmation) {
        this.myPropertiesComponent.setValue(RESTART_REQUIRES_CONFIRMATION, restartRequiresConfirmation, true);
    }

    public boolean isDeletionFromPopupRequiresConfirmation() {
        return this.myPropertiesComponent.getBoolean(DELETION_FROM_POPUP_REQUIRES_CONFIRMATION, true);
    }

    public void setDeletionFromPopupRequiresConfirmation(boolean deletionFromPopupRequiresConfirmation) {
        this.myPropertiesComponent.setValue(DELETION_FROM_POPUP_REQUIRES_CONFIRMATION, deletionFromPopupRequiresConfirmation, true);
    }

    public boolean isStopIncompatibleRequiresConfirmation() {
        return this.myPropertiesComponent.getBoolean(STOP_INCOMPATIBLE_REQUIRES_CONFIRMATION, true);
    }

    public void setStopIncompatibleRequiresConfirmation(boolean stopIncompatibleRequiresConfirmation) {
        this.myPropertiesComponent.setValue(STOP_INCOMPATIBLE_REQUIRES_CONFIRMATION, stopIncompatibleRequiresConfirmation, true);
    }
}

