/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleThreesideDiffChange;
import com.intellij.diff.tools.simple.ThreesideTextDiffViewerEx;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.side.ThreesideDiffViewer;
import com.intellij.diff.tools.util.side.ThreesideTextDiffViewer;
import com.intellij.diff.tools.util.text.FineMergeLineFragment;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.SimpleThreesideTextDiffProvider;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleThreesideDiffViewer
extends ThreesideTextDiffViewerEx {
    @NotNull
    private final SimpleThreesideTextDiffProvider myTextDiffProvider;
    @NotNull
    private final List<SimpleThreesideDiffChange> myDiffChanges = new ArrayList<SimpleThreesideDiffChange>();
    @NotNull
    private final List<SimpleThreesideDiffChange> myInvalidDiffChanges = new ArrayList<SimpleThreesideDiffChange>();

    public SimpleThreesideDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        super(context, (ContentDiffRequest)request2);
        this.myTextDiffProvider = new SimpleThreesideTextDiffProvider(this.getTextSettings(), this::rediff, (Disposable)this);
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        DefaultActionGroup diffGroup = DefaultActionGroup.createPopupGroup(() -> DiffBundle.message((String)"group.compare.contents.text", (Object[])new Object[0]));
        diffGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
        diffGroup.add((AnAction)Separator.create((String)DiffBundle.message((String)"group.compare.contents.text", (Object[])new Object[0])));
        diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.MIDDLE_LEFT, false));
        diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.MIDDLE_RIGHT, false));
        diffGroup.add((AnAction)new ThreesideTextDiffViewer.TextShowPartialDiffAction(this, ThreesideDiffViewer.PartialDiffMode.LEFT_RIGHT, false));
        group.add((AnAction)diffGroup);
        group.add((AnAction)Separator.getInstance());
        group.addAll(this.myTextDiffProvider.getToolbarActions());
        group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new MyEditorReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createToolbarActions());
        return group;
    }

    @Override
    @NotNull
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>(this.myTextDiffProvider.getPopupActions());
        group.add((AnAction)new ThreesideTextDiffViewer.MyToggleAutoScrollAction(this));
        group.add((AnAction)new ThreesideTextDiffViewerEx.MyToggleExpandByDefaultAction(this));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createPopupActions());
        return group;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new ReplaceSelectedChangesAction(ThreeSide.LEFT, ThreeSide.BASE));
        group.add((AnAction)new ReplaceSelectedChangesAction(ThreeSide.RIGHT, ThreeSide.BASE));
        group.add((AnAction)new ReplaceSelectedChangesAction(ThreeSide.BASE, ThreeSide.LEFT));
        group.add((AnAction)new ReplaceSelectedChangesAction(ThreeSide.BASE, ThreeSide.RIGHT));
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createEditorPopupActions());
        return group;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
        this.myInitialScrollHelper.onSlowRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        try {
            indicator.checkCanceled();
            List sequences = ContainerUtil.map(this.getContents(), content2 -> content2.getDocument().getImmutableCharSequence());
            List<FineMergeLineFragment> lineFragments = this.myTextDiffProvider.compare((CharSequence)sequences.get(0), (CharSequence)sequences.get(1), (CharSequence)sequences.get(2), indicator);
            FoldingModelSupport.Data foldingState = this.myFoldingModel.createState(lineFragments, this.getFoldingModelSettings());
            return this.apply(lineFragments, foldingState);
        }
        catch (DiffTooBigException e) {
            return this.applyNotification(DiffNotifications.createDiffTooBig());
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return this.applyNotification(DiffNotifications.createError());
        }
    }

    @NotNull
    private static MergeConflictType invertConflictType(@NotNull MergeConflictType oldConflictType) {
        TextDiffType oldDiffType = oldConflictType.getDiffType();
        if (oldDiffType != TextDiffType.INSERTED && oldDiffType != TextDiffType.DELETED) {
            return oldConflictType;
        }
        return new MergeConflictType(oldDiffType == TextDiffType.DELETED ? TextDiffType.INSERTED : TextDiffType.DELETED, oldConflictType.isChange(Side.LEFT), oldConflictType.isChange(Side.RIGHT), oldConflictType.canBeResolved());
    }

    @NotNull
    private MergeConflictType convertConflictType(@NotNull FineMergeLineFragment fragment) {
        MergeConflictType conflictType = fragment.getConflictType();
        if (DiffUtil.getUserData((UserDataHolder)this.myRequest, (UserDataHolder)this.myContext, DiffUserDataKeys.THREESIDE_DIFF_WITH_RESULT) == Boolean.TRUE) {
            conflictType = SimpleThreesideDiffViewer.invertConflictType(conflictType);
        }
        return conflictType;
    }

    @NotNull
    private Runnable apply(@NotNull List<FineMergeLineFragment> fragments, @Nullable FoldingModelSupport.Data foldingState) {
        return () -> {
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.clearDiffPresentation();
            this.resetChangeCounters();
            for (FineMergeLineFragment fragment : fragments) {
                MergeConflictType conflictType = this.convertConflictType(fragment);
                MergeInnerDifferences innerFragments = fragment.getInnerFragments();
                SimpleThreesideDiffChange change = new SimpleThreesideDiffChange(fragment, conflictType, innerFragments, this);
                this.myDiffChanges.add(change);
                this.onChangeAdded(change);
            }
            this.myFoldingModel.install(foldingState, (UserDataHolder)this.myRequest, this.getFoldingModelSettings());
            this.myInitialScrollHelper.onRediff();
            this.myContentPanel.repaintDividers();
            this.myStatusPanel.update();
        };
    }

    @Override
    protected void destroyChangedBlocks() {
        super.destroyChangedBlocks();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            change.destroy();
        }
        this.myDiffChanges.clear();
        for (SimpleThreesideDiffChange change : this.myInvalidDiffChanges) {
            change.destroy();
        }
        this.myInvalidDiffChanges.clear();
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        super.onBeforeDocumentChange(e);
        if (this.myDiffChanges.isEmpty()) {
            return;
        }
        List documents = ContainerUtil.map(this.getEditors(), Editor::getDocument);
        ThreeSide side = ThreeSide.fromValue((List)documents, (Object)e.getDocument());
        if (side == null) {
            LOG.warn("Unknown document changed");
            return;
        }
        LineRange lineRange = DiffUtil.getAffectedLineRange(e);
        int shift = DiffUtil.countLinesShift(e);
        ArrayList<SimpleThreesideDiffChange> invalid = new ArrayList<SimpleThreesideDiffChange>();
        for (SimpleThreesideDiffChange change : this.myDiffChanges) {
            if (!change.processChange(lineRange.start, lineRange.end, shift, side)) continue;
            invalid.add(change);
        }
        if (!invalid.isEmpty()) {
            this.myDiffChanges.removeAll(invalid);
            this.myInvalidDiffChanges.addAll(invalid);
            for (SimpleThreesideDiffChange change : invalid) {
                change.markInvalid();
            }
        }
    }

    @NotNull
    public List<SimpleThreesideDiffChange> getChanges() {
        return this.myDiffChanges;
    }

    @Override
    @NotNull
    protected DiffDividerDrawUtil.DividerPaintable getDividerPaintable(@NotNull Side side) {
        return new MyDividerPaintable(side);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request2) {
        return ThreesideTextDiffViewer.canShowRequest(context, request2);
    }

    protected boolean isEditable(@NotNull ThreeSide side) {
        return DiffUtil.isEditable(this.getEditor(side));
    }

    protected boolean isSomeChangeSelected(@NotNull ThreeSide side) {
        if (this.getChanges().isEmpty()) {
            return false;
        }
        EditorEx editor = this.getEditor(side);
        return DiffUtil.isSomeRangeSelected(editor, (Condition<? super BitSet>)((Condition)lines -> ContainerUtil.exists(this.getChanges(), change -> SimpleThreesideDiffViewer.isChangeSelected(change, lines, side))));
    }

    @NotNull
    private List<SimpleThreesideDiffChange> getSelectedChanges(@NotNull ThreeSide side) {
        EditorEx editor = this.getEditor(side);
        BitSet lines = DiffUtil.getSelectedLines(editor);
        return ContainerUtil.filter(this.getChanges(), change -> SimpleThreesideDiffViewer.isChangeSelected(change, lines, side));
    }

    public void replaceChange(@NotNull SimpleThreesideDiffChange change, @NotNull ThreeSide sourceSide, @NotNull ThreeSide outputSide) {
        if (!change.isValid()) {
            return;
        }
        DiffUtil.applyModification(this.getEditor(outputSide).getDocument(), change.getStartLine(outputSide), change.getEndLine(outputSide), this.getEditor(sourceSide).getDocument(), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        this.myDiffChanges.remove(change);
        change.markInvalid();
        change.destroy();
    }

    static String getReplaceActionId(@NotNull ThreeSide master, @NotNull ThreeSide modifiedSide) {
        if (master == ThreeSide.LEFT && modifiedSide == ThreeSide.BASE) {
            return "Diff.ApplyLeftSide";
        }
        if (master == ThreeSide.RIGHT && modifiedSide == ThreeSide.BASE) {
            return "Diff.ApplyRightSide";
        }
        return null;
    }

    private class MyDividerPaintable
    implements DiffDividerDrawUtil.DividerPaintable {
        @NotNull
        private final Side mySide;

        MyDividerPaintable(Side side) {
            this.mySide = side;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler2) {
            ThreeSide left = (ThreeSide)this.mySide.select((Object)ThreeSide.LEFT, (Object)ThreeSide.BASE);
            ThreeSide right = (ThreeSide)this.mySide.select((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
            for (SimpleThreesideDiffChange diffChange : SimpleThreesideDiffViewer.this.myDiffChanges) {
                if (!diffChange.isChange(this.mySide) || handler2.process(diffChange.getStartLine(left), diffChange.getEndLine(left), diffChange.getStartLine(right), diffChange.getEndLine(right), diffChange.getDiffType().getColor(SimpleThreesideDiffViewer.this.getEditor(ThreeSide.BASE)))) continue;
                return;
            }
        }
    }

    protected abstract class SelectedChangesActionBase
    extends DumbAwareAction {
        protected SelectedChangesActionBase() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (DiffUtil.isFromShortcut(e)) {
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            ThreeSide side = ThreeSide.fromValue(SimpleThreesideDiffViewer.this.getEditors(), (Object)editor);
            if (side == null || !this.isVisible(side)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setText(this.getText(side));
            e.getPresentation().setIcon(this.getIcon(side));
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(SimpleThreesideDiffViewer.this.isSomeChangeSelected(side));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            ThreeSide side = ThreeSide.fromValue(SimpleThreesideDiffViewer.this.getEditors(), (Object)editor);
            if (side == null) {
                return;
            }
            List selectedChanges = SimpleThreesideDiffViewer.this.getSelectedChanges(side);
            if (selectedChanges.isEmpty()) {
                return;
            }
            this.doPerform(e, side, ContainerUtil.reverse((List)selectedChanges));
        }

        protected abstract boolean isVisible(@NotNull ThreeSide var1);

        @Nls
        @NotNull
        protected abstract String getText(@NotNull ThreeSide var1);

        @Nullable
        protected abstract Icon getIcon(@NotNull ThreeSide var1);

        protected abstract void doPerform(@NotNull AnActionEvent var1, @NotNull ThreeSide var2, @NotNull List<SimpleThreesideDiffChange> var3);
    }

    private class ReplaceSelectedChangesAction
    extends SelectedChangesActionBase {
        @NotNull
        protected final ThreeSide mySourceSide;
        @NotNull
        protected final ThreeSide myModifiedSide;

        ReplaceSelectedChangesAction(@NotNull ThreeSide sourceSide, ThreeSide modifiedSide) {
            this.mySourceSide = sourceSide;
            this.myModifiedSide = modifiedSide;
            String keymapActionId = SimpleThreesideDiffViewer.getReplaceActionId(sourceSide, modifiedSide);
            if (keymapActionId != null) {
                this.copyShortcutFrom(ActionManager.getInstance().getAction(keymapActionId));
            }
        }

        @Override
        protected boolean isVisible(@NotNull ThreeSide side) {
            if (!SimpleThreesideDiffViewer.this.isEditable(this.myModifiedSide)) {
                return false;
            }
            return !this.isBothEditable() || side == this.mySourceSide;
        }

        protected boolean isBothEditable() {
            return SimpleThreesideDiffViewer.this.isEditable(this.mySourceSide) && SimpleThreesideDiffViewer.this.isEditable(this.myModifiedSide);
        }

        @Override
        @NotNull
        protected String getText(@NotNull ThreeSide side) {
            return DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]);
        }

        @Override
        @Nullable
        protected Icon getIcon(@NotNull ThreeSide side) {
            Side arrowDirection = Side.fromLeft((this.mySourceSide == ThreeSide.LEFT || this.myModifiedSide == ThreeSide.RIGHT ? 1 : 0) != 0);
            return DiffUtil.getArrowIcon(arrowDirection);
        }

        @Override
        protected void doPerform(@NotNull AnActionEvent e, @NotNull ThreeSide side, @NotNull List<SimpleThreesideDiffChange> changes) {
            if (!SimpleThreesideDiffViewer.this.isEditable(this.myModifiedSide)) {
                return;
            }
            String title = DiffBundle.message((String)"message.use.selected.changes.command", (Object[])new Object[]{e.getPresentation().getText()});
            DiffUtil.executeWriteCommand(SimpleThreesideDiffViewer.this.getEditor(this.myModifiedSide).getDocument(), e.getProject(), title, () -> {
                for (SimpleThreesideDiffChange change : changes) {
                    SimpleThreesideDiffViewer.this.replaceChange(change, this.mySourceSide, this.myModifiedSide);
                }
            });
        }
    }

    protected class MyEditorReadOnlyLockAction
    extends TextDiffViewerUtil.EditorReadOnlyLockAction {
        public MyEditorReadOnlyLockAction() {
            super(SimpleThreesideDiffViewer.this.getContext(), SimpleThreesideDiffViewer.this.getEditableEditors());
        }
    }
}

