/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import org.jetbrains.annotations.NotNull;

public class SimpleDiffChange {
    private final int myIndex;
    @NotNull
    private final LineFragment myFragment;
    private final boolean myIsExcluded;
    private final boolean myIsSkipped;
    private boolean myIsValid = true;
    private boolean myIsDestroyed;
    private final int[] myLineStartShifts = new int[2];
    private final int[] myLineEndShifts = new int[2];

    public SimpleDiffChange(int index, @NotNull LineFragment fragment) {
        this(index, fragment, false, false);
    }

    public SimpleDiffChange(int index, @NotNull LineFragment fragment, boolean isExcluded, boolean isSkipped) {
        this.myIndex = index;
        this.myFragment = fragment;
        this.myIsExcluded = isExcluded;
        this.myIsSkipped = isSkipped;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public int getStartLine(@NotNull Side side) {
        return side.getStartLine(this.myFragment) + side.select(this.myLineStartShifts);
    }

    public int getEndLine(@NotNull Side side) {
        return side.getEndLine(this.myFragment) + side.select(this.myLineEndShifts);
    }

    @NotNull
    public TextDiffType getDiffType() {
        return DiffUtil.getLineDiffType(this.myFragment);
    }

    public boolean isExcluded() {
        return this.myIsExcluded;
    }

    public boolean isSkipped() {
        return this.myIsSkipped;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public boolean isDestroyed() {
        return this.myIsDestroyed;
    }

    @NotNull
    public LineFragment getFragment() {
        return this.myFragment;
    }

    public boolean processDocumentChange(int oldLine1, int oldLine2, int shift, @NotNull Side side) {
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        int sideIndex = side.getIndex();
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        int n = sideIndex;
        this.myLineStartShifts[n] = this.myLineStartShifts[n] + (newRange.startLine - line1);
        int n2 = sideIndex;
        this.myLineEndShifts[n2] = this.myLineEndShifts[n2] + (newRange.endLine - line2);
        if (newRange.damaged) {
            this.myIsValid = false;
        }
        return newRange.damaged;
    }

    public void markDestroyed() {
        this.myIsDestroyed = true;
    }
}

