/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.CommonBundle;
import com.intellij.diff.DiffContext;
import com.intellij.diff.tools.util.base.DiffPanelBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedDiffPanel
extends DiffPanelBase {
    @NonNls
    private static final String GOOD_CONTENT = "GoodContent";
    @NonNls
    private static final String LOADING_CONTENT = "LoadingContent";
    @NonNls
    private static final String TOO_BIG_CONTENT = "TooBigContent";
    @NonNls
    private static final String OPERATION_CANCELED_CONTENT = "OperationCanceledContent";
    @NonNls
    private static final String ERROR_CONTENT = "ErrorContent";
    @NotNull
    private final AsyncProcessIcon.Big myBusyIcon = new AsyncProcessIcon.Big("UnifiedDiff");

    public UnifiedDiffPanel(@Nullable Project project, @NotNull JComponent content2, @NotNull DataProvider provider, @NotNull DiffContext context) {
        super(project, provider, context);
        BorderLayoutPanel centerPanel = JBUI.Panels.simplePanel((Component)content2).addToTop((Component)this.myNotificationsPanel);
        this.myContentPanel.add((Component)centerPanel, GOOD_CONTENT);
        this.myContentPanel.add((Component)this.myBusyIcon, LOADING_CONTENT);
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel(DiffBundle.message((String)"error.can.not.calculate.diff.file.too.big", (Object[])new Object[0])), TOO_BIG_CONTENT);
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel(DiffBundle.message((String)"error.can.not.calculate.diff.operation.canceled", (Object[])new Object[0])), OPERATION_CANCELED_CONTENT);
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel(CommonBundle.message((String)"title.error", (Object[])new Object[0])), ERROR_CONTENT);
        this.setCurrentCard(LOADING_CONTENT, false);
    }

    public void setLoadingContent() {
        this.setCurrentCard(LOADING_CONTENT);
    }

    public void setGoodContent() {
        this.setCurrentCard(GOOD_CONTENT);
    }

    public void setTooBigContent() {
        this.setCurrentCard(TOO_BIG_CONTENT);
    }

    public void setOperationCanceledContent() {
        this.setCurrentCard(OPERATION_CANCELED_CONTENT);
    }

    public void setErrorContent() {
        this.setCurrentCard(ERROR_CONTENT);
    }

    @Override
    protected void setCurrentCard(@NotNull String card) {
        if (card == LOADING_CONTENT) {
            this.myBusyIcon.resume();
        } else {
            this.myBusyIcon.suspend();
        }
        super.setCurrentCard(card);
    }

    public boolean isGoodContent() {
        return this.myCurrentCard == GOOD_CONTENT;
    }
}

