/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.UnifiedDiffChange;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterOperation;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class UnifiedDiffChangeUi {
    @NotNull
    protected final UnifiedDiffViewer myViewer;
    @NotNull
    protected final EditorEx myEditor;
    @NotNull
    protected final UnifiedDiffChange myChange;
    @NotNull
    protected final List<RangeHighlighter> myHighlighters = new ArrayList<RangeHighlighter>();
    @NotNull
    protected final List<DiffGutterOperation> myOperations = new ArrayList<DiffGutterOperation>();

    public UnifiedDiffChangeUi(@NotNull UnifiedDiffViewer viewer, @NotNull UnifiedDiffChange change) {
        this.myViewer = viewer;
        this.myEditor = viewer.getEditor();
        this.myChange = change;
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (DiffGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    public void installHighlighter() {
        assert (this.myHighlighters.isEmpty() && this.myOperations.isEmpty());
        this.doInstallHighlighters();
        this.doInstallActionHighlighters();
    }

    protected void doInstallActionHighlighters() {
        if (this.myChange.isSkipped()) {
            return;
        }
        boolean leftEditable = this.myViewer.isEditable(Side.LEFT, false);
        boolean rightEditable = this.myViewer.isEditable(Side.RIGHT, false);
        if (leftEditable && rightEditable) {
            this.myOperations.add(this.createAcceptOperation(Side.LEFT));
            this.myOperations.add(this.createAcceptOperation(Side.RIGHT));
        } else if (rightEditable) {
            this.myOperations.add(this.createAcceptOperation(Side.LEFT));
        }
    }

    private void doInstallHighlighters() {
        this.myHighlighters.addAll(DiffDrawUtil.createUnifiedChunkHighlighters(this.myEditor, this.myChange.getDeletedRange(), this.myChange.getInsertedRange(), this.myChange.isExcluded(), this.myChange.isSkipped(), this.myChange.getLineFragment().getInnerFragments()));
    }

    public void updateGutterActions() {
        for (DiffGutterOperation operation : this.myOperations) {
            operation.update(true);
        }
    }

    @NotNull
    protected DiffGutterOperation createOperation(@NotNull DiffGutterOperation.RendererBuilder builder2) {
        int offset = this.myEditor.getDocument().getLineStartOffset(this.myChange.getLine1());
        return new DiffGutterOperation.Simple(this.myEditor, offset, builder2);
    }

    @NotNull
    private DiffGutterOperation createAcceptOperation(@NotNull Side sourceSide) {
        return this.createOperation(() -> {
            if (this.myViewer.isStateIsOutOfDate()) {
                return null;
            }
            if (!this.myViewer.isEditable(sourceSide.other(), true)) {
                return null;
            }
            if (sourceSide.isLeft()) {
                return this.createIconRenderer(sourceSide, DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]), AllIcons.Diff.Remove);
            }
            return this.createIconRenderer(sourceSide, DiffBundle.message((String)"action.presentation.diff.accept.text", (Object[])new Object[0]), AllIcons.Actions.Checked);
        });
    }

    private GutterIconRenderer createIconRenderer(final @NotNull Side sourceSide, @NotNull String tooltipText, @NotNull Icon icon2) {
        return new DiffGutterRenderer(icon2, tooltipText){

            @Override
            protected void handleMouseClick() {
                if (UnifiedDiffChangeUi.this.myViewer.isStateIsOutOfDate()) {
                    return;
                }
                if (!UnifiedDiffChangeUi.this.myViewer.isEditable(sourceSide.other(), true)) {
                    return;
                }
                Project project = UnifiedDiffChangeUi.this.myViewer.getProject();
                Document document = UnifiedDiffChangeUi.this.myViewer.getDocument(sourceSide.other());
                DiffUtil.executeWriteCommand(document, project, DiffBundle.message((String)"message.replace.change.command", (Object[])new Object[0]), () -> {
                    UnifiedDiffChangeUi.this.myViewer.replaceChange(UnifiedDiffChangeUi.this.myChange, sourceSide);
                    UnifiedDiffChangeUi.this.myViewer.scheduleRediff();
                });
                UnifiedDiffChangeUi.this.myViewer.rediff();
            }
        };
    }
}

