/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffToolUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConvertor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalDiffTool {
    private static final Logger LOG = Logger.getInstance(ExternalDiffTool.class);

    public static boolean isDefault() {
        return ExternalDiffSettings.getInstance().isDiffEnabled() && ExternalDiffSettings.getInstance().isDiffDefault();
    }

    public static boolean isEnabled() {
        return ExternalDiffSettings.getInstance().isDiffEnabled();
    }

    public static void show(@Nullable Project project, @NotNull DiffRequestChain chain, @NotNull DiffDialogHints hints2) {
        try {
            List<DiffRequest> requests = ExternalDiffTool.loadRequestsUnderProgress(project, chain);
            if (requests == null) {
                return;
            }
            ArrayList<DiffRequest> showInBuiltin = new ArrayList<DiffRequest>();
            for (DiffRequest request2 : requests) {
                if (ExternalDiffTool.canShow(request2)) {
                    ExternalDiffTool.showRequest(project, request2);
                    continue;
                }
                showInBuiltin.add(request2);
            }
            if (!showInBuiltin.isEmpty()) {
                DiffManagerEx.getInstance().showDiffBuiltin(project, (DiffRequestChain)new SimpleDiffRequestChain(showInBuiltin), hints2);
            }
        }
        catch (ProcessCanceledException requests) {
        }
        catch (Throwable e) {
            LOG.warn(e);
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)DiffBundle.message((String)"can.t.show.diff.in.external.tool", (Object[])new Object[0]));
        }
    }

    @Nullable
    private static List<DiffRequest> loadRequestsUnderProgress(@Nullable Project project, @NotNull DiffRequestChain chain) throws Throwable {
        if (chain instanceof AsyncDiffRequestChain) {
            return (List)ExternalDiffTool.computeWithModalProgress(project, DiffBundle.message((String)"progress.title.loading.requests", (Object[])new Object[0]), true, indicator -> {
                ListSelection<? extends DiffRequestProducer> listSelection = ((AsyncDiffRequestChain)chain).loadRequestsInBackground();
                return ExternalDiffTool.collectRequests(project, listSelection.getList(), listSelection.getSelectedIndex(), indicator);
            });
        }
        List allProducers = chain.getRequests();
        int index = chain.getIndex();
        return (List)ExternalDiffTool.computeWithModalProgress(project, DiffBundle.message((String)"progress.title.loading.requests", (Object[])new Object[0]), true, indicator -> ExternalDiffTool.collectRequests(project, allProducers, index, indicator));
    }

    @NotNull
    private static List<DiffRequest> collectRequests(@Nullable Project project, @NotNull List<? extends DiffRequestProducer> allProducers, int index, @NotNull ProgressIndicator indicator) {
        if (allProducers.isEmpty()) {
            return Collections.emptyList();
        }
        List<DiffRequestProducer> producers = Collections.singletonList(allProducers.get(index));
        return ExternalDiffTool.collectRequests(project, producers, indicator);
    }

    @NotNull
    private static List<DiffRequest> collectRequests(@Nullable Project project, @NotNull List<? extends DiffRequestProducer> producers, @NotNull ProgressIndicator indicator) {
        ArrayList<DiffRequest> requests = new ArrayList<DiffRequest>();
        UserDataHolderBase context = new UserDataHolderBase();
        ArrayList<String> errorRequests = new ArrayList<String>();
        for (DiffRequestProducer diffRequestProducer : producers) {
            try {
                requests.add(diffRequestProducer.process((UserDataHolder)context, indicator));
            }
            catch (DiffRequestProducerException e) {
                LOG.warn((Throwable)e);
                errorRequests.add(diffRequestProducer.getName());
            }
        }
        if (!errorRequests.isEmpty()) {
            new Notification("Diff", DiffBundle.message((String)"can.t.load.some.changes", (Object[])new Object[0]), StringUtil.join(errorRequests, (String)"<br>"), NotificationType.ERROR).notify(project);
        }
        return requests;
    }

    private static <T> T computeWithModalProgress(@Nullable Project project, @NotNull @Nls String title, boolean canBeCancelled, final @NotNull ThrowableConvertor<? super ProgressIndicator, T, ? extends Exception> computable) throws Exception {
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, Exception>(project, title, canBeCancelled){

            protected T compute(@NotNull ProgressIndicator indicator) throws Exception {
                return computable.convert((Object)indicator);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showRequest(@Nullable Project project, @NotNull DiffRequest request2) throws ExecutionException, IOException {
        request2.onAssigned(true);
        try {
            ExternalDiffSettings settings = ExternalDiffSettings.getInstance();
            List contents = ((ContentDiffRequest)request2).getContents();
            List titles = ((ContentDiffRequest)request2).getContentTitles();
            ExternalDiffToolUtil.execute(project, settings, contents, titles, request2.getTitle());
        }
        finally {
            request2.onAssigned(false);
        }
    }

    public static boolean canShow(@NotNull DiffRequest request2) {
        if (!(request2 instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request2).getContents();
        if (contents.size() != 2 && contents.size() != 3) {
            return false;
        }
        for (DiffContent content2 : contents) {
            if (ExternalDiffToolUtil.canCreateFile(content2)) continue;
            return false;
        }
        return true;
    }
}

