/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.BinaryMergeRequest;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryMergeRequestImpl
extends BinaryMergeRequest {
    private static final Logger LOG = Logger.getInstance(BinaryMergeRequestImpl.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final FileContent myFile;
    @NotNull
    private final List<DiffContent> myContents;
    @NotNull
    private final List<byte[]> myByteContents;
    private final byte @NotNull [] myOriginalContent;
    @Nullable
    private final String myTitle;
    @NotNull
    private final List<String> myTitles;

    public BinaryMergeRequestImpl(@Nullable Project project, @NotNull FileContent file2, byte @NotNull [] originalContent, @NotNull List<DiffContent> contents, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles) {
        assert (byteContents.size() == 3);
        assert (contents.size() == 3);
        assert (contentTitles.size() == 3);
        this.myProject = project;
        this.myFile = file2;
        this.myOriginalContent = originalContent;
        this.myByteContents = byteContents;
        this.myContents = contents;
        this.myTitle = title;
        this.myTitles = contentTitles;
        this.onAssigned(true);
    }

    @NotNull
    public FileContent getOutputContent() {
        return this.myFile;
    }

    @NotNull
    public List<DiffContent> getContents() {
        return this.myContents;
    }

    @NotNull
    public List<byte[]> getByteContents() {
        return this.myByteContents;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public List<String> getContentTitles() {
        return this.myTitles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyResult(@NotNull MergeResult result2) {
        try {
            byte[] applyContent;
            switch (result2) {
                case CANCEL: {
                    applyContent = MergeUtil.shouldRestoreOriginalContentOnCancel((MergeRequest)this) ? this.myOriginalContent : null;
                    break;
                }
                case LEFT: {
                    applyContent = (byte[])ThreeSide.LEFT.select(this.myByteContents);
                    break;
                }
                case RIGHT: {
                    applyContent = (byte[])ThreeSide.RIGHT.select(this.myByteContents);
                    break;
                }
                case RESOLVED: {
                    applyContent = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(result2.toString());
                }
            }
            if (applyContent != null) {
                try {
                    VirtualFile file2 = this.myFile.getFile();
                    if (!file2.isValid()) {
                        throw new IOException(IdeBundle.message((String)"error.file.not.found.message", (Object[])new Object[]{file2.getPresentableUrl()}));
                    }
                    if (!DiffUtil.makeWritable(this.myProject, file2)) {
                        throw new IOException(UIBundle.message((String)"file.is.read.only.message.text", (Object[])new Object[]{file2.getPresentableUrl()}));
                    }
                    WriteCommandAction.writeCommandAction(null).run(() -> file2.setBinaryContent(applyContent));
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)DiffBundle.message((String)"can.t.finish.merge.resolve", (Object[])new Object[0]));
                }
            }
            MergeCallback.getCallback((MergeRequest)this).applyResult(result2);
        }
        finally {
            this.onAssigned(false);
        }
    }

    public void resultRetargeted() {
        this.onAssigned(false);
    }

    private void onAssigned(boolean assigned) {
        this.myFile.onAssigned(assigned);
        for (DiffContent content2 : this.myContents) {
            content2.onAssigned(assigned);
        }
    }
}

