/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MessageMergeViewer
implements MergeTool.MergeViewer {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final JPanel myPanel;

    MessageMergeViewer(@NotNull MergeContext context, @NotNull @Nls String message) {
        this.myMergeContext = context;
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)DiffUtil.createMessagePanel(message), "Center");
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public MergeTool.ToolbarComponents init() {
        return new MergeTool.ToolbarComponents();
    }

    @Nullable
    public Action getResolveAction(final @NotNull MergeResult result2) {
        if (result2 != MergeResult.CANCEL) {
            return null;
        }
        String caption = MergeUtil.getResolveActionTitle(result2, null, this.myMergeContext);
        return new AbstractAction(caption){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageMergeViewer.this.myMergeContext.finishMerge(result2);
            }
        };
    }

    public void dispose() {
    }
}

