/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DocumentContentBase
extends DiffContentBase
implements DocumentContent {
    @Nullable
    private final Project myProject;
    @NotNull
    private final Document myDocument;

    public DocumentContentBase(@Nullable Project project, @NotNull Document document) {
        this.myProject = project;
        this.myDocument = document;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Document getDocument() {
        return this.myDocument;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull LineCol position) {
        if (!DiffUtil.canNavigateToFile(this.myProject, this.getHighlightFile())) {
            return null;
        }
        return new MyNavigatable(this.myProject, this.getHighlightFile(), this.getDocument(), position);
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.getNavigatable(new LineCol(0));
    }

    private static class MyNavigatable
    implements Navigatable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VirtualFile myTargetFile;
        @NotNull
        private final Document myDocument;
        @NotNull
        private final LineCol myPosition;

        MyNavigatable(@NotNull Project project, @NotNull VirtualFile targetFile, @NotNull Document document, @NotNull LineCol position) {
            this.myProject = project;
            this.myTargetFile = targetFile;
            this.myDocument = document;
            this.myPosition = position;
        }

        public void navigate(boolean requestFocus) {
            OpenFileDescriptor descriptor2;
            Document targetDocument = FileDocumentManager.getInstance().getDocument(this.myTargetFile);
            LineCol targetPosition = MyNavigatable.translatePosition(this.myDocument, targetDocument, this.myPosition);
            Object object = descriptor2 = targetDocument != null ? PsiNavigationSupport.getInstance().createNavigatable(this.myProject, this.myTargetFile, targetPosition.toOffset(targetDocument)) : new OpenFileDescriptor(this.myProject, this.myTargetFile, targetPosition.line, targetPosition.column);
            if (descriptor2.canNavigate()) {
                descriptor2.navigate(true);
            }
        }

        public boolean canNavigate() {
            return this.myTargetFile.isValid();
        }

        public boolean canNavigateToSource() {
            return false;
        }

        @NotNull
        private static LineCol translatePosition(@NotNull Document fromDocument, @Nullable Document toDocument, @NotNull LineCol position) {
            try {
                if (toDocument == null) {
                    return position;
                }
                int targetLine = Diff.translateLine((CharSequence)fromDocument.getCharsSequence(), (CharSequence)toDocument.getCharsSequence(), (int)position.line, (boolean)true);
                return new LineCol(targetLine, position.column);
            }
            catch (FilesTooBigForDiffException ignore) {
                return position;
            }
        }
    }
}

