/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.ChangeDiffIterableBase;
import com.intellij.diff.util.Range;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

class RangesDiffIterable
extends ChangeDiffIterableBase {
    @NotNull
    private final Collection<? extends Range> myRanges;

    RangesDiffIterable(@NotNull Collection<? extends Range> ranges, int length1, int length2) {
        super(length1, length2);
        this.myRanges = ranges;
    }

    @Override
    @NotNull
    protected ChangeDiffIterableBase.ChangeIterable createChangeIterable() {
        return new RangesChangeIterable(this.myRanges);
    }

    private static class RangesChangeIterable
    implements ChangeDiffIterableBase.ChangeIterable {
        private final Iterator<? extends Range> myIterator;
        private Range myLast;

        private RangesChangeIterable(@NotNull Collection<? extends Range> ranges) {
            this.myIterator = ranges.iterator();
            this.next();
        }

        @Override
        public boolean valid() {
            return this.myLast != null;
        }

        @Override
        public void next() {
            this.myLast = this.myIterator.hasNext() ? this.myIterator.next() : null;
        }

        @Override
        public int getStart1() {
            return this.myLast.start1;
        }

        @Override
        public int getStart2() {
            return this.myLast.start2;
        }

        @Override
        public int getEnd1() {
            return this.myLast.end1;
        }

        @Override
        public int getEnd2() {
            return this.myLast.end2;
        }
    }
}

