/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.ui;

import com.intellij.diagnostic.EventWatcher;
import com.intellij.diagnostic.RunnablesListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SortOrder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class EventWatcherToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    @NotNull
    public static final String TOOL_WINDOW_ID = "Event Watcher";

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        TableProvidingListener listener2 = new TableProvidingListener();
        project.getMessageBus().connect((Disposable)project).subscribe(TableProvidingListener.TOPIC, (Object)listener2);
        listener2.getContents().forEach(arg_0 -> ((ContentManager)toolWindow.getContentManager()).addContent(arg_0));
    }

    public void init(@NotNull ToolWindow toolWindow) {
        toolWindow.setStripeTitle(TOOL_WINDOW_ID);
    }

    public boolean isApplicable(@NotNull Project project) {
        return EventWatcher.isEnabled();
    }

    private static class TableProvidingListener
    implements RunnablesListener {
        @NotNull
        private final ListTableModel<RunnablesListener.InvocationsInfo> myInvocationsModel = new ListTableModel(new ColumnInfo[]{FunctionBasedColumnInfo.access$000("Runnable/Callable", RunnablesListener.InvocationsInfo::getFQN), new FunctionBasedColumnInfo("Average duration, ms", Double.TYPE, RunnablesListener.InvocationsInfo::getAverageDuration), new FunctionBasedColumnInfo("Count", Integer.TYPE, RunnablesListener.InvocationsInfo::getCount)}, new ArrayList(), 1, SortOrder.DESCENDING);
        @NotNull
        private final ListTableModel<RunnablesListener.InvocationDescription> myRunnablesModel = new ListTableModel(new ColumnInfo[]{FunctionBasedColumnInfo.access$000("Runnable", RunnablesListener.InvocationDescription::getProcessId), new FunctionBasedColumnInfo("Duration, ms", Long.TYPE, RunnablesListener.InvocationDescription::getDuration), new FunctionBasedColumnInfo("Started at", String.class, description -> new SimpleDateFormat().format(new Date(description.getStartedAt())), Comparator.comparingLong(RunnablesListener.InvocationDescription::getStartedAt))});
        @NotNull
        private final ListTableModel<RunnablesListener.WrapperDescription> myWrappersModel = new ListTableModel(new ColumnInfo[]{FunctionBasedColumnInfo.access$000("Runnable/Callable", RunnablesListener.WrapperDescription::getFQN), new FunctionBasedColumnInfo("Usages count", Integer.TYPE, RunnablesListener.WrapperDescription::getUsagesCount)});
        @NotNull
        private final ListTableModel<RunnablesListener.LockAcquirementDescription> myAcquirementsModel = new ListTableModel(new ColumnInfo[]{FunctionBasedColumnInfo.access$000("Runnable", RunnablesListener.LockAcquirementDescription::getFQN), new FunctionBasedColumnInfo("Reads", Long.TYPE, RunnablesListener.LockAcquirementDescription::getReads), new FunctionBasedColumnInfo("Writes", Long.TYPE, RunnablesListener.LockAcquirementDescription::getWrites), new FunctionBasedColumnInfo("Write intents", Long.TYPE, RunnablesListener.LockAcquirementDescription::getWriteIntents)});
        @NotNull
        private final List<Content> myContents = Arrays.asList(TableProvidingListener.createTableContent("Invocations", this.myInvocationsModel), TableProvidingListener.createTableContent("Runnables", this.myRunnablesModel), TableProvidingListener.createTableContent("Wrappers", this.myWrappersModel), TableProvidingListener.createTableContent("Locks", this.myAcquirementsModel));

        TableProvidingListener() {
        }

        @Override
        public void runnablesProcessed(@NotNull Collection<RunnablesListener.InvocationDescription> invocations, @NotNull Collection<RunnablesListener.InvocationsInfo> infos, @NotNull Collection<RunnablesListener.WrapperDescription> wrappers) {
            this.myRunnablesModel.addRows(invocations);
            this.myInvocationsModel.setItems(new ArrayList<RunnablesListener.InvocationsInfo>(infos));
            this.myWrappersModel.setItems(new ArrayList<RunnablesListener.WrapperDescription>(wrappers));
        }

        @Override
        public void locksAcquired(@NotNull Collection<RunnablesListener.LockAcquirementDescription> acquirements) {
            this.myAcquirementsModel.setItems(new ArrayList<RunnablesListener.LockAcquirementDescription>(acquirements));
        }

        @NotNull
        List<Content> getContents() {
            return this.myContents;
        }

        @NotNull
        private static Content createTableContent(@NotNull String tableName, @NotNull ListTableModel<?> tableModel) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)new JBScrollPane((Component)new TableView(tableModel)), "Center");
            return ContentFactory.SERVICE.getInstance().createContent((JComponent)panel2, tableName, false);
        }

        private static class FunctionBasedColumnInfo<Item extends Comparable<? super Item>, Aspect extends Comparable<? super Aspect>>
        extends ColumnInfo<Item, Aspect> {
            @NotNull
            private final Class<? extends Aspect> myColumnClass;
            @NotNull
            private final Function<? super Item, ? extends Aspect> myExtractor;
            @NotNull
            private final Comparator<Item> myComparator;

            private FunctionBasedColumnInfo(@NotNull String name, @NotNull Class<? extends Aspect> columnClass, @NotNull Function<? super Item, ? extends Aspect> extractor, @NotNull Comparator<Item> comparator2) {
                super(name);
                this.myColumnClass = columnClass;
                this.myExtractor = extractor;
                this.myComparator = comparator2;
            }

            private FunctionBasedColumnInfo(@NotNull String name, @NotNull Class<? extends Aspect> columnClass, @NotNull Function<? super Item, ? extends Aspect> extractor) {
                this(name, columnClass, extractor, Comparator.comparing(extractor));
            }

            @Nullable
            public final Aspect valueOf(@NotNull Item item) {
                return (Aspect)((Comparable)this.myExtractor.apply(item));
            }

            @NotNull
            public final Class<? extends Aspect> getColumnClass() {
                return this.myColumnClass;
            }

            @NotNull
            public final Comparator<Item> getComparator() {
                return this.myComparator;
            }

            private static <Item extends Comparable<? super Item>> FunctionBasedColumnInfo<Item, String> stringBased(@NotNull String name, @NotNull Function<? super Item, String> extractor) {
                return new FunctionBasedColumnInfo<Item, String>(name, String.class, extractor, Comparator.naturalOrder());
            }

            static /* synthetic */ FunctionBasedColumnInfo access$000(String x0, Function x1) {
                return FunctionBasedColumnInfo.stringBased(x0, x1);
            }
        }
    }
}

