/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Property<T extends PropertiesContainer> {
    private final Property myParent;
    private final String myName;
    private boolean myImportant;
    private boolean myExpert;
    private boolean myDeprecated;

    public Property(@Nullable Property parent, @NotNull String name) {
        this.myParent = parent;
        this.myName = name;
    }

    @Nullable
    public Property<T> createForNewPresentation() {
        return this.createForNewPresentation(this.myParent, this.myName);
    }

    @Nullable
    public Property<T> createForNewPresentation(@Nullable Property parent, @NotNull String name) {
        return null;
    }

    @Nullable
    public String getGroup() {
        return null;
    }

    @Nullable
    public final Property getParent() {
        return this.myParent;
    }

    @NotNull
    public List<? extends Property<T>> getChildren(@Nullable T container2) {
        return Collections.emptyList();
    }

    @NotNull
    public String getPath() {
        return this.myParent == null ? this.myName : this.myParent.getPath() + "/" + this.myName;
    }

    @Nullable
    public Object getValue(@NotNull T container2) throws Exception {
        return null;
    }

    public void setValue(@NotNull T container2, @Nullable Object value2) throws Exception {
    }

    public boolean showAsDefault(@NotNull T container2) throws Exception {
        return this.isDefaultRecursively(container2);
    }

    public final boolean isDefaultRecursively(@NotNull T container2) throws Exception {
        if (!this.isDefaultValue(container2)) {
            return false;
        }
        for (Property<T> child2 : this.getChildren(container2)) {
            if (child2.isDefaultRecursively(container2)) continue;
            return false;
        }
        return true;
    }

    public boolean isDefaultValue(@NotNull T container2) throws Exception {
        return true;
    }

    public void setDefaultValue(@NotNull T container2) throws Exception {
    }

    public boolean availableFor(List<PropertiesContainer> components) {
        return true;
    }

    public boolean needRefreshPropertyList(@NotNull T container2, @Nullable Object oldValue, @Nullable Object newValue2) throws Exception {
        return false;
    }

    public boolean needRefreshPropertyList() {
        return false;
    }

    public boolean closeEditorDuringRefresh() {
        return false;
    }

    @NotNull
    public Transferable doCopy(@NotNull T container2, @NotNull Object commonValue) {
        return new TextTransferable(commonValue.toString());
    }

    @NotNull
    public final String getName() {
        return this.myName;
    }

    @Nullable
    public String getTooltip() {
        return null;
    }

    public boolean isImportant() {
        return this.myImportant;
    }

    public void setImportant(boolean important) {
        this.myImportant = important;
    }

    public boolean isExpert() {
        return this.myExpert;
    }

    public void setExpert(boolean expert) {
        this.myExpert = expert;
    }

    public boolean isDeprecated() {
        return this.myDeprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.myDeprecated = deprecated;
    }

    @NotNull
    public abstract PropertyRenderer getRenderer();

    @Nullable
    public abstract PropertyEditor getEditor();

    public boolean isEditable(@Nullable T component2) {
        return this.getEditor() != null;
    }

    @Nullable
    public PsiElement getJavadocElement() {
        return null;
    }

    @Nullable
    public String getJavadocText() {
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof Property && this.getPath().equals(((Property)obj).getPath());
    }
}

