/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.DefaultInspectionToolResultExporter;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorComposer;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultInspectionToolPresentation
extends DefaultInspectionToolResultExporter
implements InspectionToolPresentation {
    protected static final Logger LOG = Logger.getInstance(DefaultInspectionToolPresentation.class);
    private DescriptorComposer myComposer;
    private volatile boolean isDisposed;
    @NotNull
    protected GlobalInspectionContextImpl myContext;

    public DefaultInspectionToolPresentation(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextImpl context) {
        super(toolWrapper, context);
        this.myContext = context;
    }

    @Override
    public boolean isSuppressed(RefEntity element2) {
        return this.mySuppressedElements.containsKey(element2);
    }

    @Override
    public boolean isSuppressed(CommonProblemDescriptor descriptor2) {
        return this.mySuppressedElements.containsValue(descriptor2);
    }

    @Override
    public CommonProblemDescriptor @NotNull [] getSuppressedProblems(@NotNull RefEntity entity) {
        return this.mySuppressedElements.getOrDefault(entity, CommonProblemDescriptor.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public GlobalInspectionContextImpl getContext() {
        return this.myContext;
    }

    protected boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void cleanup() {
        this.isDisposed = true;
    }

    @Override
    @NotNull
    public HTMLComposerImpl getComposer() {
        if (this.myComposer == null) {
            this.myComposer = new DescriptorComposer(this);
        }
        return this.myComposer;
    }

    @Override
    public QuickFixAction @NotNull [] getQuickFixes(RefEntity ... refElements) {
        return QuickFixAction.EMPTY;
    }

    @Override
    @Nullable
    public QuickFix findQuickFixes(@NotNull CommonProblemDescriptor problemDescriptor, RefEntity entity, String hint) {
        InspectionProfileEntry tool = this.getToolWrapper().getTool();
        return !(tool instanceof GlobalInspectionTool) ? null : ((GlobalInspectionTool)tool).getQuickFix(hint);
    }

    public CommonProblemDescriptor @Nullable [] getDescriptions(@NotNull RefEntity refEntity) {
        CommonProblemDescriptor[] problems2 = this.getProblemElements().getOrDefault(refEntity, null);
        if (problems2 == null) {
            return null;
        }
        if (!refEntity.isValid()) {
            this.ignoreElement(refEntity);
            return null;
        }
        return problems2;
    }

    public void ignoreElement(@NotNull RefEntity refEntity) {
        this.myProblemElements.remove(refEntity);
    }

    @Override
    public void addProblemElement(@Nullable RefEntity refElement, boolean filterSuppressed, CommonProblemDescriptor ... descriptors) {
        super.addProblemElement(refElement, filterSuppressed, descriptors);
        GlobalInspectionContextImpl context = this.getContext();
        if (context.isViewClosed() || !(refElement instanceof RefElement)) {
            return;
        }
        if (this.myToolWrapper instanceof LocalInspectionToolWrapper && (!ApplicationManager.getApplication().isUnitTestMode() || GlobalInspectionContextImpl.TESTING_VIEW)) {
            context.initializeViewIfNeeded().doWhenDone(() -> context.getView().addProblemDescriptors(this.myToolWrapper, refElement, descriptors));
        }
    }

    @Override
    protected boolean filterResolvedItems() {
        return this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS;
    }
}

