/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReportConverterUtil {
    @Nullable
    public static InspectionsReportConverter getReportConverter(@Nullable String outputFormat) {
        return InspectionsReportConverter.EP_NAME.getExtensionList().stream().filter(converter -> converter.getFormatName().equals(outputFormat)).findFirst().orElse(null);
    }

    @NotNull
    public static Path getResultsDataPath(@NotNull Disposable parentDisposable, @Nullable InspectionsReportConverter reportConverter, @NotNull String outputPath) throws IOException {
        Path resultsDataPath;
        if (!(reportConverter != null && reportConverter.useTmpDirForRawData() || outputPath == null)) {
            resultsDataPath = Paths.get(outputPath, new String[0]);
            Files.createDirectories(resultsDataPath, new FileAttribute[0]);
        } else {
            File tmpDir = FileUtilRt.createTempDirectory((String)"inspections", (String)"data", (boolean)false);
            Disposer.register((Disposable)parentDisposable, () -> FileUtil.delete((File)tmpDir));
            resultsDataPath = tmpDir.toPath();
        }
        return resultsDataPath;
    }
}

