/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.ui.search.SearchableOptionContributor;
import com.intellij.ide.ui.search.SearchableOptionProcessor;
import com.intellij.profile.codeInspection.ui.header.InspectionToolsConfigurable;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class InspectionSearchableOptionContributor
extends SearchableOptionContributor {
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");

    public void processOptions(@NotNull SearchableOptionProcessor processor2) {
        for (InspectionToolWrapper<?, ?> toolWrapper : InspectionToolRegistrar.getInstance().createTools()) {
            String hit = toolWrapper.getDisplayName();
            processor2.addOptions(toolWrapper.getDisplayName(), toolWrapper.getShortName(), hit, "Errors", InspectionToolsConfigurable.getInspectionsDisplayName(), false);
            for (String group : toolWrapper.getGroupPath()) {
                processor2.addOptions(group, toolWrapper.getShortName(), hit, "Errors", InspectionToolsConfigurable.getInspectionsDisplayName(), false);
            }
            String description = toolWrapper.loadDescription();
            if (description == null) continue;
            String descriptionText = HTML_PATTERN.matcher(description).replaceAll(" ");
            processor2.addOptions(descriptionText, toolWrapper.getShortName(), hit, "Errors", InspectionToolsConfigurable.getInspectionsDisplayName(), false);
        }
    }
}

